/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.document.DocumentReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextExtractorJob
extends FutureResult
implements Runnable {
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.TextExtractorJob");
    private final Runnable cmd;
    private final String type;
    private transient boolean timedOut = false;
    private transient boolean discarded = false;

    public TextExtractorJob(final DocumentReader extractor, final InputStream stream, String type, final String encoding) {
        this.type = type;
        this.cmd = this.setter(new Callable(){

            public Object call() throws Exception {
                Reader r = new StringReader(extractor.getContentAsText(stream, encoding));
                if (r != null) {
                    if (TextExtractorJob.this.discarded) {
                        ((Reader)r).close();
                        r = null;
                    } else if (TextExtractorJob.this.timedOut) {
                        r = TextExtractorJob.this.getSwappedOutReader(r);
                    }
                }
                return r;
            }
        });
    }

    public Reader getReader(long timeout) {
        Reader reader = null;
        try {
            reader = (Reader)this.timedGet(timeout);
        }
        catch (InterruptedException e) {
            if (timeout > 0L) {
                log.debug("Text extraction for {} timed out (>{}ms).", (Object)this.type, (Object)new Long(timeout));
                this.timedOut = true;
            }
        }
        catch (InvocationTargetException e) {
            log.warn("Exception while indexing binary property: " + e.getCause());
            log.debug("Dump: ", e.getCause());
        }
        return reader;
    }

    void discard() {
        this.discarded = true;
        Reader r = (Reader)this.peek();
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException e) {
                log.warn("Exception when trying to discard extractor job: " + e);
            }
        }
    }

    public String toString() {
        return "TextExtractorJob for " + this.type;
    }

    public void run() {
        this.cmd.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader getSwappedOutReader(Reader r) {
        BufferedWriter out;
        File temp;
        try {
            temp = PrivilegedFileHelper.createTempFile((String)"extractor", null);
        }
        catch (IOException e) {
            return r;
        }
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)PrivilegedFileHelper.fileOutputStream((File)temp), ENCODING_UTF8));
        }
        catch (IOException e) {
            if (!temp.delete()) {
                PrivilegedFileHelper.deleteOnExit((File)temp);
            }
            return r;
        }
        InputStream in = null;
        try {
            try {
                ((Writer)out).close();
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                r.close();
                throw throwable;
            }
            r.close();
            return new InputStreamReader(in, ENCODING_UTF8){

                public void close() throws IOException {
                    super.close();
                    if (!temp.delete()) {
                        PrivilegedFileHelper.deleteOnExit((File)temp);
                    }
                }
            };
        }
        catch (IOException e) {
            if (!temp.delete()) {
                PrivilegedFileHelper.deleteOnExit((File)temp);
            }
            return new StringReader("");
        }
    }
}

