/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum CajaWebToolsMessageType implements MessageTypeInt
{
    INCOMPATIBLE_OUTPUT_TYPE("Cannot convert content of type %s to %s.  Outputting HTML instead.", MessageLevel.ERROR),
    UNKNOWN_ELEMENT("%s: Unknown element %s", MessageLevel.LINT),
    UNKNOWN_ATTRIB("%s: Unknown attribute %s on <%s>", MessageLevel.LINT),
    BAD_ATTRIB_VALUE("%s: attribute %s has bad value: %s", MessageLevel.LINT);

    private final String formatString;
    private final MessageLevel level;
    private final int paramCount;

    private CajaWebToolsMessageType(String formatString, MessageLevel level) {
        this.formatString = formatString;
        this.level = level;
        this.paramCount = MessageType.formatStringArity(formatString);
    }

    @Override
    public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
        MessageType.formatMessage(this.formatString, parts, context, out);
    }

    @Override
    public MessageLevel getLevel() {
        return this.level;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }
}

