/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.util.Charsets;
import com.google.caja.util.Executor;
import com.google.caja.util.Sets;
import com.google.caja.util.SetupUrlHandlers;
import com.google.caja.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RhinoExecutor
implements Executor {
    private final Executor.Input[] srcs;
    private static final Set<String> OBJECT_CLASS_MEMBERS = Sets.newHashSet("class", "clone", "equals", "finalize", "getClass", "hashCode", "notify", "notifyAll", "wait");
    private static final Set<String> CLASS_WHITELIST = Sets.newHashSet("junit.framework.AssertionFailedError", Boolean.class.getName(), ByteArrayInputStream.class.getName(), Connection.class.getName(), Character.class.getName(), DOMException.class.getName(), Double.class.getName(), EcmaError.class.getName(), EvaluatorException.class.getName(), Float.class.getName(), Integer.class.getName(), JavaScriptException.class.getName(), Long.class.getName(), PrintStream.class.getName(), RhinoException.class.getName(), ScriptPowerBox.class.getName(), Short.class.getName(), String.class.getName(), Timer.class.getName(), URI.class.getName(), WeakHashMap.class.getName(), WrappedException.class.getName(), "org.apache.xerces.*");
    private static final ContextFactory SANDBOXINGFACTORY = new ContextFactory(){

        protected Context makeContext() {
            Context context = super.makeContext();
            context.setClassShutter(new ClassShutter(){

                public boolean visibleToScripts(String fullClassName) {
                    if (fullClassName.endsWith("SandBoxSafe")) {
                        return true;
                    }
                    if (CLASS_WHITELIST.contains(fullClassName)) {
                        return true;
                    }
                    int dot = fullClassName.length();
                    while ((dot = fullClassName.lastIndexOf(46, dot - 1)) >= 0) {
                        if (!CLASS_WHITELIST.contains(fullClassName.substring(0, dot + 1) + "*")) continue;
                        return true;
                    }
                    if (fullClassName.matches("[A-Z]")) {
                        System.err.println("RhinoExecutor denied access to " + fullClassName);
                    }
                    return false;
                }
            });
            context.setWrapFactory(new WrapFactory(){

                public Object wrap(Context cx, Scriptable scope, Object javaObject, Class staticType) {
                    if (javaObject != null && (javaObject instanceof Class || javaObject instanceof ClassLoader || "java.lang.reflect".equals(javaObject.getClass().getPackage().getName()))) {
                        return Context.getUndefinedValue();
                    }
                    if (javaObject instanceof Object[]) {
                        Object[] javaArray = (Object[])javaObject;
                        int n = javaArray.length;
                        Object[] wrappedElements = new Object[n];
                        Class<?> compType = javaArray.getClass().getComponentType();
                        int i = n;
                        while (--i >= 0) {
                            wrappedElements[i] = this.wrap(cx, scope, javaArray[i], compType);
                        }
                        NativeArray jsArray = new NativeArray(wrappedElements);
                        jsArray.setPrototype(ScriptableObject.getClassPrototype((Scriptable)scope, (String)"Array"));
                        jsArray.setParentScope(scope);
                        return jsArray;
                    }
                    return super.wrap(cx, scope, javaObject, staticType);
                }

                public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
                    return new NativeJavaObject(scope, javaObject, staticType){

                        public Object get(String name, Scriptable start) {
                            if (OBJECT_CLASS_MEMBERS.contains(name)) {
                                return NOT_FOUND;
                            }
                            return super.get(name, start);
                        }
                    };
                }
            });
            return context;
        }

        public boolean hasFeature(Context c, int feature) {
            switch (feature) {
                case 10: {
                    return true;
                }
                case 6: {
                    return false;
                }
                case 13: {
                    return false;
                }
            }
            return super.hasFeature(c, feature);
        }
    };
    private static final ScheduledExecutorService executorService;
    private static final Object[] ZERO_ARGS;

    public RhinoExecutor(Executor.Input[] srcs) {
        this.srcs = (Executor.Input[])srcs.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Map<String, ?> actuals, Class<T> expectedResultType) throws Executor.AbnormalExitException {
        if (SANDBOXINGFACTORY != ContextFactory.getGlobal()) {
            throw new IllegalStateException();
        }
        Context context = SANDBOXINGFACTORY.enterContext();
        context.setOptimizationLevel(-1);
        try {
            T t = this.runInContext(context, actuals, expectedResultType);
            return t;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runInContext(Context context, Map<String, ?> actuals, Class<T> expectedResultType) throws Executor.AbnormalExitException {
        ScriptableObject globalScope = context.initStandardObjects();
        try {
            globalScope.defineProperty("scriptEngine___", (Object)new ScriptPowerBox(context, (Scriptable)globalScope), 2);
            for (Map.Entry<String, ?> e : actuals.entrySet()) {
                globalScope.defineProperty(e.getKey(), Context.javaToJS(e.getValue(), (Scriptable)globalScope), 2);
            }
            Object result = null;
            Context context2 = context;
            synchronized (context2) {
                for (Executor.Input src : this.srcs) {
                    String inputRead = RhinoExecutor.drain(src.input);
                    try {
                        result = context.evaluateReader((Scriptable)globalScope, (Reader)new StringReader(inputRead), src.source, 1, null);
                    }
                    catch (EcmaError ex) {
                        System.err.println(RhinoExecutor.withLineNums(inputRead));
                        throw new Executor.AbnormalExitException(ex);
                    }
                    if (inputRead.length() <= 500) continue;
                    inputRead = "<ABREVIATED>";
                }
                if (result == null) {
                    return null;
                }
                if (!expectedResultType.isInstance(result)) {
                    result = Context.jsToJava(result, expectedResultType);
                }
            }
            return expectedResultType.cast(result);
        }
        catch (IOException ex) {
            throw new Executor.AbnormalExitException(ex);
        }
    }

    private static final String drain(Reader r) throws IOException {
        int n;
        char[] buf = new char[4096];
        StringBuilder sb = new StringBuilder();
        while ((n = r.read(buf)) >= 0) {
            sb.append(buf, 0, n);
        }
        r.close();
        return sb.toString();
    }

    private static final String withLineNums(String source) {
        StringBuilder sb = new StringBuilder();
        int ln = 0;
        for (String line : source.split("\r\n?|\n")) {
            sb.append(String.format("%04d: %s\n", ++ln, line));
        }
        return sb.toString();
    }

    public static void enableContentUrls() {
        SetupUrlHandlers.init();
    }

    static {
        ContextFactory.initGlobal((ContextFactory)SANDBOXINGFACTORY);
        executorService = Executors.newSingleThreadScheduledExecutor();
        ZERO_ARGS = new Object[0];
    }

    public static final class Connection {
        private final int status;
        private final String statusText;
        private final String responseBody;

        Connection(int status, String statusText, String responseBody) {
            this.status = status;
            this.statusText = statusText;
            this.responseBody = responseBody;
        }

        public int getStatus() {
            return this.status;
        }

        public String getStatusText() {
            return this.statusText;
        }

        public String getResponseBody() {
            return this.responseBody;
        }
    }

    public static class Timer {
        private final Context cx;
        private final Scriptable global;
        private final Scriptable scope;
        private final Function fn;
        private final long deltaMillis;
        private ScheduledFuture<?> future;

        Timer(Context cx, Scriptable global, Scriptable scope, Function fn, double deltaMillis) {
            this.cx = cx;
            this.global = global;
            this.scope = scope;
            this.fn = fn;
            this.deltaMillis = (long)deltaMillis;
        }

        public void start() {
            if (this.future != null) {
                throw new IllegalStateException();
            }
            this.future = executorService.scheduleWithFixedDelay(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Context context = Timer.this.cx;
                    synchronized (context) {
                        Timer.this.fn.call(Timer.this.cx, Timer.this.scope, Timer.this.global, ZERO_ARGS);
                    }
                }
            }, this.deltaMillis, this.deltaMillis, TimeUnit.MILLISECONDS);
        }

        public void stop() {
            if (this.future == null) {
                throw new IllegalStateException();
            }
            this.future.cancel(false);
            this.future = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScriptPowerBox {
        private final Context cx;
        private final Scriptable global;

        ScriptPowerBox(Context cx, Scriptable global) {
            this.cx = cx;
            this.global = global;
        }

        public void dontEnum(Object obj, String name) {
            if (obj instanceof ScriptableObject) {
                ((ScriptableObject)obj).setAttributes(name, 2);
            }
        }

        public URI currentLocation() {
            return new File("./").toURI();
        }

        public URI uri(String s) {
            return URI.create(s);
        }

        public Timer timer(Function fn, double delta) {
            return new Timer(this.cx, this.global, this.global, fn, delta);
        }

        public Object parseDom(InputStream in) throws IOException, SAXException {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            }
            catch (ParserConfigurationException ex) {
                throw new SomethingWidgyHappenedError(ex);
            }
        }

        public InputStream streamFromString(String str) {
            try {
                return new ByteArrayInputStream(str.getBytes(Charsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException ex) {
                throw new SomethingWidgyHappenedError(ex);
            }
        }

        public Map<Object, Object> weakMap() {
            return new WeakHashMap<Object, Object>();
        }

        public Connection openConnection(URI uri, Object headers, Object responseHeaders) {
            String statusText;
            int status;
            String responseBody;
            String scheme = Strings.toLowerCase(uri.getScheme());
            try {
                if ("file".equals(scheme)) {
                    int n;
                    String path = uri.getPath();
                    InputStreamReader in = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(path), "UTF-8");
                    StringBuilder sb = new StringBuilder();
                    char[] buf = new char[4096];
                    while ((n = in.read(buf)) > 0) {
                        sb.append(buf, 0, n);
                    }
                    responseBody = sb.toString();
                } else if ("content".equals(scheme)) {
                    responseBody = uri.getSchemeSpecificPart();
                } else {
                    throw new IllegalArgumentException(scheme);
                }
                status = 200;
                statusText = "OK";
            }
            catch (FileNotFoundException ex) {
                status = 404;
                statusText = "Not Found";
                responseBody = "";
            }
            catch (IOException ex) {
                status = 500;
                statusText = "Access Denied";
                responseBody = "";
            }
            return new Connection(status, statusText, responseBody);
        }
    }
}

