/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service;

import org.exoplatform.contact.service.Utils;
import org.exoplatform.contact.service.impl.JCRDataStorage;

public class ContactFilter {
    private String[] categories;
    private String[] tag;
    private String subject;
    private String body;
    private String viewQuery;
    private String accountPath;
    private String orderBy;
    private boolean isAscending = true;
    private String text = null;
    private String fullName;
    private String firstName;
    private String lastName;
    private String nickName;
    private String gender;
    private String jobTitle;
    private String emailAddress;
    private String isOwner = null;
    private String username = null;
    private String type = null;
    private boolean hasEmails = false;
    private boolean isSearchSharedContacts = false;
    private String relate = " and ";
    private int limit = 0;

    public boolean isSearchSharedContacts() {
        return this.isSearchSharedContacts;
    }

    public void setSearchSharedContacts(boolean isSearchSharedContacts) {
        this.isSearchSharedContacts = isSearchSharedContacts;
        this.type = JCRDataStorage.SHARED;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String s) {
        this.username = s;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void searchByAnd(boolean and) {
        this.relate = and ? " and " : " or ";
    }

    public void setText(String fullTextSearch) {
        this.text = fullTextSearch;
    }

    public String getText() {
        return this.text;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String s) {
        this.fullName = s;
    }

    public String isOwner() {
        return this.isOwner;
    }

    public void setOwner(String s) {
        this.isOwner = s;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String s) {
        this.firstName = s;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String s) {
        this.lastName = s;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String s) {
        this.nickName = s;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String s) {
        this.gender = s;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String s) {
        this.jobTitle = s;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String s) {
        this.emailAddress = s;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public void setCategories(String[] s) {
        this.categories = s;
    }

    public String[] getTag() {
        return this.tag;
    }

    public void setTag(String[] tag) {
        this.tag = tag;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getViewQuery() {
        return this.viewQuery;
    }

    public void setViewQuery(String query) {
        this.viewQuery = query;
    }

    public String getAccountPath() {
        return this.accountPath;
    }

    public void setAccountPath(String path) {
        this.accountPath = path;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public void setAscending(boolean b) {
        this.isAscending = b;
    }

    public void setHasEmails(boolean hasEmails) {
        this.hasEmails = hasEmails;
    }

    public String getStatement() throws Exception {
        StringBuffer queryString = new StringBuffer("/jcr:root").append(this.accountPath == null ? "" : this.accountPath).append("//element(*,exo:contact)");
        boolean hasConjuntion = false;
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.hasEmails) {
            stringBuffer.append("( ");
        }
        if (!Utils.isEmpty(this.text)) {
            String textUpper = this.text.toUpperCase();
            stringBuffer.append("((jcr:contains(., '").append(this.text).append("')) or").append(" fn:upper-case(@exo:id) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:fullName) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:firstName) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:lastName) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:nickName) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:jobTitle) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:workAddress) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:workCity) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:workState_province) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:workPhone1) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:workPhone2) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:workFax) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:mobilePhone) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:webPage) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:exoId) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:googleId) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:msnId) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:aolId) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:yahooId) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:icrId) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:skypeId) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:icqId) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:homeAddress) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:homeCity) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:homeState_province) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:homePostalCode) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:homeCountry) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:homePhone1) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:homePhone2) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:homeFax) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:personalSite) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:note) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:emailAddress) = '").append(textUpper).append("' or").append(" fn:upper-case(@exo:workCountry) = '").append(textUpper).append("')");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.categories)) {
            if (hasConjuntion) {
                stringBuffer.append(this.relate + "(");
            } else {
                stringBuffer.append("(");
            }
            for (int i = 0; i < this.categories.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:categories='").append(this.categories[i]).append("'");
                    continue;
                }
                stringBuffer.append(" or @exo:categories='").append(this.categories[i]).append("'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.tag)) {
            if (hasConjuntion) {
                stringBuffer.append(this.relate + "(");
            } else {
                stringBuffer.append("(");
            }
            for (int i = 0; i < this.tag.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:tags='").append(this.tag[i]).append("'");
                    continue;
                }
                stringBuffer.append(" or @exo:tags='").append(this.tag[i]).append("'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.viewQuery)) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append(this.viewQuery);
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.fullName)) {
            if (hasConjuntion) {
                stringBuffer.append(this.relate + "(");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("jcr:like(fn:upper-case(@exo:fullName),'%").append(this.fullName.toUpperCase()).append("%')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.firstName)) {
            if (hasConjuntion) {
                stringBuffer.append(this.relate + "(");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("jcr:like(fn:upper-case(@exo:firstName),'%").append(this.firstName.toUpperCase()).append("%')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.lastName)) {
            if (hasConjuntion) {
                stringBuffer.append(this.relate + "(");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("jcr:like(fn:upper-case(@exo:lastName), '%").append(this.lastName.toUpperCase()).append("%')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.nickName)) {
            if (hasConjuntion) {
                stringBuffer.append(this.relate + "(");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("jcr:like(fn:upper-case(@exo:nickName),'%").append(this.nickName.toUpperCase()).append("%')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.gender)) {
            if (hasConjuntion) {
                stringBuffer.append(this.relate + "(");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:gender='").append(this.gender).append("'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.jobTitle)) {
            if (hasConjuntion) {
                stringBuffer.append(this.relate + "(");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("jcr:like(fn:upper-case(@exo:jobTitle), '%").append(this.jobTitle.toUpperCase()).append("%')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.emailAddress)) {
            if (hasConjuntion) {
                stringBuffer.append(this.relate + "(");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("jcr:like(fn:upper-case(@exo:emailAddress), '%").append(this.emailAddress.toUpperCase()).append("%')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (!Utils.isEmpty(this.isOwner)) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:isOwner='").append(this.isOwner).append("'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.hasEmails) {
            if (hasConjuntion) {
                stringBuffer.append(") and (");
            } else {
                stringBuffer.append(" @exo:id) and (");
            }
            stringBuffer.append("@exo:emailAddress");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        stringBuffer.append("]");
        if (!Utils.isEmpty(this.orderBy)) {
            stringBuffer.append(" order by @exo:").append(this.orderBy);
            if (this.isAscending) {
                stringBuffer.append(" ascending");
            } else {
                stringBuffer.append(" descending");
            }
        }
        if (hasConjuntion) {
            queryString.append(stringBuffer);
        }
        return queryString.toString();
    }
}

