/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.connection.impl;

import com.sun.mail.imap.AppendUID;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.util.MailSSLSocketFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.mail.connection.impl.BaseConnector;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapConnector
extends BaseConnector {
    private static final Log logger = ExoLogger.getLogger((String)"cs.mail.service");
    protected IMAPStore imapStore;

    public ImapConnector(Account account, MailSSLSocketFactory sslSocket) throws Exception {
        Session session = this.getSession(account, sslSocket);
        String protocolName = "imap";
        String emailaddr = account.getIncomingUser();
        if (Utils.isGmailAccount(emailaddr)) {
            protocolName = "imaps";
        }
        this.store_ = session.getStore(protocolName);
        this.openStore(account);
        this.imapStore = (IMAPStore)this.store_;
    }

    @Override
    public Session getSession(Account account, MailSSLSocketFactory sslSocket) throws MessagingException {
        Properties props = System.getProperties();
        props.put("mail.imap.socketFactory.class", "javax.net.SocketFactory");
        props.put("mail.mime.base64.ignoreerrors", "true");
        props.put("mail.imap.socketFactory.fallback", "false");
        if (account.isIncomingSsl() && sslSocket != null) {
            props.put(Utils.IMAP_SSL_FACTORY, sslSocket);
            if (account.getSecureAuthsIncoming().equalsIgnoreCase("starttls")) {
                props.put(Utils.IMAP_SSL_STARTTLS_ENABLE, (Object)true);
            } else {
                props.put(Utils.MAIL_IMAP_SSL_ENABLE, "true");
            }
            props.put(Utils.IMAP_SASL_MECHS, account.getAuthMechsIncoming());
        }
        return Session.getInstance((Properties)props, null);
    }

    public IMAPFolder createFolder(Folder folder) throws MessagingException {
        return this.createFolder(null, folder);
    }

    public IMAPFolder createFolder(Folder parentFolder, Folder folder) throws MessagingException {
        IMAPFolder imapFolder = null;
        if (parentFolder == null) {
            imapFolder = (IMAPFolder)this.imapStore.getFolder(folder.getName());
            if (!imapFolder.exists()) {
                imapFolder.create((int)folder.getType());
            }
        } else {
            IMAPFolder parentImapFolder = this.openFolderForReadWrite(parentFolder.getURLName());
            if (parentImapFolder.exists() && !(imapFolder = (IMAPFolder)parentImapFolder.getFolder(folder.getName())).exists()) {
                imapFolder.create((int)folder.getType());
            }
        }
        return imapFolder;
    }

    public Folder renameFolder(String newName, Folder folder) throws Exception {
        try {
            boolean result = false;
            IMAPFolder folderToBeRenamed = this.openFolderForReadWrite(folder.getURLName());
            if (folderToBeRenamed.exists()) {
                if (folderToBeRenamed.isOpen()) {
                    folderToBeRenamed.close(true);
                }
                IMAPFolder f1 = (IMAPFolder)this.imapStore.getFolder(newName);
                result = folderToBeRenamed.renameTo((javax.mail.Folder)f1);
                folder.setURLName(f1.getURLName().toString());
                folder.setName(newName);
                if (!result) {
                    logger.info((Object)"Error while renaming folder!");
                }
            } else {
                logger.info((Object)"Folder does not exists!");
            }
            return folder;
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exception in method renameFolder", (Throwable)ex);
            }
            return null;
        }
    }

    public int emptyFolder(Folder folder) throws Exception {
        IMAPFolder folderToEmpty = (IMAPFolder)this.imapStore.getFolder(folder.getName());
        javax.mail.Message[] messages = folderToEmpty.getMessagesByUID(0L, -1L);
        int messageCount = messages.length;
        for (int i = 0; i < messageCount; ++i) {
            messages[i].setFlag(Flags.Flag.DELETED, true);
        }
        return messageCount;
    }

    public boolean deleteFolder(Folder folder) throws Exception {
        try {
            boolean result = false;
            URLName url = new URLName(folder.getURLName());
            IMAPFolder folderToBeRemoved = (IMAPFolder)this.imapStore.getFolder(url);
            if (folderToBeRemoved.exists()) {
                if (folderToBeRemoved.isOpen()) {
                    folderToBeRemoved.close(true);
                }
                if (!(result = folderToBeRemoved.delete(true))) {
                    logger.info((Object)"Error while deleting folder!");
                }
            } else {
                logger.info((Object)"Folder does not exists!");
            }
            return result;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List<Message> createMessage(List<Message> msgs, Folder folder) throws Exception {
        IMAPFolder remoteFolder;
        ArrayList<Message> successList;
        block18: {
            if (msgs == null || msgs.size() == 0 || folder == null) {
                return null;
            }
            if (StringUtils.isEmpty((String)folder.getURLName())) {
                folder.setURLName(folder.getName());
            }
            ArrayList<Message> messagesToDelete = new ArrayList<Message>();
            for (Message message : msgs) {
                if (StringUtils.isEmpty((String)message.getUID())) continue;
                messagesToDelete.add(message);
            }
            if (messagesToDelete.size() > 0) {
                this.deleteMessage(messagesToDelete, folder);
            }
            successList = new ArrayList<Message>();
            remoteFolder = null;
            try {
                remoteFolder = this.openFolderForReadWrite(folder.getURLName());
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block18;
                logger.debug((Object)("Cannot open folder name: " + folder.getName() + " with url: " + folder.getURLName()), (Throwable)e);
            }
        }
        if (!remoteFolder.exists()) {
            this.createFolder(folder);
            remoteFolder = this.openFolderForReadWrite(folder.getURLName());
        }
        Properties props = System.getProperties();
        Session session = Session.getInstance((Properties)props, null);
        javax.mail.Message[] messages = new javax.mail.Message[msgs.size()];
        javax.mail.Message[] createdMsgs = null;
        for (int i = 0; i < msgs.size(); ++i) {
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage = Utils.mergeToMimeMessage(msgs.get(i), mimeMessage);
            messages[i] = mimeMessage;
        }
        try {
            createdMsgs = remoteFolder.addMessages(messages);
        }
        catch (MessagingException me) {
            logger.error((Object)"Synchronize message from local to server fail.\n", (Throwable)me);
        }
        if (createdMsgs != null && createdMsgs.length > 0 && createdMsgs.length == msgs.size()) {
            String uid = "";
            for (int l = 0; l < createdMsgs.length; ++l) {
                if (createdMsgs[l] != null) {
                    try {
                        uid = String.valueOf(remoteFolder.getUID(createdMsgs[l]));
                    }
                    catch (MessagingException me) {
                        logger.warn((Object)("Not found UID for \"" + createdMsgs[l].getSubject() + "\"."));
                    }
                    if (Utils.isEmptyField(uid)) {
                        uid = MimeMessageParser.getMsgUID();
                    }
                    msgs.get(l).setId(MimeMessageParser.getMessageId(createdMsgs[l]));
                    msgs.get(l).setUID(uid);
                } else {
                    logger.warn((Object)("Mail server could not append a new UID for message: " + msgs.get(l).getSubject()));
                }
                successList.add(msgs.get(l));
            }
        } else {
            logger.warn((Object)"Not all messages are synchronized with server.");
        }
        return successList;
    }

    public boolean deleteMessage(List<Message> msgs, Folder folder) throws Exception {
        try {
            IMAPFolder remoteFolder = this.openFolderForReadWrite(folder.getURLName());
            if (!remoteFolder.isOpen()) {
                remoteFolder.open(2);
            }
            for (Message msg : msgs) {
                javax.mail.Message message = remoteFolder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                message.setFlag(Flags.Flag.DELETED, true);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public AppendUID[] moveMessage(List<Message> msgs, Folder sourceFolder, Folder desFolder) throws MessagingException {
        if (msgs == null || msgs.size() == 0 || sourceFolder.getId() == desFolder.getId() || sourceFolder == null || desFolder == null) {
            return null;
        }
        IMAPFolder sourceImapFolder = null;
        IMAPFolder desImapFolder = null;
        if (Utils.isEmptyField(sourceFolder.getURLName())) {
            sourceImapFolder = this.createFolder(sourceFolder);
            sourceFolder.setURLName(sourceImapFolder.getURLName().toString());
            sourceImapFolder.open(2);
        } else {
            sourceImapFolder = this.openFolderForReadWrite(sourceFolder.getURLName());
        }
        if (Utils.isEmptyField(desFolder.getURLName())) {
            desImapFolder = this.createFolder(desFolder);
            desFolder.setURLName(desImapFolder.getURLName().toString());
            desImapFolder.open(2);
        } else {
            desImapFolder = this.openFolderForReadWrite(desFolder.getURLName());
        }
        if (sourceImapFolder == null || desImapFolder == null) {
            return null;
        }
        if (sourceImapFolder.isOpen() && desImapFolder.isOpen()) {
            ArrayList<javax.mail.Message> copiedMsgs = new ArrayList<javax.mail.Message>();
            javax.mail.Message msg = null;
            for (Message m : msgs) {
                try {
                    if (m != null && m.getUID() != null) {
                        msg = sourceImapFolder.getMessageByUID(Long.valueOf(m.getUID()).longValue());
                    } else {
                        logger.warn((Object)"Message is null or UID is null.");
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("The UID: \"" + m.getUID() + "\" for message: \"" + m.getSubject() + "\" is not exist on server mail\n"));
                }
                if (msg == null) continue;
                copiedMsgs.add(msg);
            }
            if (copiedMsgs != null && copiedMsgs.size() > 0) {
                javax.mail.Message[] messages = copiedMsgs.toArray(new javax.mail.Message[copiedMsgs.size()]);
                AppendUID[] appendUIDs = desImapFolder.appendUIDMessages(messages);
                Flags flags = new Flags();
                flags.add(Flags.Flag.DELETED);
                sourceImapFolder.setFlags(messages, flags, true);
                sourceImapFolder.expunge();
                desImapFolder.expunge();
                return appendUIDs;
            }
        }
        return null;
    }

    public boolean markIsReadStared(List<Message> msgList, Folder f, Object isRead, Object isStared) throws Exception {
        try {
            Flags.Flag flag = null;
            if (isRead != null) {
                isStared = null;
            } else if (isStared != null) {
                isRead = null;
            }
            IMAPFolder folder = this.openFolderForReadWrite(f.getURLName());
            for (Message msg : msgList) {
                javax.mail.Message message = folder.getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                if (message == null) continue;
                boolean value = false;
                if (isRead != null) {
                    value = Boolean.valueOf(isRead.toString());
                    flag = Flags.Flag.SEEN;
                    message.setFlag(flag, value);
                    continue;
                }
                if (isStared != null) {
                    flag = Flags.Flag.FLAGGED;
                    value = Boolean.valueOf(isStared.toString());
                    message.setFlag(flag, value);
                    continue;
                }
                if (isStared != null || isRead != null) continue;
                message.setFlag(Flags.Flag.SEEN, value);
                message.setFlag(Flags.Flag.FLAGGED, value);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public IMAPFolder openFolderForReadWrite(String folderUrl) throws MessagingException {
        return this.openFolderForReadWrite(new URLName(folderUrl));
    }

    public IMAPFolder openFolderForReadWrite(URLName folderUrl) throws MessagingException {
        IMAPFolder remoteFolder = (IMAPFolder)this.getFolder(folderUrl);
        if (remoteFolder.exists() && !remoteFolder.isOpen()) {
            remoteFolder.open(2);
        }
        return remoteFolder;
    }

    public javax.mail.Message getMessageByUID(String uid, String folderUrl) throws MessagingException {
        IMAPFolder folder = this.openFolderForReadWrite(folderUrl);
        javax.mail.Message message = folder.getMessageByUID(Long.valueOf(uid).longValue());
        return message;
    }

    public long[] importMessageIntoServerMail(String folderUrl, MimeMessage mimeMessage) throws Exception {
        IMAPFolder remoteFolder = this.openFolderForReadWrite(folderUrl);
        javax.mail.Message[] messages = remoteFolder.addMessages(new javax.mail.Message[]{mimeMessage});
        long[] uuids = new long[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            uuids[i] = remoteFolder.getUID(messages[i]);
        }
        return uuids;
    }
}

