/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.ext.replication.PriorityDucplicatedException;
import org.exoplatform.services.jcr.ext.replication.priority.AbstractPriorityChecker;
import org.exoplatform.services.jcr.ext.replication.priority.DynamicPriorityChecker;
import org.exoplatform.services.jcr.ext.replication.priority.GenericPriorityChecker;
import org.exoplatform.services.jcr.ext.replication.priority.StaticPriorityChecker;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.exoplatform.services.jcr.ext.replication.transport.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.transport.StateEvent;
import org.exoplatform.services.jcr.ext.replication.transport.StateListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFailDetector
implements StateListener {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ext.ConnectionFailDetector");
    private static final int VIEW_CHECK = 200;
    private static final int INFORM_TIMOUT = 5000;
    private static final int BEFORE_CHECK = 10000;
    private static final int BEFORE_INIT = 60000;
    private static final int AFTER_INIT = 60000;
    private final ChannelManager channelManager;
    private final String workspaceName;
    private String channelName;
    private ReconectTtread reconectTtread;
    private int lastViewSize = 2;
    private boolean allInited = false;
    private final PersistentDataManager dataManager;
    private final RecoveryManager recoveryManager;
    private final int ownPriority;
    private final String ownName;
    private final List<String> otherPartisipants;
    private final AbstractPriorityChecker priorityChecker;
    private final ViewChecker viewChecker;

    public ConnectionFailDetector(ChannelManager channelManager, PersistentDataManager dataManager, RecoveryManager recoveryManager, int ownPriority, List<String> otherParticipants, String ownName, String priprityType, String workspaceName) {
        this.channelManager = channelManager;
        this.dataManager = dataManager;
        this.workspaceName = workspaceName;
        this.recoveryManager = recoveryManager;
        this.ownPriority = ownPriority;
        this.ownName = ownName;
        this.otherPartisipants = new ArrayList<String>(otherParticipants);
        this.priorityChecker = priprityType.equals("static") ? new StaticPriorityChecker(channelManager, ownPriority, ownName, otherParticipants) : (priprityType.equals("dynamic") ? new DynamicPriorityChecker(channelManager, ownPriority, ownName, otherParticipants) : new GenericPriorityChecker(channelManager, ownPriority, ownName, otherParticipants));
        this.viewChecker = new ViewChecker();
        this.viewChecker.start();
    }

    @Override
    public void onStateChanged(StateEvent event) {
        this.viewChecker.putView(event);
    }

    private void viewAccepted(int viewSize) throws InterruptedException, PriorityDucplicatedException {
        this.priorityChecker.informAll();
        Thread.sleep(5000L);
        if (viewSize > 1) {
            this.allInited = true;
        }
        if (this.allInited) {
            this.lastViewSize = viewSize;
        }
        if (this.priorityChecker.hasDuplicatePriority()) {
            log.info(this.workspaceName + " set read-only");
            this.dataManager.setReadOnly(true);
            throw new PriorityDucplicatedException("The priority was duplicated :  own priority = " + this.ownPriority + ", other priority = " + this.priorityChecker.getOtherPriorities());
        }
        if (this.priorityChecker.isAllOnline()) {
            if (this.reconectTtread != null) {
                this.reconectTtread.setStop(false);
                this.reconectTtread = null;
            }
            this.memberRejoin();
            return;
        }
        if (this.priorityChecker instanceof GenericPriorityChecker) {
            if (this.lastViewSize == 1 && (this.reconectTtread == null || this.reconectTtread.isStoped())) {
                this.reconectTtread = new ReconectTtread(true);
                this.reconectTtread.start();
            }
        } else if (this.priorityChecker instanceof StaticPriorityChecker || this.otherPartisipants.size() == 1) {
            if (log.isDebugEnabled()) {
                log.debug("lastViewSize == 1 && !priorityChecker.isMaxPriority() == " + (this.lastViewSize == 1 && !this.priorityChecker.isMaxPriority()));
                log.debug("lastViewSize > 1 && !priorityChecker.isMaxOnline() == " + (this.lastViewSize > 1 && !this.priorityChecker.isMaxOnline()));
            }
            if (this.lastViewSize == 1 && !this.priorityChecker.isMaxPriority()) {
                if (this.reconectTtread == null || this.reconectTtread.isStoped()) {
                    this.reconectTtread = new ReconectTtread(true);
                    this.reconectTtread.start();
                    this.memberSuspect();
                }
            } else if (this.reconectTtread != null && this.priorityChecker.isAllOnline()) {
                this.reconectTtread.setStop(false);
                this.reconectTtread = null;
            } else if (this.lastViewSize > 1 && !this.priorityChecker.isMaxOnline() && (this.reconectTtread == null || this.reconectTtread.isStoped())) {
                this.reconectTtread = new ReconectTtread(true);
                this.reconectTtread.start();
                this.memberSuspect();
            }
        } else if (this.priorityChecker instanceof DynamicPriorityChecker && this.otherPartisipants.size() > 1) {
            if (this.lastViewSize == 1 && !this.priorityChecker.isMaxPriority()) {
                if (this.reconectTtread == null || this.reconectTtread.isStoped()) {
                    this.reconectTtread = new ReconectTtread(true);
                    this.reconectTtread.start();
                    this.memberSuspect();
                }
            } else if (this.reconectTtread != null && this.priorityChecker.isAllOnline()) {
                this.reconectTtread.setStop(false);
                this.reconectTtread = null;
            }
        }
    }

    public void memberRejoin() {
        if (!(this.priorityChecker instanceof GenericPriorityChecker)) {
            log.info(this.workspaceName + " set not read-only");
            this.dataManager.setReadOnly(false);
        }
        log.info(this.workspaceName + " recovery start ...");
        this.recoveryManager.startRecovery();
    }

    public void memberSuspect() {
        if (!(this.priorityChecker instanceof GenericPriorityChecker)) {
            log.info(this.workspaceName + " set read-only");
            this.dataManager.setReadOnly(true);
        }
    }

    private class ReconectTtread
    extends Thread {
        private boolean isStop;

        public ReconectTtread(boolean isStop) {
            super("ReconectTtread");
            log.info("Thread '" + this.getName() + "' is init ...");
            this.isStop = isStop;
        }

        public void run() {
            log.info("Thread '" + this.getName() + "' is run ...");
            while (this.isStop) {
                try {
                    log.info("Connect to channel : " + ConnectionFailDetector.this.channelName);
                    Thread.sleep(10000L);
                    int curruntOnlin = 1;
                    if (ConnectionFailDetector.this.channelManager.getChannel() != null) {
                        while (ConnectionFailDetector.this.channelManager.getChannel().getView() == null) {
                            Thread.sleep(200L);
                        }
                        curruntOnlin = ConnectionFailDetector.this.channelManager.getChannel().getView().size();
                    }
                    if (this.isStop && (curruntOnlin <= 1 || curruntOnlin > 1 && !ConnectionFailDetector.this.priorityChecker.isMaxOnline())) {
                        ConnectionFailDetector.this.channelManager.disconnect();
                        Thread.sleep(60000L);
                        ConnectionFailDetector.this.channelManager.connect();
                    } else {
                        this.isStop = false;
                    }
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    log.info(e, e);
                }
            }
        }

        public void setStop(boolean isStop) {
            this.isStop = isStop;
        }

        public boolean isStoped() {
            return !this.isStop;
        }
    }

    private class ViewChecker
    extends Thread {
        private final ConcurrentLinkedQueue<Integer> queue;

        public ViewChecker() {
            super("ViewChecker");
            this.queue = new ConcurrentLinkedQueue();
        }

        public void putView(StateEvent event) {
            this.queue.offer(event.getMembers().size());
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Integer viewSize;
                        if ((viewSize = this.queue.poll()) != null) {
                            ConnectionFailDetector.this.viewAccepted(viewSize);
                        }
                        ViewChecker.sleep(400L);
                    }
                }
                catch (PriorityDucplicatedException e) {
                    log.error((Object)"The wrong priority :", e);
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"View check error :", t);
                    continue;
                }
                break;
            }
        }
    }
}

