/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.JCRPageList;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactPageList
extends JCRPageList {
    private String username_;
    private NodeIterator iter_ = null;
    private String value_;
    private String contactType_ = "0";
    private long pageReturn = 0L;
    private Session session_ = null;

    public ContactPageList(String username, long pageSize, String value, String type) throws Exception {
        super(pageSize);
        this.username_ = username;
        this.value_ = value;
        this.contactType_ = type;
        Session session = this.getJCRSession(username);
        if (session != null) {
            this.setAvailablePage(((QueryResultImpl)this.createXPathQuery(session, username, this.value_).execute()).getTotalSize());
        }
    }

    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        Session session = this.getJCRSession(username);
        long totalPage = 0L;
        QueryImpl queryImpl = this.createXPathQuery(session, username, this.value_);
        if (page > 1L) {
            long position = (page - 1L) * pageSize;
            if (this.pageReturn == page) {
                queryImpl.setOffset(position - 1L);
            } else {
                queryImpl.setOffset(position);
            }
        }
        queryImpl.setLimit(pageSize);
        QueryResult result = queryImpl.execute();
        this.iter_ = result.getNodes();
        totalPage = ((QueryResultImpl)result).getTotalSize();
        this.setAvailablePage(totalPage);
        this.currentListPage_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType("exo:contact")) {
                Contact contact = Utils.getContact(currentNode, this.contactType_);
                this.currentListPage_.add(contact);
            }
            ++i;
        }
        this.iter_ = null;
    }

    @Override
    public List<Contact> getAll() throws Exception {
        Session session = this.getJCRSession(this.username_);
        QueryImpl queryImpl = this.createXPathQuery(session, this.username_, this.value_);
        QueryResult result = queryImpl.execute();
        this.iter_ = result.getNodes();
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        while (this.iter_.hasNext()) {
            Node contactNode = this.iter_.nextNode();
            contacts.add(Utils.getContact(contactNode, this.contactType_));
        }
        return contacts;
    }

    public Map<String, String> getEmails() throws Exception {
        Session session = this.getJCRSession(this.username_);
        QueryImpl queryImpl = this.createXPathQuery(session, this.username_, this.value_);
        QueryResult result = queryImpl.execute();
        NodeIterator inter = this.iter_ = result.getNodes();
        LinkedHashMap<String, String> emails = new LinkedHashMap<String, String>();
        while (inter.hasNext()) {
            Node contactNode = inter.nextNode();
            String email = null;
            String fullName = null;
            try {
                email = this.valuesToString(contactNode.getProperty("exo:emailAddress").getValues());
            }
            catch (PathNotFoundException e) {
                email = "";
            }
            try {
                fullName = contactNode.getProperty("exo:fullName").getString();
            }
            catch (PathNotFoundException e) {
                fullName = "";
            }
            emails.put(contactNode.getProperty("exo:id").getString(), fullName + Utils.SPLIT + email);
        }
        return emails;
    }

    @Override
    public void setList(List<Contact> contacts) {
    }

    public void setSession(Session s) {
        this.session_ = s;
    }

    private Session getJCRSession(String username) throws Exception {
        try {
            RepositoryService repositoryService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
            SessionProvider sessionProvider = Utils.createSystemProvider();
            String defaultWS = repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            return sessionProvider.getSession(defaultWS, repositoryService.getCurrentRepository());
        }
        catch (NullPointerException e) {
            return this.session_;
        }
    }

    private QueryImpl createXPathQuery(Session session, String username, String xpath) throws Exception {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return (QueryImpl)queryManager.createQuery(xpath, "xpath");
    }

    private String valuesToString(Value[] values) {
        if (values == null) {
            return null;
        }
        StringBuilder strs = new StringBuilder();
        try {
            for (Value value : values) {
                if (strs.length() == 0) {
                    strs.append(value.getString());
                    continue;
                }
                strs.append(";" + value.getString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strs.toString();
    }
}

