/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.quasiliteral.IllegalReferenceCheckRewriter;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.RewriterTestCase;
import com.google.caja.reporting.MessageLevel;

public class IllegalReferenceCheckRewriterTest
extends RewriterTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.setRewriter(new IllegalReferenceCheckRewriter(this.mq, true));
    }

    public final void testIllegalRefs() throws Exception {
        this.testIllegal("var x__;");
        this.testIllegal("function f__() { }");
        this.testIllegal("var x = function f__() { };");
        this.testIllegal("x__ = 3;");
    }

    public final void testLegalRefs() throws Exception {
        this.testLegal("var x;");
        this.testLegal("function f() { }");
        this.testLegal("var x = function f() { };");
        this.testLegal("x = 3;");
    }

    public final void testNullIdentifiers() throws Exception {
        this.testLegal("function () {}");
    }

    private void testIllegal(String code) throws Exception {
        this.checkAddsMessage(this.js(this.fromString(code)), RewriterMessageType.ILLEGAL_IDENTIFIER_LEFT_OVER, MessageLevel.FATAL_ERROR);
        this.checkSucceeds(QuasiBuilder.substV(code, new Object[0]), null);
    }

    private void testLegal(String code) throws Exception {
        this.checkSucceeds(this.js(this.fromString(code)), null);
    }

    protected Object executePlain(String program) {
        return new Object();
    }

    protected Object rewriteAndExecute(String pre, String program, String post) {
        return new Object();
    }
}

