/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Callback;
import com.google.caja.util.Maps;
import com.google.caja.util.TestUtil;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class ModuleFormatTest
extends CajaTestCase {
    private final Callback<IOException> exHandler = new Callback<IOException>(){

        @Override
        public void handle(IOException e) {
            throw new SomethingWidgyHappenedError(e);
        }
    };

    private final Rewriter makeRewriter() {
        return new CajitaRewriter(TestBuildInfo.getInstance(), this.mq, false);
    }

    public final void testCajoledModuleContents() {
        CajoledModule trivialCajoledModule = (CajoledModule)this.makeRewriter().expand(new UncajoledModule(new Block()));
        this.assertNoErrors();
        Map<String, ParseTreeNode> bindings = Maps.newHashMap();
        ModuleFormatTest.assertTrue((boolean)QuasiBuilder.match("  ({  instantiate: @instantiate,  cajolerName: @cajolerName,  cajolerVersion: @cajolerVersion,  cajoledDate: @cajoledDate})", trivialCajoledModule.getModuleBody(), bindings));
        ModuleFormatTest.assertTrue((boolean)(bindings.get("instantiate") instanceof FunctionConstructor));
        ModuleFormatTest.assertTrue((boolean)(bindings.get("cajolerName") instanceof StringLiteral));
        ModuleFormatTest.assertEquals((Object)"com.google.caja", (Object)bindings.get("cajolerName").getValue());
        ModuleFormatTest.assertTrue((boolean)(bindings.get("cajolerVersion") instanceof StringLiteral));
        ModuleFormatTest.assertEquals((Object)new TestBuildInfo().getBuildVersion(), (Object)bindings.get("cajolerVersion").getValue());
        ModuleFormatTest.assertTrue((boolean)(bindings.get("cajoledDate") instanceof IntegerLiteral));
        ModuleFormatTest.assertEquals((Object)new Long(new TestBuildInfo().getCurrentTime()), (Object)bindings.get("cajoledDate").getValue());
    }

    public final void testCajoledModuleDebugRendering() throws Exception {
        CajoledModule cajoledModule = (CajoledModule)this.makeRewriter().expand(new UncajoledModule(this.js(this.fromResource("testModule.js"))));
        this.assertNoErrors();
        Map<InputSource, CharSequence> originalSource = Collections.singletonMap(new InputSource(new URI(((Object)((Object)this)).getClass().getResource("testModule.js").toExternalForm())), TestUtil.readResource(((Object)((Object)this)).getClass(), "testModule.js"));
        StringBuilder sb = new StringBuilder();
        RenderContext rc = new RenderContext(new Concatenator(sb));
        cajoledModule.renderWithDebugSymbols(originalSource, rc);
        rc.getOut().noMoreTokens();
        ModuleFormatTest.assertEquals((String)TestUtil.readResource(((Object)((Object)this)).getClass(), "testModule.out.js"), (String)sb.toString());
    }

    private CajoledModule makeTestCajoledModule() {
        ObjectConstructor oc = (ObjectConstructor)QuasiBuilder.substV("  ({  instantiate: function() {},  foo: 42})", new Object[0]);
        return new CajoledModule(FilePosition.UNKNOWN, null, Arrays.asList(oc));
    }

    private String render(CajoledModule module, Expression callbackExpression) {
        StringBuilder out = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(out, this.exHandler));
        module.render(callbackExpression, new RenderContext(tc));
        tc.noMoreTokens();
        return out.toString();
    }

    private String renderWithDebugSymbols(CajoledModule module, Expression callbackExpression) {
        StringBuilder out = new StringBuilder();
        Concatenator tc = new Concatenator(out, this.exHandler);
        module.renderWithDebugSymbols(callbackExpression, Maps.<InputSource, CharSequence>newHashMap(), new RenderContext(tc));
        tc.noMoreTokens();
        return out.toString();
    }

    public final void testCajoledModuleRenderingWithCallback() throws Exception {
        String renderedModule = this.render(this.makeTestCajoledModule(), this.jsExpr(this.fromString("foo.bar.baz")));
        Expression reparsedModule = (Expression)this.js(this.fromString(renderedModule)).children().get(0).children().get(0).children().get(0);
        ModuleFormatTest.assertEquals((String)ModuleFormatTest.render(this.jsExpr(this.fromString("foo.bar.baz(___.prepareModule({  instantiate: function() {},  foo: 42}))"))), (String)ModuleFormatTest.render(reparsedModule));
    }

    public final void testCajoledModuleDebugRenderingWithCallback() throws Exception {
        String renderedModule = this.renderWithDebugSymbols(this.makeTestCajoledModule(), this.jsExpr(this.fromString("foo.bar.baz")));
        Expression reparsedModule = (Expression)this.js(this.fromString(renderedModule)).children().get(0).children().get(0).children().get(0);
        Map<String, ParseTreeNode> bindings = Maps.newHashMap();
        ModuleFormatTest.assertTrue((String)ModuleFormatTest.render(reparsedModule), (boolean)QuasiBuilder.match("foo.bar.baz(___.prepareModule({  instantiate: function() {},  foo: 42,  sourceLocationMap: @sourceLocationMap,  originalSource: @originalSource}));", reparsedModule, bindings));
        ModuleFormatTest.assertTrue((boolean)(bindings.get("sourceLocationMap") instanceof ObjectConstructor));
        ModuleFormatTest.assertTrue((boolean)(bindings.get("originalSource") instanceof ObjectConstructor));
    }
}

