/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UserPrefs;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRpcGadgetContext
extends GadgetContext {
    private final JSONObject context;
    private final JSONObject gadget;
    private final String container;
    private final Boolean debug;
    private final Boolean ignoreCache;
    private final Locale locale;
    private final Integer moduleId;
    private final Uri url;
    private final UserPrefs userPrefs;
    private final String view;

    public JsonRpcGadgetContext(JSONObject context, JSONObject gadget) throws JSONException {
        this.context = context;
        this.gadget = gadget;
        this.url = JsonRpcGadgetContext.getUrl(gadget);
        this.moduleId = JsonRpcGadgetContext.getModuleId(gadget);
        this.userPrefs = JsonRpcGadgetContext.getUserPrefs(gadget);
        this.locale = JsonRpcGadgetContext.getLocale(context);
        this.view = context.optString("view");
        this.ignoreCache = context.optBoolean("ignoreCache");
        this.container = context.optString("container");
        this.debug = context.optBoolean("debug");
    }

    public String getParameter(String name) {
        return this.gadget.has(name) ? this.gadget.optString(name) : this.context.optString(name, null);
    }

    public String getContainer() {
        return this.container == null ? super.getContainer() : this.container;
    }

    public boolean getDebug() {
        return this.debug == null ? super.getDebug() : this.debug.booleanValue();
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache == null ? super.getIgnoreCache() : this.ignoreCache.booleanValue();
    }

    public Locale getLocale() {
        return this.locale == null ? super.getLocale() : this.locale;
    }

    public int getModuleId() {
        return this.moduleId == null ? super.getModuleId() : this.moduleId.intValue();
    }

    public RenderingContext getRenderingContext() {
        return RenderingContext.METADATA;
    }

    public Uri getUrl() {
        return this.url == null ? super.getUrl() : this.url;
    }

    public UserPrefs getUserPrefs() {
        return this.userPrefs == null ? super.getUserPrefs() : this.userPrefs;
    }

    public String getView() {
        return this.view == null ? super.getView() : this.view;
    }

    private static Locale getLocale(JSONObject obj) {
        String language = obj.optString("language");
        String country = obj.optString("country");
        if (language == null || country == null) {
            return null;
        }
        return new Locale(language, country);
    }

    private static Integer getModuleId(JSONObject json) throws JSONException {
        if (json.has("moduleId")) {
            return json.getInt("moduleId");
        }
        return null;
    }

    private static Uri getUrl(JSONObject json) throws JSONException {
        try {
            String url = json.getString("url");
            return Uri.parse((String)url);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static UserPrefs getUserPrefs(JSONObject json) throws JSONException {
        JSONObject prefs = json.optJSONObject("prefs");
        if (prefs == null) {
            return null;
        }
        HashMap p = Maps.newHashMap();
        Iterator i = prefs.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            p.put(key, prefs.getString(key));
        }
        return new UserPrefs(p);
    }
}

