/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelGroupBinding
extends TermBinding
implements Cloneable {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected QName qName;
    protected boolean requiredParticle;
    protected ParticleHandler handler = DefaultHandlers.MODEL_GROUP_HANDLER;

    protected ModelGroupBinding(SchemaBinding schema) {
        super(schema);
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.qName = name;
    }

    public ParticleHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ParticleHandler handler) {
        this.handler = handler;
    }

    public abstract ElementBinding getArrayItem();

    public void addParticle(ParticleBinding particle) {
        if (particle.isRequired()) {
            this.requiredParticle = true;
        }
    }

    public abstract Collection<ParticleBinding> getParticles();

    public boolean hasRequiredParticle() {
        return this.requiredParticle;
    }

    public boolean mayStartWith(QName qName) {
        return this.mayStartWith(qName, Collections.EMPTY_SET);
    }

    public abstract Cursor newCursor(ParticleBinding var1);

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected abstract boolean mayStartWith(QName var1, Set<ModelGroupBinding> var2);

    @Override
    public boolean isSkip() {
        return this.skip == null ? true : this.skip;
    }

    @Override
    public boolean isModelGroup() {
        return true;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    @Override
    public boolean isElement() {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getGroupType());
        if (this.qName != null) {
            sb.append(' ').append(this.qName);
        }
        sb.append(':');
        for (ParticleBinding p : this.getParticles()) {
            TermBinding t = p.getTerm();
            sb.append(' ');
            if (t.isElement()) {
                sb.append(((ElementBinding)t).getQName());
            } else if (t.isModelGroup()) {
                sb.append('{').append(((ModelGroupBinding)t).getGroupType());
                ModelGroupBinding group = (ModelGroupBinding)t;
                if (group.getQName() != null) {
                    sb.append(' ').append(group.getQName());
                }
                sb.append('}');
            } else {
                sb.append("{wildcard}");
            }
            if (p.getMaxOccursUnbounded()) {
                sb.append(p.getMinOccurs() == 0 ? (char)'*' : '!');
                continue;
            }
            if (p.getMinOccurs() != 0) continue;
            sb.append('?');
        }
        return sb.toString();
    }

    public abstract String getGroupType();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Cursor {
        protected final ParticleBinding particle;
        protected final boolean trace;
        protected int occurence;

        protected Cursor(ParticleBinding particle) {
            this.trace = ModelGroupBinding.this.log.isTraceEnabled();
            this.particle = particle;
        }

        public ParticleBinding getParticle() {
            return this.particle;
        }

        public ModelGroupBinding getModelGroup() {
            return (ModelGroupBinding)this.particle.getTerm();
        }

        public abstract ParticleBinding getCurrentParticle();

        public abstract ElementBinding getElement();

        public abstract boolean isPositioned();

        public List<Cursor> startElement(QName qName, Attributes attrs) {
            return this.startElement(qName, attrs, Collections.EMPTY_SET, Collections.EMPTY_LIST, true);
        }

        public ElementBinding getElement(QName qName, Attributes attrs, boolean ignoreWildcards) {
            return this.getElement(qName, attrs, Collections.EMPTY_SET, ignoreWildcards);
        }

        public abstract void endElement(QName var1);

        public int getOccurence() {
            return this.occurence;
        }

        public boolean repeatElement(QName qName) {
            ParticleBinding particle = this.getCurrentParticle();
            if (particle.getMaxOccursUnbounded() || this.occurence < particle.getMinOccurs() || this.occurence < particle.getMaxOccurs()) {
                ++this.occurence;
                return true;
            }
            return false;
        }

        public abstract boolean isWildcardContent();

        protected abstract List<Cursor> startElement(QName var1, Attributes var2, Set<Cursor> var3, List<Cursor> var4, boolean var5);

        protected abstract ElementBinding getElement(QName var1, Attributes var2, Set<Cursor> var3, boolean var4);

        protected ElementBinding getElement(List<ParticleBinding> group, QName qName, Attributes atts, Set<Cursor> passedGroups, boolean ignoreWildcards) {
            ElementBinding element = null;
            for (int i = 0; i < group.size(); ++i) {
                WildcardBinding wildcard;
                ElementBinding e;
                ParticleBinding nextParticle = group.get(i);
                TermBinding item = nextParticle.getTerm();
                if (item.isElement()) {
                    ElementBinding choice = (ElementBinding)item;
                    if (!qName.equals(choice.getQName())) continue;
                    element = choice;
                    break;
                }
                if (item.isModelGroup()) {
                    ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                    if (passedGroups.contains(modelGroup)) continue;
                    switch (passedGroups.size()) {
                        case 0: {
                            passedGroups = Collections.singleton(this);
                            break;
                        }
                        case 1: {
                            passedGroups = new HashSet<Cursor>(passedGroups);
                        }
                        default: {
                            passedGroups.add(this);
                        }
                    }
                    e = modelGroup.newCursor(nextParticle).getElement(qName, atts, passedGroups, ignoreWildcards);
                    if (e == null) continue;
                    element = e;
                    if (qName.equals(e.getQName())) break;
                    throw new JBossXBRuntimeException("There is a bug in ModelGroupBinding.Cursor.getElement(QName,Attributes) impl");
                }
                if (ignoreWildcards || (e = (wildcard = (WildcardBinding)item).getElement(qName, atts)) == null) continue;
                element = e;
                if (qName.equals(e.getQName())) break;
                throw new JBossXBRuntimeException("There is a bug in ModelGroupBinding.Cursor.getElement(QName,Attributes) impl");
            }
            return element;
        }

        protected List<Cursor> addItem(List<Cursor> list, Cursor o) {
            switch (list.size()) {
                case 0: {
                    list = Collections.singletonList(o);
                    break;
                }
                case 1: {
                    list = new ArrayList<Cursor>(list);
                }
                default: {
                    list.add(o);
                }
            }
            return list;
        }
    }
}

