/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ApplicationMessage
implements Serializable {
    private static Log log = ExoLogger.getLogger(ApplicationMessage.class);
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    private int type_ = 2;
    private String messageKey_;
    private ResourceBundle resourceBundle;
    private Object[] messageArgs_;
    private boolean argsLocalized = true;

    public ApplicationMessage(String key, Object[] args) {
        this.messageKey_ = key;
        this.messageArgs_ = args;
    }

    public ApplicationMessage(String key, Object[] args, int type) {
        this(key, args);
        this.type_ = type;
    }

    public String getMessage() {
        String msg = this.resolveMessage(this.messageKey_);
        if (msg != null && this.messageArgs_ != null) {
            for (int i = 0; i < this.messageArgs_.length; ++i) {
                String arg = this.messageArgs_[i].toString();
                if (this.isArgsLocalized()) {
                    arg = this.resolveMessage(arg);
                }
                msg = msg.replace("{" + i + "}", arg);
            }
        }
        return msg;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getMessageKey() {
        return this.messageKey_;
    }

    public Object[] getMessageAruments() {
        return this.messageArgs_;
    }

    public int getType() {
        return this.type_;
    }

    public void setType(int type) {
        this.type_ = type;
    }

    public void setArgsLocalized(boolean argsLocalized) {
        this.argsLocalized = argsLocalized;
    }

    public boolean isArgsLocalized() {
        return this.argsLocalized;
    }

    private String resolveMessage(String key) {
        String value;
        if (key == null && this.resourceBundle == null) {
            return key;
        }
        try {
            value = this.resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            if (PropertyManager.isDevelopping()) {
                log.warn((Object)("Can not find resource bundle for key : " + key));
            }
            value = key.substring(key.lastIndexOf(46) + 1);
        }
        return value;
    }
}

