/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ProtocolException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exoplatform.common.http.client.Cookie;
import org.exoplatform.common.http.client.Cookie2;
import org.exoplatform.common.http.client.CookiePolicyHandler;
import org.exoplatform.common.http.client.DefaultCookiePolicyHandler;
import org.exoplatform.common.http.client.HTTPClientModule;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.Request;
import org.exoplatform.common.http.client.Response;
import org.exoplatform.common.http.client.RoRequest;
import org.exoplatform.common.http.client.Util;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CookieModule
implements HTTPClientModule {
    private static Hashtable cookie_cntxt_list;
    private static File cookie_jar;
    private static Object cookieSaver;
    private static CookiePolicyHandler cookie_handler;
    private static final Log log;

    private static void loadCookies() {
        try {
            cookie_jar = new File(CookieModule.getCookieJarName());
            if (cookie_jar.isFile() && cookie_jar.canRead()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cookie_jar));
                cookie_cntxt_list.put(HTTPConnection.getDefaultContext(), ois.readObject());
                ois.close();
            }
        }
        catch (Throwable t) {
            cookie_jar = null;
        }
    }

    private static void saveCookies() {
        if (cookie_jar != null && (!cookie_jar.exists() || cookie_jar.isFile() && cookie_jar.canWrite())) {
            Hashtable<Cookie, Cookie> cookie_list = new Hashtable<Cookie, Cookie>();
            Enumeration en = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext()).elements();
            while (en.hasMoreElements()) {
                Cookie cookie = (Cookie)en.nextElement();
                if (cookie.discard()) continue;
                cookie_list.put(cookie, cookie);
            }
            if (cookie_list.size() > 0) {
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cookie_jar));
                    oos.writeObject(cookie_list);
                    oos.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static String getCookieJarName() {
        String file = null;
        try {
            file = PrivilegedSystemHelper.getProperty((String)"HTTPClient.cookies.jar");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null) {
            String os = PrivilegedSystemHelper.getProperty((String)"os.name");
            file = os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("16-bit Windows") || os.equalsIgnoreCase("Windows") ? PrivilegedSystemHelper.getProperty((String)"java.home") + File.separator + ".httpclient_cookies" : (os.equalsIgnoreCase("Windows NT") ? PrivilegedSystemHelper.getProperty((String)"user.home") + File.separator + ".httpclient_cookies" : (os.equalsIgnoreCase("OS/2") ? PrivilegedSystemHelper.getProperty((String)"user.home") + File.separator + ".httpclient_cookies" : (os.equalsIgnoreCase("Mac OS") || os.equalsIgnoreCase("MacOS") ? "System Folder" + File.separator + "Preferences" + File.separator + "HTTPClientCookies" : PrivilegedSystemHelper.getProperty((String)"user.home") + File.separator + ".httpclient_cookies")));
        }
        return file;
    }

    CookieModule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestHandler(Request req, Response[] resp) {
        Hashtable cookie_list;
        NVPair[] hdrs = req.getHeaders();
        int length = hdrs.length;
        for (int idx = 0; idx < hdrs.length; ++idx) {
            int beg = idx;
            while (idx < hdrs.length && hdrs[idx].getName().equalsIgnoreCase("Cookie")) {
                ++idx;
            }
            if (idx - beg <= 0) continue;
            System.arraycopy(hdrs, idx, hdrs, beg, (length -= idx - beg) - beg);
        }
        if (length < hdrs.length) {
            hdrs = Util.resizeArray(hdrs, length);
            req.setHeaders(hdrs);
        }
        if ((cookie_list = Util.getList(cookie_cntxt_list, req.getConnection().getContext())).size() == 0) {
            return 0;
        }
        Vector<String> names = new Vector<String>();
        Vector<Integer> lens = new Vector<Integer>();
        int version = 0;
        Hashtable hashtable = cookie_list;
        synchronized (hashtable) {
            Enumeration list = cookie_list.elements();
            Vector<Cookie> remove_list = null;
            while (list.hasMoreElements()) {
                int idx;
                Cookie cookie = (Cookie)list.nextElement();
                if (cookie.hasExpired()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cookie has expired and is being removed: " + cookie));
                    }
                    if (remove_list == null) {
                        remove_list = new Vector<Cookie>();
                    }
                    remove_list.addElement(cookie);
                    continue;
                }
                if (!cookie.sendWith(req) || cookie_handler != null && !cookie_handler.sendCookie(cookie, req)) continue;
                int len = cookie.getPath().length();
                for (idx = 0; idx < lens.size() && (Integer)lens.elementAt(idx) >= len; ++idx) {
                }
                names.insertElementAt(cookie.toExternalForm(), idx);
                lens.insertElementAt(new Integer(len), idx);
                if (!(cookie instanceof Cookie2)) continue;
                version = Math.max(version, ((Cookie2)cookie).getVersion());
            }
            if (remove_list != null) {
                for (int idx = 0; idx < remove_list.size(); ++idx) {
                    cookie_list.remove(remove_list.elementAt(idx));
                }
            }
        }
        if (!names.isEmpty()) {
            int idx;
            StringBuffer value = new StringBuffer();
            if (version > 0) {
                value.append("$Version=\"" + version + "\"; ");
            }
            value.append((String)names.elementAt(0));
            for (idx = 1; idx < names.size(); ++idx) {
                value.append("; ");
                value.append((String)names.elementAt(idx));
            }
            hdrs = Util.resizeArray(hdrs, hdrs.length + 1);
            hdrs[hdrs.length - 1] = new NVPair("Cookie", value.toString());
            if (version != 1) {
                for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Cookie2"); ++idx) {
                }
                if (idx == hdrs.length) {
                    hdrs = Util.resizeArray(hdrs, hdrs.length + 1);
                    hdrs[hdrs.length - 1] = new NVPair("Cookie2", "$Version=\"1\"");
                }
            }
            req.setHeaders(hdrs);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending cookies '" + value + "'"));
            }
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getHeader("Set-Cookie");
        String set_cookie2 = resp.getHeader("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteHeader("Set-Cookie");
        resp.deleteHeader("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getTrailer("Set-Cookie");
        String set_cookie2 = resp.getTrailer("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteTrailer("Set-Cookie");
        resp.deleteTrailer("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCookie(String set_cookie, boolean cookie2, RoRequest req, Response resp) throws ProtocolException {
        Hashtable cookie_list;
        Cookie[] cookies = cookie2 ? Cookie2.parse(set_cookie, req) : Cookie.parse(set_cookie, req);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received and parsed " + cookies.length + " cookies:"));
            for (int idx = 0; idx < cookies.length; ++idx) {
                log.debug((Object)("Cookie " + idx + ": " + cookies[idx]));
            }
        }
        Hashtable hashtable = cookie_list = Util.getList(cookie_cntxt_list, req.getConnection().getContext());
        synchronized (hashtable) {
            for (int idx = 0; idx < cookies.length; ++idx) {
                Cookie cookie = (Cookie)cookie_list.get(cookies[idx]);
                if (cookie != null && cookies[idx].hasExpired()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cookie has expired and is being removed: " + cookie));
                    }
                    cookie_list.remove(cookie);
                    continue;
                }
                if (cookies[idx].hasExpired() || cookie_handler != null && !cookie_handler.acceptCookie(cookies[idx], req, resp)) continue;
                cookie_list.put(cookies[idx], cookies[idx]);
            }
        }
    }

    public static void discardAllCookies() {
        cookie_cntxt_list.clear();
    }

    public static void discardAllCookies(Object context) {
        if (context != null) {
            cookie_cntxt_list.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies() {
        Hashtable hashtable = cookie_cntxt_list;
        synchronized (hashtable) {
            Cookie[] cookies = new Cookie[]{};
            int idx = 0;
            Enumeration cntxt_list = cookie_cntxt_list.elements();
            while (cntxt_list.hasMoreElements()) {
                Hashtable cntxt;
                Hashtable hashtable2 = cntxt = (Hashtable)cntxt_list.nextElement();
                synchronized (hashtable2) {
                    cookies = Util.resizeArray(cookies, idx + cntxt.size());
                    Enumeration cookie_list = cntxt.elements();
                    while (cookie_list.hasMoreElements()) {
                        cookies[idx++] = (Cookie)cookie_list.nextElement();
                    }
                }
            }
            return cookies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies(Object context) {
        Hashtable cookie_list;
        Hashtable hashtable = cookie_list = Util.getList(cookie_cntxt_list, context);
        synchronized (hashtable) {
            Cookie[] cookies = new Cookie[cookie_list.size()];
            int idx = 0;
            Enumeration en = cookie_list.elements();
            while (en.hasMoreElements()) {
                cookies[idx++] = (Cookie)en.nextElement();
            }
            return cookies;
        }
    }

    public static void addCookie(Cookie cookie) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.put(cookie, cookie);
    }

    public static void addCookie(Cookie cookie, Object context) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, context);
        cookie_list.put(cookie, cookie);
    }

    public static void removeCookie(Cookie cookie) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.remove(cookie);
    }

    public static void removeCookie(Cookie cookie, Object context) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, context);
        cookie_list.remove(cookie);
    }

    public static synchronized CookiePolicyHandler setCookiePolicyHandler(CookiePolicyHandler handler) {
        CookiePolicyHandler old = cookie_handler;
        cookie_handler = handler;
        return old;
    }

    static {
        boolean persist;
        cookie_cntxt_list = new Hashtable();
        cookie_jar = null;
        cookieSaver = null;
        cookie_handler = new DefaultCookiePolicyHandler();
        log = ExoLogger.getLogger((String)"exo.ws.commons.CookieModule");
        try {
            persist = Boolean.getBoolean("HTTPClient.cookies.save");
        }
        catch (Exception e) {
            persist = false;
        }
        if (persist) {
            CookieModule.loadCookies();
            cookieSaver = new Object(){

                public void finalize() {
                    CookieModule.saveCookies();
                }
            };
            try {
                System.runFinalizersOnExit((boolean)true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

