/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.TransformedCollection;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortComparatorSource;
import org.apache.lucene.search.SortField;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NodeDataIndexing;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryHandler;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeFactory;
import org.exoplatform.services.jcr.impl.core.query.ErrorLog;
import org.exoplatform.services.jcr.impl.core.query.ExecutableQuery;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.SearchIndexConfigurationHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractRecoveryFilter;
import org.exoplatform.services.jcr.impl.core.query.lucene.AggregateRule;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingMultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChangesHolder;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheck;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheckError;
import org.exoplatform.services.jcr.impl.core.query.lucene.DefaultHTMLExcerpt;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldSelectors;
import org.exoplatform.services.jcr.impl.core.query.lucene.FileBasedNamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.FilterMultiColumnQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ForeignSegmentDocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexOfflineIOException;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfigurationEntityResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfigurationImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrIndexSearcher;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrStandartAnalyzer;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiColumnQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiColumnQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.NSRegistryBasedNamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeIndexer;
import org.exoplatform.services.jcr.impl.core.query.lucene.PerQueryCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedFieldSortComparator;
import org.exoplatform.services.jcr.impl.core.query.lucene.SingletonTokenStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellChecker;
import org.exoplatform.services.jcr.impl.core.query.lucene.SynonymProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.FSDirectoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchIndex
extends AbstractQueryHandler
implements IndexerIoModeListener,
Suspendable {
    private static final DefaultQueryNodeFactory DEFAULT_QUERY_NODE_FACTORY = new DefaultQueryNodeFactory();
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.SearchIndex");
    private static final String NS_MAPPING_FILE = "ns_mappings.properties";
    public static final int DEFAULT_MIN_MERGE_DOCS = 100;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    @Deprecated
    public static final int DEFAULT_EXTRACTOR_POOL_SIZE = 0;
    public static final int DEFAULT_EXTRACTOR_BACK_LOG = Integer.MAX_VALUE;
    public static final long DEFAULT_EXTRACTOR_TIMEOUT = 100L;
    public static final long DEFAULT_MAX_VOLATILE_INDEX_SIZE = 0x100000L;
    public static final int DEFAULT_MAX_VOLATILE_TIME = -1;
    public static final int DEFAULT_TERM_INFOS_INDEX_DIVISOR = 1;
    public static final int DEFAULT_REINDEXING_PAGE_SIZE = 100;
    public static final boolean DEFAULT_RDBMS_REINDEXING = true;
    public static final boolean DEFAULT_ASYNC_REINDEXING = false;
    public static final String INDEX_RECOVERY_MODE_FROM_INDEXING = "from-indexing";
    public static final String INDEX_RECOVERY_MODE_FROM_COORDINATOR = "from-coordinator";
    private static final String ERROR_LOG = "error.log";
    private MultiIndex index;
    private JcrStandartAnalyzer analyzer;
    private NamespaceMappings nsMappings;
    private String path;
    private int minMergeDocs = 100;
    private long maxVolatileIndexSize = 0x100000L;
    private int maxVolatileTime = -1;
    private int volatileIdleTime = 3;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private int maxFieldLength = 10000;
    private int extractorPoolSize = 2 * Runtime.getRuntime().availableProcessors();
    private int extractorBackLog = Integer.MAX_VALUE;
    private long extractorTimeout = 100L;
    private int bufferSize = 10;
    private boolean useCompoundFile = true;
    private boolean documentOrder = true;
    private boolean forceConsistencyCheck = false;
    private boolean consistencyCheckEnabled = false;
    private boolean autoRepair = true;
    private int cacheSize = 1000;
    private int resultFetchSize = Integer.MAX_VALUE;
    private boolean supportHighlighting = false;
    private Class<? extends ExcerptProvider> excerptProviderClass = DefaultHTMLExcerpt.class;
    private String indexingConfigPath;
    private Element indexingConfiguration;
    private IndexingConfiguration indexingConfig;
    private LocationFactory npResolver;
    private Class<? extends IndexingConfiguration> indexingConfigurationClass = IndexingConfigurationImpl.class;
    private Class<? extends SynonymProvider> synonymProviderClass;
    private SynonymProvider synProvider;
    private String synonymProviderConfigPath;
    private InputStream synonymProviderConfigFs;
    private IndexFormatVersion indexFormatVersion;
    private Class<? extends SpellChecker> spellCheckerClass;
    private SpellChecker spellChecker;
    private boolean spellCheckerMorePopular = true;
    private float spellCheckerMinDistance = 0.55f;
    private Similarity similarity = Similarity.getDefault();
    private String directoryManagerClass = FSDirectoryManager.class.getName();
    private DirectoryManager directoryManager;
    private int termInfosIndexDivisor = 1;
    private SortComparatorSource scs;
    private boolean initializeHierarchyCache = true;
    private boolean closed = false;
    private boolean allowQuery = true;
    private DocumentReaderService extractor;
    public static final int DEFAULT_ERRORLOG_FILE_SIZE = 50;
    private int errorLogfileSize = 50;
    private ErrorLog errorLog;
    private final String wsId;
    private final ConfigurationManager cfm;
    private int reindexingPageSize = 100;
    private boolean rdbmsReindexing = true;
    private String indexRecoveryMode = "from-indexing";
    private boolean asyncReindexing = false;
    protected CountDownLatch latcher = null;
    protected boolean isSuspended = false;
    protected Set<String> recoveryFilterClasses = new HashSet<String>();
    protected List<AbstractRecoveryFilter> recoveryFilters = null;
    protected Map<String, String> optionalParameters = new HashMap<String, String>();

    public SearchIndex(String wsId, QueryHandlerEntry queryHandlerConfig, ConfigurationManager cfm) throws IOException, RepositoryConfigurationException {
        this.wsId = wsId;
        this.analyzer = new JcrStandartAnalyzer();
        this.cfm = cfm;
        SearchIndexConfigurationHelper searchIndexConfigurationHelper = new SearchIndexConfigurationHelper(this);
        searchIndexConfigurationHelper.init(queryHandlerConfig);
    }

    public SearchIndex(QueryHandlerEntry queryHandlerConfig, ConfigurationManager cfm) throws IOException, RepositoryConfigurationException {
        this(null, queryHandlerConfig, cfm);
    }

    public SearchIndex() {
        this.analyzer = new JcrStandartAnalyzer();
        this.cfm = null;
        this.wsId = null;
    }

    @Override
    public void doInit() throws IOException, RepositoryException {
        File indexDirectory;
        QueryHandlerContext context = this.getContext();
        this.setPath(context.getIndexDirectory());
        if (this.path == null) {
            throw new IOException("SearchIndex requires 'path' parameter in configuration!");
        }
        if (this.path != null) {
            indexDirectory = new File(this.path);
            if (!indexDirectory.exists() && !indexDirectory.mkdirs()) {
                throw new RepositoryException("fail to create index dir " + this.path);
            }
        } else {
            throw new IOException("SearchIndex requires 'path' parameter in configuration!");
        }
        log.info("path=" + this.path);
        this.extractor = context.getExtractor();
        this.synProvider = this.createSynonymProvider();
        this.directoryManager = this.createDirectoryManager();
        if (context.getParentHandler() instanceof SearchIndex) {
            SearchIndex sysIndex = (SearchIndex)context.getParentHandler();
            this.nsMappings = sysIndex.getNamespaceMappings();
        } else {
            File mapFile = new File(indexDirectory, NS_MAPPING_FILE);
            this.nsMappings = mapFile.exists() ? new FileBasedNamespaceMappings(mapFile) : new NSRegistryBasedNamespaceMappings(context.getNamespaceRegistry());
        }
        this.scs = new SharedFieldSortComparator(FieldNames.PROPERTIES, context.getItemStateManager(), this.nsMappings);
        this.npResolver = new LocationFactory(this.nsMappings);
        this.indexingConfig = this.createIndexingConfiguration(this.nsMappings);
        this.analyzer.setIndexingConfig(this.indexingConfig);
        this.index = new MultiIndex(this, context.getIndexingTree(), this.modeHandler, this.getIndexInfos(), this.getIndexUpdateMonitor());
        if (this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            final boolean doReindexing = this.index.numDocs() == 0 && context.isCreateInitialIndex();
            final boolean doForceReindexing = context.isRecoveryFilterUsed() && this.isIndexRecoveryRequired();
            final boolean doCheck = this.consistencyCheckEnabled && (this.index.getRedoLogApplied() || this.forceConsistencyCheck);
            final ItemDataConsumer itemStateManager = context.getItemStateManager();
            if (this.isAsyncReindexing() && doReindexing) {
                log.info("Launching reindexing in asynchronous mode.");
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            SearchIndex.this.reindex(doReindexing, doForceReindexing, doCheck, itemStateManager);
                        }
                        catch (IOException e) {
                            log.error("Error while reindexing the workspace. Please fix the problem, delete index and restart server.", (Throwable)e);
                        }
                    }
                }, "Reindexing-" + context.getRepositoryName() + "-" + context.getContainer().getWorkspaceName()).start();
            } else {
                this.reindex(doReindexing, doForceReindexing, doCheck, itemStateManager);
            }
        }
        this.spellChecker = this.createSpellChecker();
        log.info("Index initialized: {} Version: {}", new Object[]{this.path, this.index.getIndexFormatVersion()});
        if (!this.index.getIndexFormatVersion().equals(this.getIndexFormatVersion())) {
            log.warn("Using Version {} for reading. Please re-index version storage for optimal performance.", (Object)new Integer(this.getIndexFormatVersion().getVersion()));
        }
        this.doInitErrorLog();
        if (this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            this.recoverErrorLog(this.errorLog);
        }
        this.modeHandler.addIndexerIoModeListener(this);
    }

    public String getWsId() {
        return this.wsId;
    }

    public void addRecoveryFilterClass(String recoveryFilterClassName) {
        this.recoveryFilterClasses.add(recoveryFilterClassName);
    }

    public void addOptionalParameter(String key, String value) {
        this.optionalParameters.put(key, value);
    }

    public Map<String, String> getOptionalParameters() {
        return Collections.unmodifiableMap(this.optionalParameters);
    }

    private boolean isIndexRecoveryRequired() throws RepositoryException {
        if (this.recoveryFilters == null) {
            this.recoveryFilters = new ArrayList<AbstractRecoveryFilter>();
            log.info("Initializing RecoveryFilters.");
            for (String recoveryFilterClassName : this.recoveryFilterClasses) {
                AbstractRecoveryFilter filter = null;
                try {
                    Class<?> filterClass = Class.forName(recoveryFilterClassName, true, this.getClass().getClassLoader());
                    Constructor<?> constuctor = filterClass.getConstructor(SearchIndex.class);
                    filter = (AbstractRecoveryFilter)constuctor.newInstance(this);
                    this.recoveryFilters.add(filter);
                }
                catch (ClassNotFoundException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (SecurityException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
            }
        }
        for (AbstractRecoveryFilter filter : this.recoveryFilters) {
            if (!filter.accept()) continue;
            return true;
        }
        return false;
    }

    private void reindex(boolean doReindexing, boolean doForceReindexing, boolean doCheck, ItemDataConsumer itemStateManager) throws IOException {
        if (doReindexing || doForceReindexing) {
            this.index.createInitialIndex(itemStateManager, doForceReindexing);
        }
        if (doCheck) {
            log.info("Running consistency check...");
            try {
                ConsistencyCheck check = ConsistencyCheck.run(this.index, itemStateManager);
                if (this.autoRepair) {
                    check.repair(true);
                } else {
                    List<ConsistencyCheckError> errors = check.getErrors();
                    if (errors.size() == 0) {
                        log.info("No errors detected.");
                    }
                    for (ConsistencyCheckError err : errors) {
                        log.info(err.toString());
                    }
                }
            }
            catch (Exception e) {
                log.warn("Failed to run consistency check on index: " + e);
            }
        }
    }

    public int getErrorLogfileSize() {
        return this.errorLogfileSize;
    }

    public void setErrorLogfileSize(int errorLogfileSize) {
        this.errorLogfileSize = errorLogfileSize;
    }

    @Override
    public void addNode(NodeData node) throws RepositoryException, IOException {
        throw new UnsupportedOperationException("addNode");
    }

    @Override
    public void deleteNode(String id) throws IOException {
        throw new UnsupportedOperationException("deleteNode");
    }

    @Override
    public void updateNodes(Iterator<String> remove, Iterator<NodeData> add) throws RepositoryException, IOException {
        this.checkOpen();
        this.apply(this.getChanges(remove, add));
    }

    @Override
    public void apply(ChangesHolder changes) throws RepositoryException, IOException {
        this.checkOpen();
        if (this.index != null) {
            this.index.update(changes.getRemove(), changes.getAdd());
        }
    }

    @Override
    public ChangesHolder getChanges(Iterator<String> remove, Iterator<NodeData> add) {
        final HashMap<String, NodeData> aggregateRoots = new HashMap<String, NodeData>();
        final HashSet<String> removedNodeIds = new HashSet<String>();
        final HashSet addedNodeIds = new HashSet();
        List docIdsToRemove = IteratorUtils.toList((Iterator)new TransformIterator(remove, new Transformer(){

            public Object transform(Object input) {
                String uuid = (String)input;
                removedNodeIds.add(uuid);
                return uuid;
            }
        }));
        List docsToAdd = IteratorUtils.toList((Iterator)new TransformIterator(add, new Transformer(){

            public Object transform(Object input) {
                NodeData state = (NodeData)input;
                if (state == null) {
                    return null;
                }
                String uuid = state.getIdentifier();
                addedNodeIds.add(uuid);
                removedNodeIds.remove(uuid);
                Document doc = null;
                try {
                    doc = SearchIndex.this.createDocument(state, SearchIndex.this.getNamespaceMappings(), SearchIndex.this.index.getIndexFormatVersion());
                    SearchIndex.this.retrieveAggregateRoot(state, (Map<String, NodeData>)aggregateRoots);
                }
                catch (RepositoryException e) {
                    log.warn("Exception while creating document for node: " + state.getIdentifier() + ": " + e.toString(), (Throwable)e);
                }
                return doc;
            }
        }));
        aggregateRoots.keySet().removeAll(addedNodeIds);
        this.retrieveAggregateRoot(removedNodeIds, aggregateRoots);
        if (aggregateRoots.size() > 0) {
            Collection modified = TransformedCollection.decorate(new ArrayList(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    NodeData state = (NodeData)input;
                    try {
                        return SearchIndex.this.createDocument(state, SearchIndex.this.getNamespaceMappings(), SearchIndex.this.index.getIndexFormatVersion());
                    }
                    catch (RepositoryException e) {
                        log.warn("Exception while creating document for node: " + state.getIdentifier() + ": " + e.toString());
                        return null;
                    }
                }
            });
            modified.addAll(aggregateRoots.values());
            docIdsToRemove.addAll(aggregateRoots.keySet());
            docsToAdd.addAll(modified);
        }
        if (docIdsToRemove.isEmpty() && docsToAdd.isEmpty()) {
            return null;
        }
        return new ChangesHolder(docIdsToRemove, docsToAdd);
    }

    @Override
    public ExecutableQuery createExecutableQuery(SessionImpl session, SessionDataManager itemMgr, String statement, String language) throws InvalidQueryException {
        QueryImpl query = new QueryImpl(session, itemMgr, this, this.getContext().getPropertyTypeRegistry(), statement, language, this.getQueryNodeFactory());
        query.setRespectDocumentOrder(this.documentOrder);
        return query;
    }

    protected DefaultQueryNodeFactory getQueryNodeFactory() {
        return DEFAULT_QUERY_NODE_FACTORY;
    }

    @Override
    public void close() {
        if (this.recoveryFilters != null) {
            for (AbstractRecoveryFilter filter : this.recoveryFilters) {
                filter.close();
            }
            this.recoveryFilters.clear();
            this.recoveryFilters = null;
        }
        if (this.synonymProviderConfigFs != null) {
            try {
                this.synonymProviderConfigFs.close();
            }
            catch (IOException e) {
                log.warn("Exception while closing FileSystem", (Throwable)e);
            }
        }
        if (this.spellChecker != null) {
            this.spellChecker.close();
        }
        this.errorLog.close();
        this.index.close();
        this.getContext().destroy();
        this.closed = true;
        log.info("Index closed: " + this.path);
    }

    public MultiColumnQueryHits executeQuery(SessionImpl session, AbstractQueryImpl queryImpl, Query query, QPath[] orderProps, boolean[] orderSpecs, long resultFetchHint) throws IOException, RepositoryException {
        this.waitForResuming();
        this.checkOpen();
        Sort sort = new Sort(this.createSortFields(orderProps, orderSpecs));
        final IndexReader reader = this.getIndexReader(queryImpl.needsSystemTree());
        JcrIndexSearcher searcher = new JcrIndexSearcher(session, reader, this.getContext().getItemStateManager());
        searcher.setSimilarity(this.getSimilarity());
        return new FilterMultiColumnQueryHits(searcher.execute(query, sort, resultFetchHint, QueryImpl.DEFAULT_SELECTOR_NAME)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                    Object var2_1 = null;
                    PerQueryCache.getInstance().dispose();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    PerQueryCache.getInstance().dispose();
                    Util.closeOrRelease(reader);
                    throw throwable;
                }
                Util.closeOrRelease(reader);
            }
        };
    }

    public MultiColumnQueryHits executeQuery(SessionImpl session, MultiColumnQuery query, QPath[] orderProps, boolean[] orderSpecs, long resultFetchHint) throws IOException, RepositoryException {
        this.waitForResuming();
        this.checkOpen();
        Sort sort = new Sort(this.createSortFields(orderProps, orderSpecs));
        final IndexReader reader = this.getIndexReader();
        JcrIndexSearcher searcher = new JcrIndexSearcher(session, reader, this.getContext().getItemStateManager());
        searcher.setSimilarity(this.getSimilarity());
        return new FilterMultiColumnQueryHits(query.execute(searcher, sort, resultFetchHint)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                    Object var2_1 = null;
                    PerQueryCache.getInstance().dispose();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    PerQueryCache.getInstance().dispose();
                    Util.closeOrRelease(reader);
                    throw throwable;
                }
                Util.closeOrRelease(reader);
            }
        };
    }

    public ExcerptProvider createExcerptProvider(Query query) throws IOException {
        ExcerptProvider ep;
        try {
            ep = this.excerptProviderClass.newInstance();
        }
        catch (Exception e) {
            throw Util.createIOException(e);
        }
        ep.init(query, this);
        return ep;
    }

    public Analyzer getTextAnalyzer() {
        return this.analyzer;
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    public IndexingConfiguration getIndexingConfig() {
        return this.indexingConfig;
    }

    public SynonymProvider getSynonymProvider() {
        if (this.synProvider != null) {
            return this.synProvider;
        }
        QueryHandler handler = this.getContext().getParentHandler();
        if (handler instanceof SearchIndex) {
            return ((SearchIndex)handler).getSynonymProvider();
        }
        return null;
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public IndexReader getIndexReader() throws IOException {
        return this.getIndexReader(true);
    }

    public IndexFormatVersion getIndexFormatVersion() {
        if (this.indexFormatVersion == null) {
            SearchIndex parent;
            this.indexFormatVersion = this.getContext().getParentHandler() instanceof SearchIndex ? ((parent = (SearchIndex)this.getContext().getParentHandler()).getIndexFormatVersion().getVersion() < this.index.getIndexFormatVersion().getVersion() ? parent.getIndexFormatVersion() : this.index.getIndexFormatVersion()) : this.index.getIndexFormatVersion();
        }
        return this.indexFormatVersion;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    protected IndexReader getIndexReader(boolean includeSystemIndex) throws IOException {
        MultiReader reader;
        if (!this.index.isOnline() && !this.allowQuery) {
            throw new IndexOfflineIOException("Index is offline");
        }
        QueryHandler parentHandler = this.getContext().getParentHandler();
        CachingMultiIndexReader parentReader = null;
        if (parentHandler instanceof SearchIndex && includeSystemIndex) {
            parentReader = ((SearchIndex)parentHandler).index.getIndexReader();
        }
        if (parentReader != null) {
            CachingMultiIndexReader[] readers = new CachingMultiIndexReader[]{this.index.getIndexReader(), parentReader};
            reader = new CombinedIndexReader(readers);
        } else {
            reader = this.index.getIndexReader();
        }
        return new JcrIndexReader((IndexReader)reader);
    }

    protected SortField[] createSortFields(QPath[] orderProps, boolean[] orderSpecs) throws RepositoryException {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        for (int i = 0; i < orderProps.length; ++i) {
            if (orderProps[i].getEntries().length == 1 && Constants.JCR_SCORE.equals((Object)orderProps[i].getName())) {
                sortFields.add(new SortField(null, 0, orderSpecs[i]));
                continue;
            }
            this.path = this.npResolver.createJCRPath(orderProps[i]).getAsString(false);
            sortFields.add(new SortField(this.path, this.scs, !orderSpecs[i]));
        }
        return sortFields.toArray(new SortField[sortFields.size()]);
    }

    protected Document createDocument(NodeData node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        return this.createDocument(new NodeDataIndexing(node), nsMappings, indexFormatVersion);
    }

    protected Document createDocument(NodeDataIndexing node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        NodeIndexer indexer = new NodeIndexer(node, this.getContext().getItemStateManager(), nsMappings, this.extractor);
        indexer.setSupportHighlighting(this.supportHighlighting);
        indexer.setIndexingConfiguration(this.indexingConfig);
        indexer.setIndexFormatVersion(indexFormatVersion);
        Document doc = indexer.createDoc();
        this.mergeAggregatedNodeIndexes(node, doc);
        return doc;
    }

    public MultiIndex getIndex() {
        return this.index;
    }

    protected SortComparatorSource getSortComparatorSource() {
        return this.scs;
    }

    protected IndexingConfiguration createIndexingConfiguration(NamespaceMappings namespaceMappings) {
        Element docElement = this.getIndexingConfigurationDOM();
        if (docElement == null) {
            return null;
        }
        try {
            IndexingConfiguration idxCfg = this.indexingConfigurationClass.newInstance();
            idxCfg.init(docElement, this.getContext(), namespaceMappings);
            return idxCfg;
        }
        catch (Exception e) {
            log.warn("Exception initializing indexing configuration from: " + this.indexingConfigPath, (Throwable)e);
            log.warn(this.indexingConfigPath + " ignored.");
            return null;
        }
    }

    protected SynonymProvider createSynonymProvider() {
        SynonymProvider sp = null;
        if (this.synonymProviderClass != null) {
            try {
                sp = this.synonymProviderClass.newInstance();
                sp.initialize(this.createSynonymProviderConfigResource());
            }
            catch (Exception e) {
                log.warn("Exception initializing synonym provider: " + this.synonymProviderClass, (Throwable)e);
                sp = null;
            }
        }
        return sp;
    }

    protected DirectoryManager createDirectoryManager() throws IOException {
        try {
            Class<?> clazz = Class.forName(this.directoryManagerClass);
            if (!DirectoryManager.class.isAssignableFrom(clazz)) {
                throw new IOException(this.directoryManagerClass + " is not a DirectoryManager implementation");
            }
            DirectoryManager df = (DirectoryManager)clazz.newInstance();
            df.init(this);
            return df;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
    }

    protected InputStream createSynonymProviderConfigResource() throws IOException {
        if (this.synonymProviderConfigPath != null) {
            InputStream fsr;
            String separator = PrivilegedSystemHelper.getProperty((String)"file.separator");
            if (this.synonymProviderConfigPath.endsWith(PrivilegedSystemHelper.getProperty((String)"file.separator"))) {
                throw new IOException("Invalid synonymProviderConfigPath: " + this.synonymProviderConfigPath);
            }
            if (this.cfm == null) {
                int lastSeparator = this.synonymProviderConfigPath.lastIndexOf(separator);
                if (lastSeparator != -1) {
                    File root = new File(this.path, this.synonymProviderConfigPath.substring(0, lastSeparator));
                    fsr = new BufferedInputStream(PrivilegedFileHelper.fileInputStream((File)new File(root, this.synonymProviderConfigPath.substring(lastSeparator + 1))));
                } else {
                    fsr = new BufferedInputStream(PrivilegedFileHelper.fileInputStream((File)new File(this.synonymProviderConfigPath)));
                }
                this.synonymProviderConfigFs = fsr;
            } else {
                try {
                    fsr = this.cfm.getInputStream(this.synonymProviderConfigPath);
                }
                catch (Exception e) {
                    throw new IOException(e.getLocalizedMessage());
                }
            }
            return fsr;
        }
        return null;
    }

    protected SpellChecker createSpellChecker() {
        SpellChecker spCheck = null;
        if (this.spellCheckerClass != null) {
            try {
                spCheck = this.spellCheckerClass.newInstance();
                spCheck.init(this, this.spellCheckerMinDistance, this.spellCheckerMorePopular);
            }
            catch (Exception e) {
                log.warn("Exception initializing spell checker: " + this.spellCheckerClass, (Throwable)e);
            }
        }
        return spCheck;
    }

    protected Element getIndexingConfigurationDOM() {
        if (this.indexingConfiguration == null && this.indexingConfigPath != null) {
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    InputStream is = SearchIndex.class.getResourceAsStream(SearchIndex.this.indexingConfigPath);
                    if (is == null) {
                        try {
                            is = SearchIndex.this.cfm.getInputStream(SearchIndex.this.indexingConfigPath);
                        }
                        catch (Exception e1) {
                            log.warn("Unable to load configuration " + SearchIndex.this.indexingConfigPath);
                        }
                    }
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        builder.setEntityResolver(new IndexingConfigurationEntityResolver());
                        SearchIndex.this.indexingConfiguration = builder.parse(is).getDocumentElement();
                    }
                    catch (ParserConfigurationException e) {
                        log.warn("Unable to create XML parser", (Throwable)e);
                    }
                    catch (IOException e) {
                        log.warn("Exception parsing " + SearchIndex.this.indexingConfigPath, (Throwable)e);
                    }
                    catch (SAXException e) {
                        log.warn("Exception parsing " + SearchIndex.this.indexingConfigPath, (Throwable)e);
                    }
                    return null;
                }
            });
        }
        return this.indexingConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeAggregatedNodeIndexes(NodeData state, Document doc) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            try {
                ItemDataConsumer ism = this.getContext().getItemStateManager();
                for (int i = 0; i < aggregateRules.length; ++i) {
                    PropertyData[] propStates;
                    boolean ruleMatched = false;
                    NodeData[] aggregates = aggregateRules[i].getAggregatedNodeStates(state);
                    if (aggregates != null) {
                        ruleMatched = true;
                        for (int j = 0; j < aggregates.length; ++j) {
                            Document aDoc = this.createDocument(aggregates[j], this.getNamespaceMappings(), this.index.getIndexFormatVersion());
                            Fieldable[] fulltextFields = aDoc.getFieldables(FieldNames.FULLTEXT);
                            if (fulltextFields == null) continue;
                            for (int k = 0; k < fulltextFields.length; ++k) {
                                doc.add(fulltextFields[k]);
                            }
                            doc.add((Fieldable)new Field(FieldNames.AGGREGATED_NODE_UUID, aggregates[j].getIdentifier(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                        }
                    }
                    if ((propStates = aggregateRules[i].getAggregatedPropertyStates(state)) != null) {
                        ruleMatched = true;
                        for (int j = 0; j < propStates.length; ++j) {
                            Object var22_25;
                            PropertyData propState = propStates[j];
                            String namePrefix = FieldNames.createNamedValue(this.getNamespaceMappings().translateName(propState.getQPath().getName()), "");
                            NodeData parent = (NodeData)ism.getItemData(propState.getParentIdentifier());
                            Document aDoc = this.createDocument(parent, this.getNamespaceMappings(), this.getIndex().getIndexFormatVersion());
                            try {
                                Fieldable[] fields = aDoc.getFieldables(FieldNames.PROPERTIES);
                                Token t = new Token();
                                for (int k = 0; k < fields.length; ++k) {
                                    Fieldable field = fields[k];
                                    t = field.tokenStreamValue().next(t);
                                    String value = new String(t.termBuffer(), 0, t.termLength());
                                    if (!value.startsWith(namePrefix)) continue;
                                    value = value.substring(namePrefix.length());
                                    QPath p = this.getRelativePath(state, propState);
                                    String path = this.getNamespaceMappings().translatePath(p);
                                    value = FieldNames.createNamedValue(path, value);
                                    t.setTermBuffer(value);
                                    doc.add((Fieldable)new Field(field.name(), (TokenStream)new SingletonTokenStream(t)));
                                    doc.add((Fieldable)new Field(FieldNames.AGGREGATED_NODE_UUID, parent.getIdentifier(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                                }
                                var22_25 = null;
                            }
                            catch (Throwable throwable) {
                                var22_25 = null;
                                Util.disposeDocument(aDoc);
                                throw throwable;
                            }
                            Util.disposeDocument(aDoc);
                        }
                    }
                    if (!ruleMatched) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.warn("Exception while building indexing aggregate for node with UUID: " + state.getIdentifier(), (Throwable)e);
            }
        }
    }

    protected QPath getRelativePath(NodeData nodeState, PropertyData propState) throws RepositoryException {
        QPath nodePath = nodeState.getQPath();
        QPath propPath = propState.getQPath();
        throw new RepositoryException();
    }

    protected void retrieveAggregateRoot(NodeData state, Map<String, NodeData> map) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            try {
                for (int i = 0; i < aggregateRules.length; ++i) {
                    NodeData root = aggregateRules[i].getAggregateRoot(state);
                    if (root == null) continue;
                    map.put(root.getIdentifier(), root);
                }
            }
            catch (Exception e) {
                log.warn("Unable to get aggregate root for " + state.getIdentifier(), (Throwable)e);
            }
        }
    }

    protected void retrieveAggregateRoot(final Set<String> removedNodeIds, final Map<String, NodeData> map) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            long time = 0L;
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis();
            }
            int found = (Integer)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer run() {
                    int found = 0;
                    try {
                        CachingMultiIndexReader reader = SearchIndex.this.index.getIndexReader();
                        try {
                            Term aggregateUUIDs = new Term(FieldNames.AGGREGATED_NODE_UUID, "");
                            TermDocs tDocs = reader.termDocs();
                            try {
                                ItemDataConsumer ism = SearchIndex.this.getContext().getItemStateManager();
                                for (String id : removedNodeIds) {
                                    aggregateUUIDs = aggregateUUIDs.createTerm(id);
                                    tDocs.seek(aggregateUUIDs);
                                    while (tDocs.next()) {
                                        Document doc = reader.document(tDocs.doc(), FieldSelectors.UUID);
                                        String uuid = doc.get(FieldNames.UUID);
                                        ItemData itd = ism.getItemData(uuid);
                                        if (itd == null) continue;
                                        if (!itd.isNode()) {
                                            throw new RepositoryException("Item with id:" + uuid + " is not a node");
                                        }
                                        map.put(uuid, (NodeData)itd);
                                        ++found;
                                    }
                                }
                                Object var12_12 = null;
                            }
                            catch (Throwable throwable) {
                                Object var12_13 = null;
                                tDocs.close();
                                throw throwable;
                            }
                            tDocs.close();
                            Object var14_15 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_16 = null;
                            reader.release();
                            throw throwable;
                        }
                        reader.release();
                        {
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception while retrieving aggregate roots", (Throwable)e);
                    }
                    return found;
                }
            });
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis() - time;
                log.debug("Retrieved {} aggregate roots in {} ms.", (Object)new Integer(found), (Object)new Long(time));
            }
        }
    }

    public void setAnalyzer(String analyzerClassName) {
        try {
            Class<?> analyzerClass = Class.forName(analyzerClassName);
            this.analyzer.setDefaultAnalyzer((Analyzer)analyzerClass.newInstance());
        }
        catch (Exception e) {
            log.warn("Invalid Analyzer class: " + analyzerClassName, (Throwable)e);
        }
    }

    public String getAnalyzer() {
        return ((Object)((Object)this.analyzer)).getClass().getName();
    }

    public void setPath(String path) {
        this.path = path.replace("${java.io.tmpdir}", PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));
    }

    public String getPath() {
        return this.path;
    }

    public void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public int getMinMergeDocs() {
        return this.minMergeDocs;
    }

    public void setVolatileIdleTime(int volatileIdleTime) {
        this.volatileIdleTime = volatileIdleTime;
    }

    public int getVolatileIdleTime() {
        return this.volatileIdleTime;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setRespectDocumentOrder(boolean docOrder) {
        this.documentOrder = docOrder;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setForceConsistencyCheck(boolean b) {
        this.forceConsistencyCheck = b;
    }

    public boolean getForceConsistencyCheck() {
        return this.forceConsistencyCheck;
    }

    public void setAutoRepair(boolean b) {
        this.autoRepair = b;
    }

    public boolean getAutoRepair() {
        return this.autoRepair;
    }

    public void setCacheSize(int size) {
        this.cacheSize = size;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setMaxFieldLength(int length) {
        this.maxFieldLength = length;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setResultFetchSize(int size) {
        this.resultFetchSize = size;
    }

    public int getResultFetchSize() {
        return this.resultFetchSize;
    }

    public void setExtractorPoolSize(int numThreads) {
        if (numThreads < 0) {
            numThreads = 0;
        }
        this.extractorPoolSize = numThreads;
    }

    public int getExtractorPoolSize() {
        return this.extractorPoolSize;
    }

    public void setExtractorBackLogSize(int backLog) {
        this.extractorBackLog = backLog;
    }

    public int getExtractorBackLogSize() {
        return this.extractorBackLog;
    }

    public void setExtractorTimeout(long timeout) {
        this.extractorTimeout = timeout;
    }

    public long getExtractorTimeout() {
        return this.extractorTimeout;
    }

    public void setSupportHighlighting(boolean b) {
        this.supportHighlighting = b;
    }

    public boolean getSupportHighlighting() {
        return this.supportHighlighting;
    }

    public void setExcerptProviderClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (ExcerptProvider.class.isAssignableFrom(clazz)) {
                this.excerptProviderClass = clazz;
            } else {
                log.warn("Invalid value for excerptProviderClass, {} does not implement ExcerptProvider interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for excerptProviderClass, class {} not found.", (Object)className);
        }
    }

    public String getExcerptProviderClass() {
        return this.excerptProviderClass.getName();
    }

    public void setIndexingConfiguration(String path) {
        this.indexingConfigPath = path;
    }

    public String getIndexingConfiguration() {
        return this.indexingConfigPath;
    }

    public void setIndexingConfigurationClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (IndexingConfiguration.class.isAssignableFrom(clazz)) {
                this.indexingConfigurationClass = clazz;
            } else {
                log.warn("Invalid value for indexingConfigurationClass, {} does not implement IndexingConfiguration interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for indexingConfigurationClass, class {} not found.", (Object)className);
        }
    }

    public String getIndexingConfigurationClass() {
        return this.indexingConfigurationClass.getName();
    }

    public void setSynonymProviderClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (SynonymProvider.class.isAssignableFrom(clazz)) {
                this.synonymProviderClass = clazz;
            } else {
                log.warn("Invalid value for synonymProviderClass, {} does not implement SynonymProvider interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for synonymProviderClass, class {} not found.", (Object)className);
        }
    }

    public String getSynonymProviderClass() {
        if (this.synonymProviderClass != null) {
            return this.synonymProviderClass.getName();
        }
        return null;
    }

    public void setSpellCheckerClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (SpellChecker.class.isAssignableFrom(clazz)) {
                this.spellCheckerClass = clazz;
            } else {
                log.warn("Invalid value for spellCheckerClass, {} does not implement SpellChecker interface.", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Invalid value for spellCheckerClass, class {} not found.", (Object)className);
        }
    }

    public void setSpellCheckerMorePopuar(boolean morePopular) {
        this.spellCheckerMorePopular = morePopular;
    }

    public void setSpellCheckerMinDistance(float minDistance) {
        this.spellCheckerMinDistance = minDistance;
    }

    public String getSpellCheckerClass() {
        if (this.spellCheckerClass != null) {
            return this.spellCheckerClass.getName();
        }
        return null;
    }

    public void setEnableConsistencyCheck(boolean b) {
        this.consistencyCheckEnabled = b;
    }

    public boolean getEnableConsistencyCheck() {
        return this.consistencyCheckEnabled;
    }

    public void setSynonymProviderConfigPath(String path) {
        this.synonymProviderConfigPath = path;
    }

    public String getSynonymProviderConfigPath() {
        return this.synonymProviderConfigPath;
    }

    public void setSimilarityClass(String className) {
        try {
            Class<?> similarityClass = Class.forName(className);
            this.similarity = (Similarity)similarityClass.newInstance();
        }
        catch (Exception e) {
            log.warn("Invalid Similarity class: " + className, (Throwable)e);
        }
    }

    public String getSimilarityClass() {
        return this.similarity.getClass().getName();
    }

    public void setMaxVolatileIndexSize(long maxVolatileIndexSize) {
        this.maxVolatileIndexSize = maxVolatileIndexSize;
    }

    public long getMaxVolatileIndexSize() {
        return this.maxVolatileIndexSize;
    }

    public int getMaxVolatileTime() {
        return this.maxVolatileTime;
    }

    public void setMaxVolatileTime(int maxVolatileTime) {
        this.maxVolatileTime = maxVolatileTime;
    }

    public String getDirectoryManagerClass() {
        return this.directoryManagerClass;
    }

    public void setDirectoryManagerClass(String className) {
        this.directoryManagerClass = className;
    }

    public int getTermInfosIndexDivisor() {
        return this.termInfosIndexDivisor;
    }

    public int getReindexingPageSize() {
        return this.reindexingPageSize;
    }

    public boolean isRDBMSReindexing() {
        return this.rdbmsReindexing;
    }

    public boolean isAsyncReindexing() {
        return this.asyncReindexing;
    }

    public String getIndexRecoveryMode() {
        return this.indexRecoveryMode;
    }

    public void setTermInfosIndexDivisor(int termInfosIndexDivisor) {
        this.termInfosIndexDivisor = termInfosIndexDivisor;
    }

    public boolean isInitializeHierarchyCache() {
        return this.initializeHierarchyCache;
    }

    public void setInitializeHierarchyCache(boolean initializeHierarchyCache) {
        this.initializeHierarchyCache = initializeHierarchyCache;
    }

    public void setReindexingPageSize(int reindexingPageSize) {
        this.reindexingPageSize = reindexingPageSize;
    }

    public void setRDBMSReindexing(boolean rdbmsReindexing) {
        this.rdbmsReindexing = rdbmsReindexing;
    }

    public void setIndexRecoveryMode(String indexRecoveryMode) {
        this.indexRecoveryMode = indexRecoveryMode;
    }

    public void setAsyncReindexing(boolean asyncReindexing) {
        this.asyncReindexing = asyncReindexing;
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("query handler closed and cannot be used anymore.");
        }
    }

    @Override
    public void logErrorChanges(Set<String> removed, Set<String> added) throws IOException {
        this.errorLog.writeChanges(removed, added);
    }

    private void doInitErrorLog() throws IOException {
        File file = new File(new File(this.path), ERROR_LOG);
        this.errorLog = new ErrorLog(file, this.errorLogfileSize);
    }

    private void recoverErrorLog(ErrorLog errlog) throws IOException, RepositoryException {
        HashSet<String> rem = new HashSet<String>();
        final HashSet<String> add = new HashSet<String>();
        errlog.readChanges(rem, add);
        if (rem.isEmpty() && add.isEmpty()) {
            return;
        }
        Iterator<String> removedStates = rem.iterator();
        Iterator<NodeData> addedStates = new Iterator<NodeData>(){
            private final Iterator<String> iter;
            {
                this.iter = add.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public NodeData next() {
                while (this.iter.hasNext()) {
                    String id = this.iter.next();
                    try {
                        ItemData item = SearchIndex.this.getContext().getItemStateManager().getItemData(id);
                        if (item != null) {
                            if (item.isNode()) {
                                return (NodeData)item;
                            }
                            log.warn("Node expected but property found with id " + id + ". Skipping " + item.getQPath().getAsString());
                            continue;
                        }
                        log.warn("Unable to recovery node index " + id + ". Node not found.");
                    }
                    catch (RepositoryException e) {
                        log.error("ErrorLog recovery error. Item id " + id + ". " + (Object)((Object)e), (Throwable)e);
                    }
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        this.updateNodes(removedStates, addedStates);
        errlog.clear();
    }

    @Override
    public QueryHits executeQuery(Query query) throws IOException {
        this.waitForResuming();
        this.checkOpen();
        IndexReader reader = this.getIndexReader(true);
        IndexSearcher searcher = new IndexSearcher(reader);
        searcher.setSimilarity(this.getSimilarity());
        return new LuceneQueryHits(reader, searcher, query, true);
    }

    @Override
    public void onChangeMode(IndexerIoMode mode) {
        try {
            if (mode == IndexerIoMode.READ_WRITE) {
                log.info("Processing error log ...");
                this.recoverErrorLog(this.errorLog);
            }
        }
        catch (IOException e) {
            log.error("Can not recover error log. On changed mode " + (Object)((Object)mode), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error("Can not recover error log.", (Throwable)e);
        }
    }

    @Override
    public void setOnline(boolean isOnline, boolean allowQuery, boolean dropStaleIndexes) throws IOException {
        this.checkOpen();
        this.allowQuery = isOnline ? true : allowQuery;
        this.index.setOnline(isOnline, dropStaleIndexes);
    }

    @Override
    public boolean isOnline() {
        return this.index.isOnline();
    }

    @Override
    public void suspend() throws SuspendException {
        this.latcher = new CountDownLatch(1);
        this.close();
        this.isSuspended = true;
    }

    @Override
    public void resume() throws ResumeException {
        try {
            this.closed = false;
            this.doInit();
            this.latcher.countDown();
            this.isSuspended = false;
        }
        catch (IOException e) {
            throw new ResumeException(e);
        }
        catch (RepositoryException e) {
            throw new ResumeException(e);
        }
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    private void waitForResuming() throws IOException {
        if (this.isSuspended) {
            try {
                this.latcher.await();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    protected static final class CombinedIndexReader
    extends MultiReader
    implements HierarchyResolver,
    MultiIndexReader {
        private final CachingMultiIndexReader[] subReaders;
        private int[] starts;

        public CombinedIndexReader(CachingMultiIndexReader[] indexReaders) {
            super((IndexReader[])indexReaders);
            this.subReaders = indexReaders;
            this.starts = new int[this.subReaders.length + 1];
            int maxDoc = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.starts[i] = maxDoc;
                maxDoc += this.subReaders[i].maxDoc();
            }
            this.starts[this.subReaders.length] = maxDoc;
        }

        public int[] getParents(int n, int[] docNumbers) throws IOException {
            int i = this.readerIndex(n);
            DocId id = this.subReaders[i].getParentDocId(n - this.starts[i]);
            id = id.applyOffset(this.starts[i]);
            return id.getDocumentNumbers(this, docNumbers);
        }

        public IndexReader[] getIndexReaders() {
            IndexReader[] readers = new IndexReader[this.subReaders.length];
            System.arraycopy(this.subReaders, 0, readers, 0, this.subReaders.length);
            return readers;
        }

        public void release() throws IOException {
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.subReaders[i].release();
            }
        }

        private int readerIndex(int n) {
            int lo = 0;
            int hi = this.subReaders.length - 1;
            while (hi >= lo) {
                int mid = lo + hi >> 1;
                int midValue = this.starts[mid];
                if (n < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (n > midValue) {
                    lo = mid + 1;
                    continue;
                }
                while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                    ++mid;
                }
                return mid;
            }
            return hi;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CombinedIndexReader) {
                CombinedIndexReader other = (CombinedIndexReader)obj;
                return Arrays.equals(this.subReaders, other.subReaders);
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                hash = 31 * hash + this.subReaders[i].hashCode();
            }
            return hash;
        }

        public ForeignSegmentDocId createDocId(String uuid) throws IOException {
            for (int i = 0; i < this.subReaders.length; ++i) {
                CachingMultiIndexReader subReader = this.subReaders[i];
                ForeignSegmentDocId doc = subReader.createDocId(uuid);
                if (doc == null) continue;
                return doc;
            }
            return null;
        }

        public int getDocumentNumber(ForeignSegmentDocId docId) {
            for (int i = 0; i < this.subReaders.length; ++i) {
                CachingMultiIndexReader subReader = this.subReaders[i];
                int realDoc = subReader.getDocumentNumber(docId);
                if (realDoc < 0) continue;
                return realDoc + this.starts[i];
            }
            return -1;
        }
    }
}

