/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.jcr.RepositoryException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.ComplexDataRestore;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DB2DBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DBBackup;
import org.exoplatform.services.jcr.impl.backup.rdbms.DBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.backup.rdbms.DirectoryRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.H2DBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.MySQLDBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.OracleDBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.RestoreTableRule;
import org.exoplatform.services.jcr.impl.backup.rdbms.SybaseDBRestore;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanService;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleaner;
import org.exoplatform.services.jcr.impl.core.query.NodeDataIndexingIterator;
import org.exoplatform.services.jcr.impl.core.query.Reindexable;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectReaderImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectWriterImpl;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.HSQLDBConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MySQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.OracleConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.indexing.JdbcNodeDataIndexingIterator;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.IngresSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.OracleDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.PgSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.statistics.StatisticsJDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.update.StorageUpdateManager;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.jdbc.DataSourceProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

public class JDBCWorkspaceDataContainer
extends WorkspaceDataContainerBase
implements Startable,
Backupable,
Reindexable {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCWorkspaceDataContainer");
    public static final boolean STATISTICS_ENABLED = Boolean.valueOf(PrivilegedSystemHelper.getProperty((String)"JDBCWorkspaceDataContainer.statistics.enabled"));
    public static final String SOURCE_NAME = "source-name";
    public static final String MULTIDB = "multi-db";
    public static final String SINGLEDB = "single-db";
    public static final String DB_DIALECT = "dialect";
    public static final String DB_DRIVER = "driverClassName";
    public static final String DB_URL = "url";
    public static final String DB_USERNAME = "username";
    public static final String DB_PASSWORD = "password";
    public static final String DB_FORCE_QUERY_HINTS = "force.query.hints";
    protected final String containerName;
    protected final String uniqueName;
    protected final String dbSourceName;
    protected final boolean multiDb;
    protected final String dbDriver;
    protected final String dbDialect;
    protected final String dbUrl;
    protected final String dbUserName;
    protected final String dbPassword;
    protected final DataSourceProvider dsProvider;
    protected final boolean isManaged;
    protected final ValueStoragePluginProvider valueStorageProvider;
    protected String storageVersion;
    protected boolean checkSNSNewConnection;
    protected int maxBufferSize;
    protected File swapDirectory;
    protected FileCleaner swapCleaner;
    protected GenericConnectionFactory connFactory;
    protected boolean useQueryHints;
    protected final WorkspaceEntry wsConfig;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JDBCWorkspaceDataContainer(WorkspaceEntry wsConfig, RepositoryEntry repConfig, InitialContextInitializer contextInit, ValueStoragePluginProvider valueStorageProvider, FileCleanerHolder fileCleanerHolder, DataSourceProvider dsProvider) throws RepositoryConfigurationException, NamingException, RepositoryException, IOException {
        block30: {
            String pDbDialect;
            block33: {
                String sn;
                block31: {
                    block32: {
                        this.checkIntegrity(wsConfig, repConfig);
                        this.wsConfig = wsConfig;
                        this.containerName = wsConfig.getName();
                        this.uniqueName = wsConfig.getUniqueName();
                        this.multiDb = Boolean.parseBoolean(wsConfig.getContainer().getParameterValue(MULTIDB));
                        this.valueStorageProvider = valueStorageProvider;
                        this.dsProvider = dsProvider;
                        pDbDialect = null;
                        try {
                            pDbDialect = DBInitializerHelper.validateDialect(wsConfig.getContainer().getParameterValue(DB_DIALECT));
                        }
                        catch (RepositoryConfigurationException e) {
                            pDbDialect = DBConstants.DB_DIALECT_GENERIC;
                        }
                        String pDbDriver = null;
                        String pDbUrl = null;
                        String pDbUserName = null;
                        String pDbPassword = null;
                        try {
                            pDbDriver = wsConfig.getContainer().getParameterValue(DB_DRIVER);
                            try {
                                pDbUserName = wsConfig.getContainer().getParameterValue(DB_USERNAME);
                                pDbPassword = wsConfig.getContainer().getParameterValue(DB_PASSWORD);
                            }
                            catch (RepositoryConfigurationException e) {
                                pDbPassword = null;
                                pDbUserName = null;
                            }
                            pDbUrl = wsConfig.getContainer().getParameterValue(DB_URL);
                        }
                        catch (RepositoryConfigurationException e) {
                            // empty catch block
                        }
                        if (pDbUrl == null) break block31;
                        this.dbDriver = pDbDriver;
                        this.dbUrl = pDbUrl;
                        this.dbUserName = pDbUserName;
                        this.dbPassword = pDbPassword;
                        this.dbSourceName = null;
                        this.isManaged = false;
                        LOG.info((Object)("Connect to JCR database as user '" + this.dbUserName + "'"));
                        if (pDbDialect != DBConstants.DB_DIALECT_GENERIC && !DBConstants.DB_DIALECT_AUTO.equalsIgnoreCase(pDbDialect)) break block32;
                        Connection jdbcConn = null;
                        try {
                            try {
                                jdbcConn = this.dbUserName != null ? DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword) : DriverManager.getConnection(this.dbUrl);
                                this.dbDialect = DialectDetecter.detect(jdbcConn.getMetaData());
                            }
                            catch (SQLException e) {
                                throw new RepositoryException((Throwable)e);
                            }
                            Object var15_20 = null;
                            if (jdbcConn == null) break block30;
                        }
                        catch (Throwable throwable) {
                            Object var15_21 = null;
                            if (jdbcConn == null) throw throwable;
                            try {
                                jdbcConn.close();
                                throw throwable;
                            }
                            catch (SQLException e) {
                                throw new RepositoryException((Throwable)e);
                            }
                        }
                        try {}
                        catch (SQLException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                        jdbcConn.close();
                        break block30;
                    }
                    this.dbDialect = pDbDialect;
                    break block30;
                }
                this.dbDriver = null;
                this.dbUrl = null;
                this.dbUserName = null;
                this.dbPassword = null;
                try {
                    sn = wsConfig.getContainer().getParameterValue(SOURCE_NAME);
                }
                catch (RepositoryConfigurationException e) {
                    sn = wsConfig.getContainer().getParameterValue("sourceName");
                }
                this.dbSourceName = sn;
                if (dsProvider == null) {
                    throw new IllegalArgumentException("Since a data source has been defined, the DataSourceProvider cannot be null, add it in your configuration.");
                }
                this.isManaged = dsProvider.isManaged(this.dbSourceName);
                if (pDbDialect != DBConstants.DB_DIALECT_GENERIC) break block33;
                final DataSource ds = this.getDataSource();
                Connection jdbcConn = null;
                try {
                    try {
                        jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                            @Override
                            public Connection run() throws Exception {
                                return ds.getConnection();
                            }
                        });
                        this.dbDialect = DialectDetecter.detect(jdbcConn.getMetaData());
                    }
                    catch (SQLException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                    Object var18_30 = null;
                    if (jdbcConn == null) break block30;
                }
                catch (Throwable throwable) {
                    Object var18_31 = null;
                    if (jdbcConn == null) throw throwable;
                    try {
                        jdbcConn.close();
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                }
                try {}
                catch (SQLException e) {
                    throw new RepositoryException((Throwable)e);
                }
                jdbcConn.close();
                break block30;
            }
            this.dbDialect = pDbDialect;
        }
        LOG.info((Object)("Using a dialect '" + this.dbDialect + "'"));
        this.useQueryHints = wsConfig.getContainer().getParameterBoolean(DB_FORCE_QUERY_HINTS, true);
        try {
            this.checkSNSNewConnection = wsConfig.getContainer().getParameterBoolean("check-sns-new-connection");
        }
        catch (RepositoryConfigurationException e) {
            this.checkSNSNewConnection = false;
        }
        try {
            this.maxBufferSize = wsConfig.getContainer().getParameterInteger("max-buffer-size");
        }
        catch (RepositoryConfigurationException e) {
            this.maxBufferSize = 204800;
        }
        try {
            String sdParam = wsConfig.getContainer().getParameterValue("swap-directory");
            this.swapDirectory = new File(sdParam);
        }
        catch (RepositoryConfigurationException e1) {
            this.swapDirectory = new File(DEF_SWAPDIR);
        }
        if (!PrivilegedFileHelper.exists((File)this.swapDirectory)) {
            PrivilegedFileHelper.mkdirs((File)this.swapDirectory);
        }
        this.swapCleaner = fileCleanerHolder.getFileCleaner();
        this.initDatabase();
        boolean enableStorageUpdate = false;
        this.storageVersion = StorageUpdateManager.checkVersion(this.dbSourceName, this.connFactory.getJdbcConnection(), this.multiDb, enableStorageUpdate);
        LOG.info((Object)this.getInfo());
    }

    protected GenericConnectionFactory defaultConnectionFactory() throws NamingException, RepositoryException {
        if (this.dbSourceName != null) {
            return new GenericConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
        }
        return new GenericConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
    }

    protected StorageDBInitializer defaultDBInitializer(String sqlPath) throws NamingException, RepositoryException, IOException {
        return new StorageDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
    }

    protected void checkIntegrity(WorkspaceEntry wsConfig, RepositoryEntry repConfig) throws RepositoryConfigurationException {
        for (WorkspaceEntry wsEntry : repConfig.getWorkspaceEntries()) {
            if (wsEntry.getName().equals(wsConfig.getName()) || !wsEntry.getContainer().getType().equals(wsConfig.getContainer().getType()) || !wsEntry.getContainer().getType().equals(this.getClass().getName())) continue;
            if (!wsEntry.getContainer().getParameterValue(MULTIDB).equals(wsConfig.getContainer().getParameterValue(MULTIDB))) {
                throw new RepositoryConfigurationException("All workspaces must be multi-db or single-db. But " + wsEntry.getName() + "- multi-db=" + wsEntry.getContainer().getParameterValue(MULTIDB) + " and " + wsConfig.getName() + "- multi-db=" + wsConfig.getContainer().getParameterValue(MULTIDB));
            }
            boolean isMulti = Boolean.parseBoolean(wsConfig.getContainer().getParameterValue(MULTIDB));
            String wsSourceName = null;
            String newWsSourceName = null;
            try {
                wsSourceName = wsEntry.getContainer().getParameterValue("sourceName");
                newWsSourceName = wsConfig.getContainer().getParameterValue("sourceName");
            }
            catch (RepositoryConfigurationException e) {
                // empty catch block
            }
            if (wsSourceName != null && newWsSourceName != null) {
                if (isMulti) {
                    if (!wsSourceName.equals(newWsSourceName)) continue;
                    throw new RepositoryConfigurationException("SourceName " + wsSourceName + " alredy in use in " + wsEntry.getName() + ". SourceName must be different in " + MULTIDB + ". Check configuration for " + wsConfig.getName());
                }
                if (wsSourceName.equals(newWsSourceName)) continue;
                throw new RepositoryConfigurationException("SourceName must be equals in single-db repository. Check " + wsEntry.getName() + " and " + wsConfig.getName());
            }
            String wsUri = null;
            String newWsUri = null;
            try {
                wsUri = wsEntry.getContainer().getParameterValue("db-url");
                newWsUri = wsConfig.getContainer().getParameterValue("db-url");
            }
            catch (RepositoryConfigurationException e) {
                // empty catch block
            }
            if (wsUri == null || newWsUri == null) continue;
            if (isMulti) {
                if (!wsUri.equals(newWsUri)) continue;
                throw new RepositoryConfigurationException("db-url  " + wsUri + " alredy in use in " + wsEntry.getName() + ". db-url must be different in " + MULTIDB + ". Check configuration for " + wsConfig.getName());
            }
            if (wsUri.equals(newWsUri)) continue;
            throw new RepositoryConfigurationException("db-url must be equals in single-db repository. Check " + wsEntry.getName() + " and " + wsConfig.getName());
        }
    }

    protected void initDatabase() throws NamingException, RepositoryException, IOException {
        StorageDBInitializer dbInitilizer = null;
        String sqlPath = null;
        if (this.dbDialect == DBConstants.DB_DIALECT_ORACLEOCI) {
            LOG.warn((Object)(DBConstants.DB_DIALECT_ORACLEOCI + " dialect is experimental!"));
            this.connFactory = this.dbSourceName != null ? this.defaultConnectionFactory() : new OracleConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_ORACLE) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_PGSQL) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = new PgSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL) {
            this.connFactory = this.dbSourceName != null ? new MySQLConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new MySQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL_UTF8) {
            this.connFactory = this.dbSourceName != null ? new MySQLConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new MySQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MSSQL) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DERBY) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2V8) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_SYBASE) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_INGRES) {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = new IngresSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_HSQLDB) {
            this.connFactory = this.dbSourceName != null ? new HSQLDBConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new HSQLDBConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = this.defaultDBInitializer(sqlPath);
        } else {
            this.connFactory = this.defaultConnectionFactory();
            sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
            dbInitilizer = this.defaultDBInitializer(sqlPath);
        }
        try {
            dbInitilizer.init();
        }
        catch (DBInitializerException e) {
            LOG.error((Object)("Error of init db " + e), (Throwable)e);
        }
    }

    protected GenericConnectionFactory getConnectionFactory() {
        return this.connFactory;
    }

    public WorkspaceStorageConnection openConnection() throws RepositoryException {
        WorkspaceStorageConnection con = this.connFactory.openConnection();
        if (STATISTICS_ENABLED) {
            con = new StatisticsJDBCStorageConnection(con);
        }
        return con;
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        WorkspaceStorageConnection con = this.connFactory.openConnection(readOnly);
        if (STATISTICS_ENABLED) {
            con = new StatisticsJDBCStorageConnection(con);
        }
        return con;
    }

    public WorkspaceStorageConnection reuseConnection(WorkspaceStorageConnection original) throws RepositoryException {
        if (original instanceof StatisticsJDBCStorageConnection) {
            original = ((StatisticsJDBCStorageConnection)original).getNestedWorkspaceStorageConnection();
        }
        if (original instanceof JDBCStorageConnection) {
            SharedConnectionFactory cFactory = new SharedConnectionFactory(((JDBCStorageConnection)original).getJdbcConnection(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            return STATISTICS_ENABLED ? new StatisticsJDBCStorageConnection(cFactory.openConnection(false)) : cFactory.openConnection(false);
        }
        return this.openConnection(false);
    }

    public String getName() {
        return this.containerName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getInfo() {
        String str = "JDBC based JCR Workspace Data container \ncontainer name: " + this.containerName + " \n" + (this.isManaged ? "managed " : "") + "data source JNDI name: " + this.dbSourceName + "\n" + "is multi database: " + this.multiDb + "\n" + "storage version: " + this.storageVersion + "\n" + "value storage provider: " + this.valueStorageProvider + "\n" + "max buffer size (bytes): " + this.maxBufferSize + "\n" + "swap directory path: " + PrivilegedFileHelper.getAbsolutePath((File)this.swapDirectory);
        return str;
    }

    public String getStorageVersion() {
        return this.storageVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start() {
        Connection con;
        block10: {
            con = null;
            con = this.getConnectionFactory().getJdbcConnection();
            if (con.getTransactionIsolation() >= 2) break block10;
            LOG.warn((Object)"Wrong default isolation level, please set the default isolation level to READ_COMMITTED or higher. Other default isolation levels are not supported");
        }
        Object var4_2 = null;
        if (con == null) return;
        try {
            con.close();
            return;
        }
        catch (SQLException e2) {}
        return;
        {
            catch (SQLException e) {
                LOG.error((Object)"Error checking isolation level configuration.", (Throwable)e);
                Object var4_3 = null;
                if (con == null) return;
                try {
                    con.close();
                    return;
                }
                catch (SQLException e2) {}
                return;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Error checking isolation level configuration.", (Throwable)e);
                Object var4_4 = null;
                if (con == null) return;
                try {
                    con.close();
                    return;
                }
                catch (SQLException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (con == null) throw throwable;
            try {
                con.close();
                throw throwable;
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void stop() {
    }

    public boolean isSame(WorkspaceDataContainer another) {
        if (another == this) {
            return true;
        }
        if (another instanceof JDBCWorkspaceDataContainer) {
            JDBCWorkspaceDataContainer anotherJdbc = (JDBCWorkspaceDataContainer)another;
            if (this.getDbSourceName() != null) {
                return this.getDbSourceName().equals(anotherJdbc.getDbSourceName());
            }
            return this.getDbDriver().equals(anotherJdbc.getDbDriver()) && this.getDbUrl().equals(anotherJdbc.getDbUrl()) && this.getDbUserName().equals(anotherJdbc.getDbUserName());
        }
        return false;
    }

    protected String getDbSourceName() {
        return this.dbSourceName;
    }

    protected String getDbDriver() {
        return this.dbDriver;
    }

    protected String getDbUrl() {
        return this.dbUrl;
    }

    protected String getDbUserName() {
        return this.dbUserName;
    }

    public boolean isCheckSNSNewConnection() {
        return this.checkSNSNewConnection;
    }

    public void clean() throws BackupException {
        try {
            DBCleanService.cleanWorkspaceData(this.wsConfig);
            if (this.wsConfig.getContainer().getValueStorages() != null) {
                for (ValueStorageEntry valueStorage : this.wsConfig.getContainer().getValueStorages()) {
                    File valueStorageDir = new File(valueStorage.getParameterValue("path"));
                    if (!PrivilegedFileHelper.exists((File)valueStorageDir)) continue;
                    DirectoryHelper.removeDirectory(valueStorageDir);
                }
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupException(e);
        }
        catch (NamingException e) {
            throw new BackupException(e);
        }
        catch (SQLException e) {
            throw new BackupException(e);
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void backup(File storageDir) throws BackupException {
        ObjectWriter backupInfo = null;
        try {
            try {
                backupInfo = new ObjectWriterImpl(PrivilegedFileHelper.fileOutputStream((File)new File(storageDir, "JDBCWorkspaceDataContainer.info")));
                backupInfo.writeString(this.containerName);
                backupInfo.writeBoolean(this.multiDb);
                HashMap<String, String> scripts = new HashMap<String, String>();
                if (this.multiDb) {
                    scripts.put("JCR_MITEM", "select * from JCR_MITEM where JCR_MITEM.NAME <> '__root_parent'");
                    scripts.put("JCR_MVALUE", "select * from JCR_MVALUE");
                    scripts.put("JCR_MREF", "select * from JCR_MREF");
                } else {
                    scripts.put("JCR_SITEM", "select * from JCR_SITEM where CONTAINER_NAME='" + this.containerName + "'");
                    scripts.put("JCR_SVALUE", "select V.* from JCR_SVALUE V, JCR_SITEM I where I.ID=V.PROPERTY_ID and I.CONTAINER_NAME='" + this.containerName + "'");
                    scripts.put("JCR_SREF", "select R.* from JCR_SREF R, JCR_SITEM I where I.ID=R.PROPERTY_ID and I.CONTAINER_NAME='" + this.containerName + "'");
                }
                Connection jdbcConn = this.connFactory.getJdbcConnection();
                DBBackup.backup(storageDir, jdbcConn, scripts);
                if (this.wsConfig.getContainer().getValueStorages() != null) {
                    for (ValueStorageEntry valueStorage : this.wsConfig.getContainer().getValueStorages()) {
                        File srcDir = new File(valueStorage.getParameterValue("path"));
                        if (!PrivilegedFileHelper.exists((File)srcDir)) {
                            throw new BackupException("Can't backup value storage. Directory " + srcDir.getName() + " doesn't exists");
                        }
                        File zipFile = new File(storageDir, "values-" + valueStorage.getId() + ".zip");
                        DirectoryHelper.compressDirectory(srcDir, zipFile);
                    }
                }
                Object var10_12 = null;
                if (backupInfo == null) return;
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
            catch (RepositoryConfigurationException e) {
                throw new BackupException(e);
            }
            catch (RepositoryException e) {
                throw new BackupException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (backupInfo == null) throw throwable;
            try {
                backupInfo.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new BackupException(e);
        }
        backupInfo.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataRestore getDataRestorer(DataRestoreContext context) throws BackupException {
        ComplexDataRestore complexDataRestore;
        ArrayList<DataRestore> restorers = new ArrayList<DataRestore>();
        ObjectReader backupInfo = null;
        try {
            try {
                HashSet<Integer> convertColumnIndex;
                File storageDir = (File)context.getObject("storage-dir");
                Connection jdbcConn = null;
                if (context.getObject("db-connection") == null) {
                    try {
                        jdbcConn = this.connFactory.getJdbcConnection();
                        jdbcConn.setAutoCommit(false);
                    }
                    catch (SQLException e) {
                        throw new BackupException(e);
                    }
                    catch (RepositoryException e) {
                        throw new BackupException(e);
                    }
                } else {
                    jdbcConn = (Connection)context.getObject("db-connection");
                }
                backupInfo = new ObjectReaderImpl(PrivilegedFileHelper.fileInputStream((File)new File(storageDir, "JDBCWorkspaceDataContainer.info")));
                String srcContainerName = backupInfo.readString();
                boolean srcMultiDb = backupInfo.readBoolean();
                LinkedHashMap<String, RestoreTableRule> tables = new LinkedHashMap<String, RestoreTableRule>();
                String dstTableName = "JCR_" + (this.multiDb ? "M" : "S") + "ITEM";
                String srcTableName = "JCR_" + (srcMultiDb ? "M" : "S") + "ITEM";
                RestoreTableRule restoreTableRule = new RestoreTableRule();
                restoreTableRule.setSrcContainerName(srcContainerName);
                restoreTableRule.setSrcMultiDb(srcMultiDb);
                restoreTableRule.setDstContainerName(this.containerName);
                restoreTableRule.setDstMultiDb(this.multiDb);
                restoreTableRule.setSrcTableName(srcTableName);
                if (this.multiDb) {
                    if (!srcMultiDb) {
                        restoreTableRule.setDeleteColumnIndex(4);
                        convertColumnIndex = new HashSet();
                        convertColumnIndex.add(0);
                        convertColumnIndex.add(1);
                        restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                    }
                } else if (srcMultiDb) {
                    restoreTableRule.setNewColumnIndex(4);
                    restoreTableRule.setNewColumnName("CONTAINER_NAME");
                    restoreTableRule.setNewColumnType(12);
                    convertColumnIndex = new HashSet();
                    convertColumnIndex.add(0);
                    convertColumnIndex.add(1);
                    restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                } else {
                    convertColumnIndex = new HashSet<Integer>();
                    convertColumnIndex.add(0);
                    convertColumnIndex.add(1);
                    convertColumnIndex.add(4);
                    restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                }
                tables.put(dstTableName, restoreTableRule);
                dstTableName = "JCR_" + (this.multiDb ? "M" : "S") + "VALUE";
                srcTableName = "JCR_" + (srcMultiDb ? "M" : "S") + "VALUE";
                restoreTableRule = new RestoreTableRule();
                restoreTableRule.setSrcContainerName(srcContainerName);
                restoreTableRule.setSrcMultiDb(srcMultiDb);
                restoreTableRule.setDstContainerName(this.containerName);
                restoreTableRule.setDstMultiDb(this.multiDb);
                restoreTableRule.setSrcTableName(srcTableName);
                restoreTableRule.setSkipColumnIndex(0);
                if (!this.multiDb || !srcMultiDb) {
                    convertColumnIndex = new HashSet();
                    convertColumnIndex.add(3);
                    restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                }
                tables.put(dstTableName, restoreTableRule);
                dstTableName = "JCR_" + (this.multiDb ? "M" : "S") + "REF";
                srcTableName = "JCR_" + (srcMultiDb ? "M" : "S") + "REF";
                restoreTableRule = new RestoreTableRule();
                restoreTableRule.setSrcContainerName(srcContainerName);
                restoreTableRule.setSrcMultiDb(srcMultiDb);
                restoreTableRule.setDstContainerName(this.containerName);
                restoreTableRule.setDstMultiDb(this.multiDb);
                restoreTableRule.setSrcTableName(srcTableName);
                if (!this.multiDb || !srcMultiDb) {
                    convertColumnIndex = new HashSet();
                    convertColumnIndex.add(0);
                    convertColumnIndex.add(1);
                    restoreTableRule.setConvertColumnIndex(convertColumnIndex);
                }
                tables.put(dstTableName, restoreTableRule);
                DBCleaner dbCleaner = null;
                dbCleaner = context.getObject("db-cleaner") != null ? (DBCleaner)context.getObject("db-cleaner") : DBCleanService.getWorkspaceDBCleaner(jdbcConn, this.wsConfig);
                if (this.dbDialect == DBConstants.DB_DIALECT_DB2 || this.dbDialect == DBConstants.DB_DIALECT_DB2V8) {
                    restorers.add(new DB2DBRestore(storageDir, jdbcConn, tables, this.wsConfig, this.swapCleaner, dbCleaner));
                } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL || this.dbDialect == DBConstants.DB_DIALECT_MYSQL_UTF8) {
                    restorers.add(new MySQLDBRestore(storageDir, jdbcConn, tables, this.wsConfig, this.swapCleaner, dbCleaner));
                } else if (this.dbDialect == DBConstants.DB_DIALECT_H2) {
                    restorers.add(new H2DBRestore(storageDir, jdbcConn, tables, this.wsConfig, this.swapCleaner, dbCleaner));
                } else if (this.dbDialect == DBConstants.DB_DIALECT_SYBASE) {
                    restorers.add(new SybaseDBRestore(storageDir, jdbcConn, tables, this.wsConfig, this.swapCleaner, dbCleaner));
                } else if (this.dbDialect == DBConstants.DB_DIALECT_ORACLE || this.dbDialect == DBConstants.DB_DIALECT_ORACLEOCI) {
                    restorers.add(new OracleDBRestore(storageDir, jdbcConn, tables, this.wsConfig, this.swapCleaner, dbCleaner));
                } else {
                    restorers.add(new DBRestore(storageDir, jdbcConn, tables, this.wsConfig, this.swapCleaner, dbCleaner));
                }
                File backupValueStorageDir = new File(storageDir, "values");
                if (this.wsConfig.getContainer().getValueStorages() != null) {
                    ArrayList<File> dataDirs = new ArrayList<File>();
                    ArrayList<File> backupDirs = new ArrayList<File>();
                    ArrayList<ValueStorageEntry> valueStorages = this.wsConfig.getContainer().getValueStorages();
                    for (ValueStorageEntry valueStorage : valueStorages) {
                        File dataDir = new File(valueStorage.getParameterValue("path"));
                        dataDirs.add(dataDir);
                        File zipFile = new File(storageDir, "values-" + valueStorage.getId() + ".zip");
                        if (PrivilegedFileHelper.exists((File)zipFile)) {
                            backupDirs.add(zipFile);
                            continue;
                        }
                        zipFile = new File(storageDir, "values/" + valueStorage.getId());
                        if (!PrivilegedFileHelper.exists((File)zipFile)) throw new RepositoryConfigurationException("There is no backup data for value storage with id " + valueStorage.getId());
                        backupDirs.add(zipFile);
                    }
                    restorers.add(new DirectoryRestore(dataDirs, backupDirs));
                }
                complexDataRestore = new ComplexDataRestore(restorers);
                Object var22_28 = null;
                if (backupInfo == null) return complexDataRestore;
            }
            catch (FileNotFoundException e) {
                throw new BackupException(e);
            }
            catch (IOException e) {
                throw new BackupException(e);
            }
            catch (NamingException e) {
                throw new BackupException(e);
            }
            catch (SQLException e) {
                throw new BackupException(e);
            }
            catch (RepositoryConfigurationException e) {
                throw new BackupException(e);
            }
        }
        catch (Throwable throwable) {
            Object var22_29 = null;
            if (backupInfo == null) throw throwable;
            try {
                backupInfo.close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Object)"Can't close object reader", (Throwable)e);
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            LOG.error((Object)"Can't close object reader", (Throwable)e);
            return complexDataRestore;
        }
        backupInfo.close();
        return complexDataRestore;
    }

    public NodeDataIndexingIterator getNodeDataIndexingIterator(int pageSize) throws RepositoryException {
        if (this.isReindexingSupport()) {
            return new JdbcNodeDataIndexingIterator(this.connFactory, pageSize);
        }
        throw new UnsupportedOperationException("The method getNodeDataIndexingIterator is not supported for this type of connection use the complex queries instead");
    }

    public boolean isReindexingSupport() {
        return this.connFactory.isReindexingSupport();
    }

    protected DataSource getDataSource() throws RepositoryException {
        try {
            return this.dsProvider.getDataSource(this.dbSourceName);
        }
        catch (NamingException e) {
            throw new RepositoryException("Datasource '" + this.dbSourceName + "' is not bound in this context.", (Throwable)e);
        }
    }

    static {
        if (STATISTICS_ENABLED) {
            LOG.info((Object)"The statistics of the component JDBCWorkspaceDataContainer has been enabled");
        }
    }

    class SharedConnectionFactory
    extends GenericConnectionFactory {
        private final Connection connection;

        SharedConnectionFactory(Connection connection, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) {
            super(null, null, null, null, null, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
            this.connection = connection;
        }

        public Connection getJdbcConnection() throws RepositoryException {
            return this.connection;
        }
    }
}

