/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.cas;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCUtils;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordAlreadyExistsException;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.cas.VCASException;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCValueContentAddressStorageImpl
implements ValueContentAddressStorage {
    public static final String JDBC_SOURCE_NAME_PARAM = "jdbc-source-name";
    public static final String JDBC_DIALECT_PARAM = "jdbc-dialect";
    public static final String TABLE_NAME_PARAM = "jdbc-table-name";
    public static final String DEFAULT_TABLE_NAME = "JCR_VCAS";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCValueContentAddressStorageImpl");
    private static final String MYSQL_PK_CONSTRAINT_DETECT_PATTERN = "(.*Constraint+.*Violation+.*Duplicate+.*entry+.*)+?";
    private static final Pattern MYSQL_PK_CONSTRAINT_DETECT = Pattern.compile("(.*Constraint+.*Violation+.*Duplicate+.*entry+.*)+?", 2);
    private static final String DB2_PK_CONSTRAINT_DETECT_PATTERN = "(.*DB2 SQL [Ee]rror+.*SQLCODE[:=].?-803+.*SQLSTATE[:=].?23505+.*%s.*)+?";
    private static final String H2_PK_CONSTRAINT_DETECT_PATTERN = "(.*JdbcSQLException.*violation.*PRIMARY_KEY_.*)";
    private static final Pattern H2_PK_CONSTRAINT_DETECT = Pattern.compile("(.*JdbcSQLException.*violation.*PRIMARY_KEY_.*)", 2);
    private Pattern DB2_PK_CONSTRAINT_DETECT;
    protected DataSource dataSource;
    protected String tableName;
    protected String dialect;
    protected String sqlAddRecord;
    protected String sqlDeleteRecord;
    protected String sqlDeleteValueRecord;
    protected String sqlSelectRecord;
    protected String sqlSelectRecords;
    protected String sqlSelectOwnRecords;
    protected String sqlSelectSharingProps;
    protected String sqlConstraintPK;
    protected String sqlVCASIDX;

    /*
     * Loose catch block
     */
    @Override
    public void init(Properties props) throws RepositoryConfigurationException, VCASException {
        block21: {
            String sn = props.getProperty(JDBC_SOURCE_NAME_PARAM);
            if (sn == null) {
                throw new RepositoryConfigurationException("jdbc-source-name parameter expected!");
            }
            try {
                SQLException e2;
                Statement st;
                Connection conn;
                block20: {
                    block19: {
                        this.dataSource = (DataSource)new InitialContext().lookup(sn);
                        conn = null;
                        st = null;
                        conn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                            @Override
                            public Connection run() throws Exception {
                                return JDBCValueContentAddressStorageImpl.this.dataSource.getConnection();
                            }
                        });
                        DatabaseMetaData dbMetaData = conn.getMetaData();
                        String dialect = props.getProperty(JDBC_DIALECT_PARAM);
                        if (dialect == null || DBConstants.DB_DIALECT_AUTO.equalsIgnoreCase(dialect)) {
                            dialect = DialectDetecter.detect(dbMetaData);
                        }
                        this.dialect = dialect;
                        String tn = props.getProperty(TABLE_NAME_PARAM);
                        this.tableName = tn != null ? tn : DEFAULT_TABLE_NAME;
                        String pattern = String.format(DB2_PK_CONSTRAINT_DETECT_PATTERN, this.tableName);
                        this.DB2_PK_CONSTRAINT_DETECT = Pattern.compile(pattern, 2);
                        this.sqlConstraintPK = this.tableName + "_PK";
                        this.sqlVCASIDX = this.tableName + "_IDX";
                        if (DBConstants.DB_DIALECT_PGSQL.equalsIgnoreCase(dialect) || DBConstants.DB_DIALECT_INGRES.equalsIgnoreCase(dialect)) {
                            this.tableName = this.tableName.toUpperCase().toLowerCase();
                            this.sqlConstraintPK = this.sqlConstraintPK.toUpperCase().toLowerCase();
                            this.sqlVCASIDX = this.sqlVCASIDX.toUpperCase().toLowerCase();
                        }
                        this.sqlAddRecord = "INSERT INTO " + this.tableName + " (PROPERTY_ID, ORDER_NUM, CAS_ID) VALUES(?,?,?)";
                        this.sqlDeleteRecord = "DELETE FROM " + this.tableName + " WHERE PROPERTY_ID=?";
                        this.sqlDeleteValueRecord = "DELETE FROM " + this.tableName + " WHERE PROPERTY_ID=? AND ORDER_NUM=?";
                        this.sqlSelectRecord = "SELECT CAS_ID FROM " + this.tableName + " WHERE PROPERTY_ID=? AND ORDER_NUM=?";
                        this.sqlSelectRecords = "SELECT CAS_ID, ORDER_NUM FROM " + this.tableName + " WHERE PROPERTY_ID=? ORDER BY ORDER_NUM";
                        this.sqlSelectOwnRecords = "SELECT P.CAS_ID, P.ORDER_NUM, S.CAS_ID as SHARED_ID FROM " + this.tableName + " P LEFT JOIN " + this.tableName + " S ON P.PROPERTY_ID<>S.PROPERTY_ID AND P.CAS_ID=S.CAS_ID " + "WHERE P.PROPERTY_ID=? GROUP BY P.CAS_ID, P.ORDER_NUM, S.CAS_ID ORDER BY P.ORDER_NUM";
                        this.sqlSelectSharingProps = "SELECT DISTINCT C.PROPERTY_ID AS PROPERTY_ID FROM " + this.tableName + " C, " + this.tableName + " P " + "WHERE C.CAS_ID=P.CAS_ID AND C.PROPERTY_ID<>P.PROPERTY_ID AND P.PROPERTY_ID=?";
                        if (!JDBCUtils.tableExists(this.tableName, conn)) {
                            st = conn.createStatement();
                            st.executeUpdate("CREATE TABLE " + this.tableName + " (PROPERTY_ID VARCHAR(96) NOT NULL, ORDER_NUM INTEGER NOT NULL, CAS_ID VARCHAR(512) NOT NULL, " + "CONSTRAINT " + this.sqlConstraintPK + " PRIMARY KEY(PROPERTY_ID, ORDER_NUM))");
                            st.executeUpdate("CREATE INDEX " + this.sqlVCASIDX + " ON " + this.tableName + "(CAS_ID, PROPERTY_ID, ORDER_NUM)");
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("JDBC Value Content Address Storage initialized in database " + sn));
                            }
                            break block19;
                        }
                        if (!LOG.isDebugEnabled()) break block19;
                        LOG.debug((Object)("JDBC Value Content Address Storage already initialized in database " + sn));
                    }
                    Object var10_11 = null;
                    if (st == null) break block20;
                    try {
                        st.close();
                    }
                    catch (SQLException e2) {
                        LOG.error((Object)("Can't close the Statement: " + e2));
                    }
                }
                if (conn == null) break block21;
                try {
                    conn.close();
                    break block21;
                }
                catch (SQLException e2) {
                    throw new VCASException("VCAS INIT database error on Connection close: " + e2, e2);
                }
                {
                    catch (SQLException e3) {
                        throw new VCASException("VCAS INIT database error: " + e3, e3);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e2) {
                            LOG.error((Object)("Can't close the Statement: " + e2));
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e2) {
                            throw new VCASException("VCAS INIT database error on Connection close: " + e2, e2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (NamingException e) {
                throw new RepositoryConfigurationException("JDBC data source is not available in JNDI with name '" + sn + "'. Error: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValue(String propertyId, int orderNum, String identifier) throws VCASException {
        try {
            Connection con = this.dataSource.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement(this.sqlAddRecord);
                ps.setString(1, propertyId);
                ps.setInt(2, orderNum);
                ps.setString(3, identifier);
                ps.executeUpdate();
                ps.close();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            if (this.isRecordAlreadyExistsException(e)) {
                throw new RecordAlreadyExistsException("Record already exists, propertyId=" + propertyId + " orderNum=" + orderNum + ". Error: " + e, e);
            }
            throw new VCASException("VCAS ADD database error: " + e, e);
        }
    }

    private boolean isRecordAlreadyExistsException(SQLException e) {
        String err = e.toString();
        if (DBConstants.DB_DIALECT_MYSQL.equalsIgnoreCase(this.dialect) || DBConstants.DB_DIALECT_MYSQL_UTF8.equalsIgnoreCase(this.dialect)) {
            return MYSQL_PK_CONSTRAINT_DETECT.matcher(err).find();
        }
        if (err.toLowerCase().toUpperCase().indexOf(this.sqlConstraintPK.toLowerCase().toUpperCase()) >= 0) {
            return true;
        }
        if (DBConstants.DB_DIALECT_DB2.equalsIgnoreCase(this.dialect)) {
            return this.DB2_PK_CONSTRAINT_DETECT.matcher(err).find();
        }
        if (DBConstants.DB_DIALECT_H2.equalsIgnoreCase(this.dialect)) {
            return H2_PK_CONSTRAINT_DETECT.matcher(err).find();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProperty(String propertyId) throws VCASException {
        try {
            Connection con = this.dataSource.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement(this.sqlDeleteRecord);
                ps.setString(1, propertyId);
                int res = ps.executeUpdate();
                ps.close();
                if (res <= 0) {
                    throw new RecordNotFoundException("Record not found, propertyId=" + propertyId);
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            throw new VCASException("VCAS DELETE database error: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteValue(String propertyId, int orderNumb) throws VCASException {
        try {
            Connection con = this.dataSource.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement(this.sqlDeleteValueRecord);
                ps.setString(1, propertyId);
                ps.setInt(2, orderNumb);
                int res = ps.executeUpdate();
                ps.close();
                if (res <= 0) {
                    throw new RecordNotFoundException("Value record not found, propertyId=" + propertyId + " orderNumb=" + orderNumb);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (SQLException e) {
            throw new VCASException("VCAS Value DELETE database error: " + e, e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getIdentifier(String propertyId, int orderNum) throws VCASException {
        try {
            block17: {
                block14: {
                    con = this.dataSource.getConnection();
                    rs = null;
                    ps = null;
                    try {
                        ps = con.prepareStatement(this.sqlSelectRecord);
                        ps.setString(1, propertyId);
                        ps.setInt(2, orderNum);
                        rs = ps.executeQuery();
                        if (!rs.next()) {
                            throw new RecordNotFoundException("No record found with propertyId=" + propertyId + " orderNum=" + orderNum);
                        }
                        var6_7 = rs.getString("CAS_ID");
                        var8_8 = null;
                        if (rs == null) break block14;
                    }
                    catch (Throwable var7_12) {
                        var8_9 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e) {
                                JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the ResultSet: " + e));
                            }
                        }
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (SQLException e) {
                                JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the Statement: " + e));
                            }
                        }
                        con.close();
                        throw var7_12;
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 133->143)] { 
lbl37:
                    // 1 sources

                    rs.close();
                    break block14;
lbl39:
                    // 1 sources

                    catch (SQLException e) {
                        JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the ResultSet: " + e));
                    }
                }
                if (ps != null) {
                    ** try [egrp 3[TRYBLOCK] [3 : 178->188)] { 
lbl44:
                    // 1 sources

                    ps.close();
                    break block17;
lbl46:
                    // 1 sources

                    catch (SQLException e) {
                        JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the Statement: " + e));
                    }
                }
            }
            con.close();
            return var6_7;
        }
        catch (SQLException e) {
            throw new VCASException("VCAS GET ID database error: " + e, e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getIdentifiers(String propertyId, boolean ownOnly) throws VCASException {
        try {
            block29: {
                block28: {
                    block24: {
                        block27: {
                            block22: {
                                block23: {
                                    con = this.dataSource.getConnection();
                                    ps = null;
                                    rs = null;
                                    try {
                                        ids = new ArrayList<String>();
                                        if (ownOnly) {
                                            ps = con.prepareStatement(this.sqlSelectOwnRecords);
                                            ps.setString(1, propertyId);
                                            rs = ps.executeQuery();
                                            if (!rs.next()) {
                                                throw new RecordNotFoundException("No records found with propertyId=" + propertyId);
                                            }
                                            do {
                                                rs.getString("SHARED_ID");
                                                if (!rs.wasNull()) continue;
                                                ids.add(rs.getString("CAS_ID"));
                                            } while (rs.next());
                                            var7_8 = ids;
                                            var9_10 = null;
                                            if (rs == null) break block22;
                                            break block23;
                                        }
                                        ps = con.prepareStatement(this.sqlSelectRecords);
                                        ps.setString(1, propertyId);
                                        rs = ps.executeQuery();
                                        if (!rs.next()) {
                                            throw new RecordNotFoundException("No records found with propertyId=" + propertyId);
                                        }
                                        do {
                                            ids.add(rs.getString("CAS_ID"));
                                        } while (rs.next());
                                        var7_9 = ids;
                                        break block24;
                                    }
                                    catch (Throwable var8_16) {
                                        var9_12 = null;
                                        if (rs != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (SQLException e) {
                                                JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the ResultSet: " + e));
                                            }
                                        }
                                        if (ps != null) {
                                            try {
                                                ps.close();
                                            }
                                            catch (SQLException e) {
                                                JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the Statement: " + e));
                                            }
                                        }
                                        con.close();
                                        throw var8_16;
                                    }
                                }
                                ** try [egrp 2[TRYBLOCK] [3 : 272->282)] { 
lbl58:
                                // 1 sources

                                rs.close();
                                break block22;
lbl60:
                                // 1 sources

                                catch (SQLException e) {
                                    JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the ResultSet: " + e));
                                }
                            }
                            if (ps != null) {
                                ** try [egrp 3[TRYBLOCK] [4 : 317->327)] { 
lbl65:
                                // 1 sources

                                ps.close();
                                break block27;
lbl67:
                                // 1 sources

                                catch (SQLException e) {
                                    JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the Statement: " + e));
                                }
                            }
                        }
                        con.close();
                        return var7_8;
                    }
                    var9_11 = null;
                    if (rs != null) {
                        ** try [egrp 2[TRYBLOCK] [3 : 272->282)] { 
lbl76:
                        // 1 sources

                        rs.close();
                        break block28;
lbl78:
                        // 1 sources

                        catch (SQLException e) {
                            JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the ResultSet: " + e));
                        }
                    }
                }
                if (ps != null) {
                    ** try [egrp 3[TRYBLOCK] [4 : 317->327)] { 
lbl83:
                    // 1 sources

                    ps.close();
                    break block29;
lbl85:
                    // 1 sources

                    catch (SQLException e) {
                        JDBCValueContentAddressStorageImpl.LOG.error((Object)("Can't close the Statement: " + e));
                    }
                }
            }
            con.close();
            return var7_9;
        }
        catch (SQLException e) {
            throw new VCASException("VCAS GET IDs database error: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasSharedContent(String propertyId) throws VCASException {
        try {
            boolean bl;
            Connection con;
            block8: {
                con = this.dataSource.getConnection();
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement(this.sqlSelectSharingProps);
                    ps.setString(1, propertyId);
                    bl = ps.executeQuery().next();
                    Object var6_6 = null;
                    if (ps == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e) {
                            LOG.error((Object)("Can't close the Statement: " + e));
                        }
                    }
                    con.close();
                    throw throwable;
                }
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the Statement: " + e));
                }
            }
            con.close();
            return bl;
        }
        catch (SQLException e) {
            throw new VCASException("VCAS HAS SHARED IDs database error: " + e, e);
        }
    }
}

