/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.path;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.Name;
import org.exoplatform.services.html.path.NodePath;

public class NodePathParser {
    public static synchronized NodePath toPath(String text) throws Exception {
        return new NodePath(NodePathParser.toIndexs(text));
    }

    public static synchronized NodePath.Index[] toIndexs(String text) throws Exception {
        String[] split = text.split("\\.");
        NodePath.Index[] indexs = new NodePath.Index[split.length];
        for (int i = 0; i < split.length; ++i) {
            indexs[i] = NodePathParser.toIndex(split[i]);
        }
        return indexs;
    }

    public static synchronized NodePath toPath(HTMLNode element) {
        return new NodePath(NodePathParser.toIndexs(element));
    }

    public static synchronized NodePath.Index[] toIndexs(HTMLNode element) {
        HTMLNode parent = element.getParent();
        ArrayList<NodePath.Index> list = new ArrayList<NodePath.Index>();
        while (parent != null) {
            list.add(NodePathParser.toIndex(parent, element));
            element = parent;
            parent = element.getParent();
        }
        NodePath.Index[] indexs = new NodePath.Index[list.size()];
        for (int i = list.size() - 1; i > -1; --i) {
            indexs[list.size() - i - 1] = (NodePath.Index)list.get(i);
        }
        return indexs;
    }

    private static NodePath.Index toIndex(HTMLNode parent, HTMLNode element) {
        List<HTMLNode> children = parent.getChildren();
        int count = -1;
        for (HTMLNode ele : children) {
            if (ele.getName() != element.getName()) continue;
            ++count;
            if (ele != element) continue;
            break;
        }
        return new NodePath.Index(element.getName(), count);
    }

    static NodePath.Index toIndex(String name) throws Exception {
        int idx = 0;
        int squareBracketStart = name.indexOf(91);
        int squareBracketEnd = name.indexOf(93);
        if (squareBracketStart < 0 && squareBracketEnd > -1) {
            throw new Exception(name + " is invalid ");
        }
        if (squareBracketStart > -1 && squareBracketEnd < 0) {
            throw new Exception(name + " is invalid ");
        }
        if (squareBracketStart < 0 && squareBracketEnd < 0) {
            return new NodePath.Index(Name.valueOf(name.toUpperCase()), 0);
        }
        String sIDX = name.substring(squareBracketStart + 1, squareBracketEnd).trim();
        name = name.substring(0, squareBracketStart);
        idx = Integer.parseInt(sIDX);
        if (idx < 0) {
            throw new IndexOutOfBoundsException();
        }
        return new NodePath.Index(Name.valueOf(name.toUpperCase()), idx);
    }
}

