/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SynchronizeRemoteCalendarJob
implements Job {
    public static final String SYNCHRONIZE_REMOTE_CALENDAR_JOB = "SynchonizeRemoteCalendarJob";
    public static final String SYNCHRONIZE_REMOTE_CALENDAR_GROUP = "SynchonizeRemoteCalendarGroup";
    private static final String CALENDARS = "calendars".intern();
    public static Boolean isExecuting = false;
    private static Log log_ = ExoLogger.getLogger((String)"cs.calendar.job.synchronizeremote");
    public static final String USERNAME = "username";
    public static final String REPOSITORY_NAME = "repository";
    private String username;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        block40: {
            block38: {
                SynchronizeRemoteCalendarJob.isExecuting = true;
                container = Utils.getPortalContainer(context);
                if (container == null) {
                    return;
                }
                oldContainer = ExoContainerContext.getCurrentContainer();
                ExoContainerContext.setCurrentContainer((ExoContainer)container);
                provider = SessionProvider.createSystemProvider();
                calService = (CalendarService)container.getComponentInstanceOfType(CalendarService.class);
                repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                currentRepo = null;
                try {
                    currentRepo = repositoryService.getCurrentRepository().getConfiguration().getName();
                }
                catch (RepositoryException e) {
                    SynchronizeRemoteCalendarJob.log_.warn((Object)"Can't get current repository name", (Throwable)e);
                }
                total = 0;
                success = 0;
                failed = 0;
                start = System.currentTimeMillis();
                if (SynchronizeRemoteCalendarJob.log_.isDebugEnabled()) {
                    SynchronizeRemoteCalendarJob.log_.debug((Object)"Remote calendar synchronization service");
                }
                jobDetail = context.getJobDetail();
                dataMap = jobDetail.getJobDataMap();
                this.username = dataMap.getString("username");
                if (this.username != null) break block38;
                provider.close();
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                SynchronizeRemoteCalendarJob.isExecuting = false;
                if (currentRepo != null) {
                    try {
                        repositoryService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e) {
                        SynchronizeRemoteCalendarJob.log_.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                    }
                }
                return;
            }
            try {
                repositoryService.setCurrentRepositoryName(dataMap.getString("repository"));
                userCalendarHome = this.getUserCalendarHome(provider);
                path = new StringBuffer("/jcr:root");
                path.append(userCalendarHome.getPath());
                path.append("//element(*,exo:remoteCalendar)");
                queryManager = this.getSession(provider).getWorkspace().getQueryManager();
                query = queryManager.createQuery(path.toString(), "xpath");
                results = query.execute();
                iter = results.getNodes();
                while (iter.hasNext()) {
                    ++total;
                    remoteCalendar = iter.nextNode();
                    remoteCalendarId = remoteCalendar.getProperty(Utils.EXO_ID).getString();
                    remoteType = remoteCalendar.getProperty(Utils.EXO_REMOTE_TYPE).getString();
                    syncPeriod = remoteCalendar.getProperty(Utils.EXO_REMOTE_SYNC_PERIOD).getString();
                    try {
                        if (syncPeriod.equals("auto")) {
                            calService.refreshRemoteCalendar(this.username, remoteCalendarId);
                            ++success;
                            continue;
                        }
                        lastUpdate = remoteCalendar.getProperty(Utils.EXO_REMOTE_LAST_UPDATED).getDate().getTimeInMillis();
                        now = Utils.getGreenwichMeanTime().getTimeInMillis();
                        interval = 0L;
                        if ("5mins".equals(syncPeriod)) {
                            interval = 300000L;
                        }
                        if ("10mins".equals(syncPeriod)) {
                            interval = 600000L;
                        }
                        if ("15mins".equals(syncPeriod)) {
                            interval = 900000L;
                        }
                        if ("1hour".equals(syncPeriod)) {
                            interval = 3600000L;
                        }
                        if ("1day".equals(syncPeriod)) {
                            interval = 86400000L;
                        }
                        if ("1week".equals(syncPeriod)) {
                            interval = 604800000L;
                        }
                        if ("1year".equals(syncPeriod)) {
                            interval = 1708667904L;
                        }
                        if (lastUpdate + interval >= now) continue;
                        calService.refreshRemoteCalendar(this.username, remoteCalendarId);
                        ++success;
                    }
                    catch (Exception e) {
                        SynchronizeRemoteCalendarJob.log_.debug((Object)("Skip this calendar, error when reload remote calendar " + remoteCalendarId + ". Error message: " + e.getMessage()));
                        ++failed;
                    }
                }
            }
            catch (RepositoryException e) {
                block39: {
                    if (!SynchronizeRemoteCalendarJob.log_.isDebugEnabled()) break block39;
                    SynchronizeRemoteCalendarJob.log_.debug((Object)"Data base not ready!");
                }
                provider.close();
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                SynchronizeRemoteCalendarJob.isExecuting = false;
                if (currentRepo != null) {
                    try {
                        repositoryService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e) {
                        SynchronizeRemoteCalendarJob.log_.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                    }
                }
                break block40;
            }
            catch (Exception e) {
                block41: {
                    if (!SynchronizeRemoteCalendarJob.log_.isDebugEnabled()) break block41;
                    SynchronizeRemoteCalendarJob.log_.debug((Object)"Exception when synchronize remote calendar. ", (Throwable)e);
                    {
                        catch (Throwable var31_37) {
                            provider.close();
                            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                            SynchronizeRemoteCalendarJob.isExecuting = false;
                            if (currentRepo != null) {
                                try {
                                    repositoryService.setCurrentRepositoryName(currentRepo);
                                }
                                catch (RepositoryConfigurationException e) {
                                    SynchronizeRemoteCalendarJob.log_.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                                }
                            }
                            throw var31_37;
                        }
                    }
                }
                provider.close();
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                SynchronizeRemoteCalendarJob.isExecuting = false;
                if (currentRepo != null) {
                    try {
                        repositoryService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e) {
                        SynchronizeRemoteCalendarJob.log_.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                    }
                } else {
                    ** GOTO lbl139
                }
            }
            provider.close();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
            SynchronizeRemoteCalendarJob.isExecuting = false;
            if (currentRepo != null) {
                try {
                    repositoryService.setCurrentRepositoryName(currentRepo);
                }
                catch (RepositoryConfigurationException e) {
                    SynchronizeRemoteCalendarJob.log_.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                }
            }
        }
        finish = System.currentTimeMillis();
        spent = finish - start;
        if (total > 0) {
            SynchronizeRemoteCalendarJob.log_.info((Object)("Reload remote calendar completed. Total: " + total + ", Success: " + success + ", Failed: " + failed + ", Skip: " + (total - success - failed) + ". Time spent: " + spent + " ms."));
        }
    }

    private Session getSession(SessionProvider sprovider) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository currentRepo = repositoryService.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    public static JobInfo getJobInfo(String username) {
        JobInfo info = new JobInfo(SynchronizeRemoteCalendarJob.getRemoteCalendarName(username), SYNCHRONIZE_REMOTE_CALENDAR_GROUP, SynchronizeRemoteCalendarJob.class);
        return info;
    }

    public static String getRemoteCalendarName(String username) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        String repoName = null;
        try {
            repoName = repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e) {
            log_.error((Object)"Repository is error", (Throwable)e);
        }
        StringBuilder jobNameBd = new StringBuilder().append(SYNCHRONIZE_REMOTE_CALENDAR_JOB).append("_").append(username).append("_").append(repoName);
        return jobNameBd.toString();
    }

    private Node getUserCalendarHome(SessionProvider provider) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
            Node userApp = nodeHierarchyCreator.getUserApplicationNode(provider, this.username);
            Node userCalendarApp = userApp.getNode(Utils.CALENDAR_APP);
            return userCalendarApp.getNode(CALENDARS);
        }
        catch (Exception e) {
            return null;
        }
    }
}

