/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.exoplatform.wsqa.httpclient.HttpResponseBody;
import org.exoplatform.wsqa.httpclient.HttpResponseHeader;
import org.exoplatform.wsqa.httpclient.URI;

public class HttpResponse {
    private HttpResponseHeader header_;
    private HttpResponseBody body_;
    private URI requestURI_;

    public HttpResponse(InputStream is, URI requestURI) throws Exception {
        this.requestURI_ = requestURI;
        this.header_ = new HttpResponseHeader(is);
        this.body_ = new HttpResponseBody(is, this.requestURI_, this.header_);
    }

    public HttpResponseHeader getHttpResponseHeader() {
        return this.header_;
    }

    public HttpResponseBody getHttpResponseBody() {
        return this.body_;
    }

    public byte[] getOriginalResponseData() throws Exception {
        byte[] bodyData;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (this.header_.getOriginalHeaderDataAsByte() != null) {
            os.write(this.header_.getOriginalHeaderDataAsByte());
        }
        if ((bodyData = this.body_.getBodyDataAsByte()).length > 0) {
            os.write(bodyData);
        }
        return os.toByteArray();
    }

    public void forward(OutputStream out) throws Exception {
        out.write(this.header_.getOriginalHeaderDataAsByte());
        if (this.header_.getStatusCode() == 304) {
            return;
        }
        if (this.header_.getStatusCode() == 302) {
            return;
        }
        out.write(this.body_.getBodyDataAsByte());
    }

    public byte[] getResponseData() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.header_.getHeaderDataAsByte());
        if (this.header_.getStatusCode() == 304) {
            os.toByteArray();
        }
        if (this.header_.getStatusCode() == 302) {
            return os.toByteArray();
        }
        os.write(this.body_.getBodyDataAsByte());
        return os.toByteArray();
    }

    public String getResponseDataAsText() throws Exception {
        return new String(this.getResponseData());
    }
}

