/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.xmldecode;

import com.install4j.runtime.xmldecode.Command;
import com.install4j.runtime.xmldecode.XMLDecoder;
import com.install4j.runtime.xmldecode.sax.Attributes;
import com.install4j.runtime.xmldecode.sax.SAXException;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

public class Handler {
    private Vector result;
    private Vector commands;
    private XMLDecoder decoder;
    private HashMap references;
    private Stack stack;
    private int tabCount;

    public Handler(XMLDecoder xMLDecoder, Vector vector) {
        this.decoder = xMLDecoder;
        this.result = vector;
        this.commands = new Vector();
        this.references = new HashMap();
        this.stack = new Stack();
    }

    public void startDocument() {
        this.references.clear();
        this.tabCount = 0;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Command.printAttrs(this.tabCount, string3, attributes);
        Command command = string3.equals("java") ? new Command(this.decoder, string3, Command.parseAttrs(string3, attributes)) : new Command(string3, Command.parseAttrs(string3, attributes));
        this.stack.push(command);
        ++this.tabCount;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string;
        if (n2 > 0 && (string = String.valueOf(cArray, n, n2)).length() > 0) {
            Command.prn(this.tabCount, this.tabCount + ">setting data=" + string + "<EOL>");
            Command command = (Command)this.stack.peek();
            command.setData(string);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Command command = (Command)this.stack.pop();
        if (!this.stack.isEmpty()) {
            Command command2 = (Command)this.stack.peek();
            command2.addChild(command);
        }
        if (this.stack.size() == 1 && command.isExecutable()) {
            this.commands.add(command);
        }
        if (command.hasAttr("id")) {
            this.references.put(command.getAttr("id"), command);
        }
        try {
            command.exec(this.references);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        if (--this.tabCount < 0) {
            this.tabCount = 0;
        }
        Command.prn(this.tabCount, this.tabCount + ">...<" + string3 + "> end");
    }

    public void endDocument() throws SAXException {
        Command command;
        int n;
        for (n = 0; n < this.commands.size(); ++n) {
            command = (Command)this.commands.elementAt(n);
            try {
                command.backtrack(this.references);
                continue;
            }
            catch (Exception exception) {
                throw new SAXException("Exception in command excution");
            }
        }
        for (n = 0; n < this.commands.size(); ++n) {
            command = (Command)this.commands.elementAt(n);
            this.result.add(command.getResultValue());
        }
    }
}

