/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientPropertyData
extends TransientItemData
implements PropertyData,
ItemData,
Externalizable {
    private static final long serialVersionUID = -8224902483861330191L;
    protected static final int NULL_VALUES = -1;
    protected List<ValueData> values;
    protected int type;
    protected boolean multiValued = false;

    public TransientPropertyData(QPath path, String identifier, int version, int type, String parentIdentifier, boolean multiValued) {
        super(path, identifier, version, parentIdentifier);
        this.type = type;
        this.multiValued = multiValued;
        this.values = null;
    }

    public TransientPropertyData(QPath path, String identifier, int version, int type, String parentIdentifier, boolean multiValued, List<ValueData> values) {
        super(path, identifier, version, parentIdentifier);
        this.type = type;
        this.multiValued = multiValued;
        this.values = values;
    }

    public TransientPropertyData(QPath path, String identifier, int version, int type, String parentIdentifier, boolean multiValued, ValueData value) {
        super(path, identifier, version, parentIdentifier);
        this.type = type;
        this.multiValued = multiValued;
        this.values = new ArrayList<ValueData>();
        this.values.add(value);
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public List<ValueData> getValues() {
        return this.values;
    }

    @Override
    public boolean isMultiValued() {
        return this.multiValued;
    }

    public static TransientPropertyData createPropertyData(NodeData parent, InternalQName name, int type, boolean multiValued) {
        QPath path = QPath.makeChildPath(parent.getQPath(), name);
        TransientPropertyData propData = new TransientPropertyData(path, IdGenerator.generate(), -1, type, parent.getIdentifier(), multiValued);
        return propData;
    }

    public static TransientPropertyData createPropertyData(NodeData parent, InternalQName name, int type, boolean multiValued, ValueData value) {
        QPath path = QPath.makeChildPath(parent.getQPath(), name);
        TransientPropertyData propData = new TransientPropertyData(path, IdGenerator.generate(), -1, type, parent.getIdentifier(), multiValued, value);
        return propData;
    }

    public static TransientPropertyData createPropertyData(NodeData parent, InternalQName name, int type, boolean multiValued, List<ValueData> values) {
        QPath path = QPath.makeChildPath(parent.getQPath(), name);
        TransientPropertyData propData = new TransientPropertyData(path, IdGenerator.generate(), -1, type, parent.getIdentifier(), multiValued, values);
        return propData;
    }

    @Override
    public void accept(ItemDataVisitor visitor) throws RepositoryException {
        visitor.visit(this);
    }

    public TransientPropertyData() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.type);
        out.writeBoolean(this.multiValued);
        if (this.values != null) {
            int listSize = this.values.size();
            out.writeInt(listSize);
            for (int i = 0; i < listSize; ++i) {
                out.writeObject(this.values.get(i));
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.type = in.readInt();
        this.multiValued = in.readBoolean();
        int listSize = in.readInt();
        if (listSize != -1) {
            this.values = new ArrayList<ValueData>();
            for (int i = 0; i < listSize; ++i) {
                this.values.add((ValueData)in.readObject());
            }
        }
    }
}

