/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.net.URL;
import java.security.PrivilegedAction;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;

public class MockConfigurationManagerImpl
extends ConfigurationManagerImpl {
    private String confDir_ = PrivilegedSystemHelper.getProperty((String)"mock.portal.dir") + "/WEB-INF";

    public MockConfigurationManagerImpl(ServletContext context) throws Exception {
        super(context, ExoContainer.getProfiles());
    }

    public URL getURL(String uri) throws Exception {
        if (uri.startsWith("jar:")) {
            final String path = this.removePrefix("jar:/", uri);
            final ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return (URL)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return cl.getResource(path);
                }
            });
        }
        if (uri.startsWith("classpath:")) {
            String path = this.removePrefix("classpath:/", uri);
            return PrivilegedSystemHelper.getResource((String)path);
        }
        if (uri.startsWith("war:")) {
            String path = this.removePrefix("war:", uri);
            URL url = new URL("file:" + this.confDir_ + path);
            return url;
        }
        if (uri.startsWith("file:")) {
            return new URL(uri);
        }
        return null;
    }
}

