/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.PasswordEncrypter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestPasswordEncrypter
implements PasswordEncrypter {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.security.DigestPasswordEncrypter");
    private final int HASH_HEX_LENGTH = 32;
    private final Map<String, String> context;
    private final String username;

    public DigestPasswordEncrypter(String username, Map<String, String> context) {
        this.context = context;
        this.username = username;
    }

    private String convertToHex(byte[] bin) {
        StringBuffer tmpStr = new StringBuffer(32);
        for (int i = 0; i < 16; ++i) {
            int digit = bin[i] >> 4 & 0xF;
            tmpStr.append(Integer.toHexString(digit));
            digit = bin[i] & 0xF;
            tmpStr.append(Integer.toHexString(digit));
        }
        return tmpStr.toString();
    }

    @Override
    public byte[] encrypt(byte[] plainPassword) {
        MessageDigest md;
        String method;
        String entity;
        String cnonce;
        String realm;
        String nonce;
        String qop;
        String uri;
        String a2;
        String nc;
        block8: {
            nc = this.context.get("nc");
            a2 = this.context.get("md5a2");
            uri = this.context.get("uri");
            qop = this.context.get("qop");
            nonce = this.context.get("nonce");
            realm = this.context.get("realmName");
            cnonce = this.context.get("cnonce");
            entity = this.context.get("entity");
            method = this.context.get("method");
            if (realm == null) {
                realm = this.context.get("realm");
            }
            if (a2 == null) {
                a2 = this.context.get("a2hash");
            }
            md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                if (!LOG.isTraceEnabled()) break block8;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        String a1 = this.username + ":" + realm + ":" + new String(plainPassword);
        md.update(a1.getBytes());
        a1 = this.convertToHex(md.digest());
        if (a2 == null) {
            if (qop.equals("auth")) {
                md.update((method + ":" + uri).getBytes());
                a2 = this.convertToHex(md.digest());
            } else if (qop.equals("auth-int")) {
                md.update((method + ":" + uri + ":" + this.convertToHex(entity.getBytes())).getBytes());
                a2 = this.convertToHex(md.digest());
            }
        }
        String digest = a1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + a2;
        md.update(digest.getBytes());
        return this.convertToHex(md.digest()).getBytes();
    }
}

