/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.beans.screens.componentselection.ComponentTree;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ComponentsScreen
extends SystemScreen {
    private ComponentTree tree;
    private JScrollPane scpTree;
    private boolean boldDescription = true;
    private boolean italicDescription = false;
    private boolean smallerDescription = false;
    private String defaultConsoleSelection;
    private Map indexToComponentNodeConfig = new HashMap();

    public boolean isBoldDescription() {
        return this.boldDescription;
    }

    public void setBoldDescription(boolean bl) {
        this.boldDescription = bl;
    }

    public boolean isItalicDescription() {
        return this.italicDescription;
    }

    public void setItalicDescription(boolean bl) {
        this.italicDescription = bl;
    }

    public boolean isSmallerDescription() {
        return this.smallerDescription;
    }

    public void setSmallerDescription(boolean bl) {
        this.smallerDescription = bl;
    }

    public boolean isHidden() {
        return InstallerConfig.getCurrentInstance().getComponents().size() == 0;
    }

    public String getTitle() {
        return this.getMessage("WizardSelectComponents");
    }

    public String getSubTitle() {
        return this.getMessage("SelectComponentsDesc");
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        console.println(this.getMessage("SelectComponentsDesc"));
        ComponentFolderConfig componentFolderConfig = InstallerConfig.getCurrentInstance().getComponentRoot();
        this.printFolder(console, componentFolderConfig, 1, "");
        while (true) {
            String string = console.askString(null, this.defaultConsoleSelection);
            HashSet hashSet = new HashSet();
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    int n = Integer.parseInt(string2);
                    Object v = this.indexToComponentNodeConfig.get(new Integer(n));
                    if (v == null) {
                        throw new NumberFormatException("not available");
                    }
                    hashSet.add(v);
                }
                componentFolderConfig.setSelected(false);
                this.updateTree(hashSet, componentFolderConfig);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    private void updateTree(Set set, ComponentFolderConfig componentFolderConfig) {
        for (int i = 0; i < componentFolderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig componentNodeConfig;
            componentNodeConfig.setSelected(set.contains(componentNodeConfig = (ComponentNodeConfig)componentFolderConfig.getComponents().get(i)) || componentFolderConfig.isIncluded());
            if (!(componentNodeConfig instanceof ComponentFolderConfig)) continue;
            this.updateTree(set, (ComponentFolderConfig)componentNodeConfig);
        }
    }

    private int printFolder(Console console, ComponentFolderConfig componentFolderConfig, int n, String string) {
        for (int i = 0; i < componentFolderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig componentNodeConfig = (ComponentNodeConfig)componentFolderConfig.getComponents().get(i);
            this.printNode(n++, componentNodeConfig, console, string);
            if (!(componentNodeConfig instanceof ComponentFolderConfig)) continue;
            n = this.printFolder(console, (ComponentFolderConfig)componentNodeConfig, n, string + "      ");
        }
        return n;
    }

    private void printNode(int n, ComponentNodeConfig componentNodeConfig, Console console, String string) {
        this.indexToComponentNodeConfig.put(new Integer(n), componentNodeConfig);
        console.println(string + n + ": " + componentNodeConfig.getName());
        if (componentNodeConfig.isSelected()) {
            this.defaultConsoleSelection = this.defaultConsoleSelection == null ? "" : this.defaultConsoleSelection + ",";
            this.defaultConsoleSelection = this.defaultConsoleSelection + n;
        }
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(MessageFormat.format(this.getMessage("SelectComponentsLabel2"), this.getApplicationName()), jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.scpTree, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    protected void setupControls() {
        super.setupControls();
        this.tree = new ComponentTree(this);
        this.scpTree = new JScrollPane(this.tree);
    }
}

