/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class HibernateEntityResolver
implements EntityResolver,
Serializable {
    private static final String URL = "http://hibernate.sourceforge.net/";
    private transient ClassLoader resourceLoader;

    public HibernateEntityResolver() {
        this.resourceLoader = this.getClass().getClassLoader();
    }

    public HibernateEntityResolver(ClassLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null && systemId.startsWith(URL)) {
            InputStream dtdStream = this.resourceLoader.getResourceAsStream("org/hibernate/" + systemId.substring(URL.length()));
            if (dtdStream == null) {
                return null;
            }
            InputSource source = new InputSource(dtdStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        return null;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.resourceLoader = this.getClass().getClassLoader();
    }
}

