/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormDateTimeInput
extends UIFormInputBase<String> {
    private DateFormat dateFormat_;
    private boolean isDisplayTime_;
    private String datePattern_;
    private String[] months_;

    public UIFormDateTimeInput(String name, String bindField, Date date, boolean isDisplayTime) {
        super(name, bindField, String.class);
        this.setDisplayTime(isDisplayTime);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.formatPattern(requestContext.getLocale());
        this.setDate(date);
    }

    public UIFormDateTimeInput(String name, String bindField, Date date) {
        this(name, bindField, date, true);
    }

    public void setDisplayTime(boolean isDisplayTime) {
        this.isDisplayTime_ = isDisplayTime;
    }

    public void setCalendar(Calendar calendar) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.formatPattern(requestContext.getLocale());
        Date date = null;
        if (calendar != null) {
            date = calendar.getTime();
        }
        this.setDate(date);
    }

    private void setDate(Date date) {
        this.value_ = date != null ? this.dateFormat_.format(date) : null;
    }

    public Calendar getCalendar() {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.dateFormat_.parse((String)this.value_ + " 0:0:0"));
            return calendar;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private void setDatePattern_(String datePattern_) {
        this.datePattern_ = datePattern_;
    }

    public String getDatePattern_() {
        return this.datePattern_;
    }

    private void formatPattern(Locale locale) {
        this.dateFormat_ = this.isDisplayTime_ ? SimpleDateFormat.getDateTimeInstance(3, 2, locale) : SimpleDateFormat.getDateInstance(3, locale);
        this.setDatePattern_(((SimpleDateFormat)this.dateFormat_).toPattern());
        if (!this.getDatePattern_().contains("yy")) {
            this.setDatePattern_(this.getDatePattern_().replaceAll("y", "yy"));
        }
        if (!this.getDatePattern_().contains("yyyy")) {
            this.setDatePattern_(this.getDatePattern_().replaceAll("yy", "yyyy"));
        }
        if (!this.getDatePattern_().contains("dd")) {
            this.setDatePattern_(this.getDatePattern_().replaceAll("d", "dd"));
        }
        if (!this.getDatePattern_().contains("MM")) {
            this.setDatePattern_(this.getDatePattern_().replaceAll("M", "MM"));
        }
        this.setDatePattern_(this.getDatePattern_().replaceAll("h", "H"));
        if (!this.getDatePattern_().contains("HH")) {
            this.setDatePattern_(this.getDatePattern_().replaceAll("H", "HH"));
        }
        if (this.getDatePattern_().contains("a")) {
            this.setDatePattern_(this.getDatePattern_().replaceAll("a", ""));
        }
        this.dateFormat_ = new SimpleDateFormat(this.getDatePattern_());
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        this.months_ = symbols.getMonths();
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (input != null) {
            this.value_ = ((String)input).trim();
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.formatPattern(requestContext.getLocale());
        String monthNames_ = "";
        for (String month : this.months_) {
            if (month.equals("")) continue;
            monthNames_ = monthNames_ + month + ",";
        }
        String value = (String)this.getValue();
        value = value != null && value.length() > 0 ? HTMLEntityEncoder.getInstance().encodeHTMLAttribute(value) : "";
        JavascriptManager jsManager = context.getJavascriptManager();
        jsManager.importJavascript((CharSequence)"eXo.webui.UICalendar");
        jsManager.addJavascript((CharSequence)("eXo.webui.UICalendar.setFirstDayOfWeek(" + Calendar.getInstance(context.getLocale()).getFirstDayOfWeek() + ");"));
        Writer w = context.getWriter();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("type", "text");
        attributes.put("name", this.name);
        attributes.put("value", value);
        if (this.isReadOnly()) {
            attributes.put("readonly", "readonly");
        }
        String onFocus = "eXo.webui.UICalendar.init(this," + String.valueOf(this.isDisplayTime_) + ",'" + this.getDatePattern_() + "','" + value + "','" + monthNames_ + "');";
        String onKeyUp = "eXo.webui.UICalendar.show();";
        String onKeyDown = "eXo.webui.UICalendar.onTabOut(event)";
        String onClick = "event.cancelBubble = true";
        attributes.put("onfocus", onFocus);
        attributes.put("onkeyup", onKeyUp);
        attributes.put("onkeydown", onKeyDown);
        attributes.put("onclick", onClick);
        this.renderInputBaseComponent(w, "input", attributes);
    }
}

