function NumberFormatTest(A){TestCase.call(this,A)
}NumberFormatTest.inherits(TestCase);
var NumberFormatConstants_en={DECIMAL_SEP:".",GROUP_SEP:",",PERCENT:"%",ZERO_DIGIT:"0",PLUS_SIGN:"+",MINUS_SIGN:"-",EXP_SYMBOL:"E",PERMILL:"\u2030",INFINITY:"\u221E",NAN:"NaN",MONETARY_SEP:".",MONETARY_GROUP_SEP:",",DECIMAL_PATTERN:"#,##0.###",SCIENTIFIC_PATTERN:"#E0",PERCENT_PATTERN:"#,##0%",CURRENCY_PATTERN:"\u00A4#,##0.00",DEF_CURRENCY_CODE:"USD"};
NumberFormatTest.prototype.setUp=function(){gadgets.i18n.numFormatter_=new gadgets.i18n.NumberFormat(NumberFormatConstants_en)
};
NumberFormatTest.prototype.testStandardFormat=function(){var A;
A=gadgets.i18n.formatNumber(gadgets.i18n.CURRENCY_PATTERN,1234.579);
this.assertEquals("$1,234.58",A);
A=gadgets.i18n.formatNumber(gadgets.i18n.DECIMAL_PATTERN,1234.579);
this.assertEquals("1,234.579",A);
A=gadgets.i18n.formatNumber(gadgets.i18n.PERCENT_PATTERN,1234.579);
this.assertEquals("123,458%",A);
A=gadgets.i18n.formatNumber(gadgets.i18n.SCIENTIFIC_PATTERN,1234.579);
this.assertEquals("1E3",A)
};
NumberFormatTest.prototype.testBasicParse=function(){var A;
A=gadgets.i18n.parseNumber("0.0000","123.4579");
this.assertEquals(123.4579,A);
A=gadgets.i18n.parseNumber("0.0000","+123.4579");
this.assertEquals(123.4579,A);
A=gadgets.i18n.parseNumber("0.0000","-123.4579");
this.assertEquals(-123.4579,A)
};
NumberFormatTest.prototype.testPrefixParse=function(){var A;
A=gadgets.i18n.parseNumber("0.0;(0.0)","123.4579");
this.assertEquals(123.4579,A);
A=gadgets.i18n.parseNumber("0.0;(0.0)","(123.4579)");
this.assertEquals(-123.4579,A)
};
NumberFormatTest.prototype.testPrecentParse=function(){var A;
A=gadgets.i18n.parseNumber("0.0;(0.0)","123.4579%");
this.assertEquals((123.4579/100),A);
A=gadgets.i18n.parseNumber("0.0;(0.0)","(%123.4579)");
this.assertEquals((-123.4579/100),A);
A=gadgets.i18n.parseNumber("0.0;(0.0)","123.4579\u2030");
this.assertEquals((123.4579/1000),A);
A=gadgets.i18n.parseNumber("0.0;(0.0)","(\u2030123.4579)");
this.assertEquals((-123.4579/1000),A)
};
NumberFormatTest.prototype.testPercentAndPerMillAdvance=function(){var A;
var B=[0];
A=gadgets.i18n.parseNumber("0","120%",B);
this.assertEquals(1.2,A);
this.assertEquals(4,B[0]);
B[0]=0;
A=gadgets.i18n.parseNumber("0","120\u2030",B);
this.assertEquals(0.12,A);
this.assertEquals(4,B[0])
};
NumberFormatTest.prototype.testInfinityParse=function(){var A;
A=gadgets.i18n.parseNumber("0.0;(0.0)","\u221e");
this.assertEquals(Number.POSITIVE_INFINITY,A);
A=gadgets.i18n.parseNumber("0.0;(0.0)","(\u221e)");
this.assertEquals(Number.NEGATIVE_INFINITY,A)
};
NumberFormatTest.prototype.testExponentParse=function(){var A;
A=gadgets.i18n.parseNumber("#E0","1.234E3");
this.assertEquals(1234,A);
A=gadgets.i18n.parseNumber("0.###E0","1.234E3");
this.assertEquals(1234,A);
A=gadgets.i18n.parseNumber("#E0","1.2345E4");
this.assertEquals(12345,A);
A=gadgets.i18n.parseNumber("0E0","1.2345E4");
this.assertEquals(12345,A);
A=gadgets.i18n.parseNumber("0E0","1.2345E+4");
this.assertEquals(12345,A)
};
NumberFormatTest.prototype.testGroupingParse=function(){var A;
A=gadgets.i18n.parseNumber("#,###","1,234,567,890");
this.assertEquals(1234567890,A);
A=gadgets.i18n.parseNumber("#,####","12,3456,7890");
this.assertEquals(1234567890,A);
A=gadgets.i18n.parseNumber("#","1234567890");
this.assertEquals(1234567890,A)
};
NumberFormatTest.prototype.testBasicFormat=function(){var A=gadgets.i18n.formatNumber("0.0000",123.45789179565757);
this.assertEquals("123.4579",A)
};
NumberFormatTest.prototype.testGrouping=function(){var A;
A=gadgets.i18n.formatNumber("#,###",1234567890);
this.assertEquals("1,234,567,890",A);
A=gadgets.i18n.formatNumber("#,####",1234567890);
this.assertEquals("12,3456,7890",A);
A=gadgets.i18n.formatNumber("#",1234567890);
this.assertEquals("1234567890",A)
};
NumberFormatTest.prototype.testPerMill=function(){var A;
A=gadgets.i18n.formatNumber("###.###\u2030",0.4857);
this.assertEquals("485.7\u2030",A)
};
NumberFormatTest.prototype.testCurrency=function(){var A;
A=gadgets.i18n.formatNumber("\u00a4#,##0.00;-\u00a4#,##0.00",1234.56);
this.assertEquals("$1,234.56",A);
A=gadgets.i18n.formatNumber("\u00a4#,##0.00;-\u00a4#,##0.00",-1234.56);
this.assertEquals("-$1,234.56",A);
A=gadgets.i18n.formatNumber("\u00a4\u00a4 #,##0.00;-\u00a4\u00a4 #,##0.00",1234.56);
this.assertEquals("USD 1,234.56",A);
A=gadgets.i18n.formatNumber("\u00a4\u00a4 #,##0.00;\u00a4\u00a4 -#,##0.00",-1234.56);
this.assertEquals("USD -1,234.56",A);
A=gadgets.i18n.formatNumber("\u00a4#,##0.00;-\u00a4#,##0.00",1234.56,"BRL");
this.assertEquals("R$1,234.56",A);
A=gadgets.i18n.formatNumber("\u00a4#,##0.00;-\u00a4#,##0.00",-1234.56,"BRL");
this.assertEquals("-R$1,234.56",A);
A=gadgets.i18n.formatNumber("\u00a4\u00a4 #,##0.00;(\u00a4\u00a4 #,##0.00)",1234.56,"BRL");
this.assertEquals("BRL 1,234.56",A);
A=gadgets.i18n.formatNumber("\u00a4\u00a4 #,##0.00;(\u00a4\u00a4 #,##0.00)",-1234.56,"BRL");
this.assertEquals("(BRL 1,234.56)",A)
};
NumberFormatTest.prototype.testQuotes=function(){var A;
A=gadgets.i18n.formatNumber("a'fo''o'b#",123);
this.assertEquals("afo'ob123",A);
A=gadgets.i18n.formatNumber("a''b#",123);
this.assertEquals("a'b123",A)
};
NumberFormatTest.prototype.testZeros=function(){var A;
A=gadgets.i18n.formatNumber("#.#",0);
this.assertEquals("0",A);
A=gadgets.i18n.formatNumber("#.",0);
this.assertEquals("0.",A);
A=gadgets.i18n.formatNumber(".#",0);
this.assertEquals(".0",A);
A=gadgets.i18n.formatNumber("#",0);
this.assertEquals("0",A);
A=gadgets.i18n.formatNumber("#0.#",0);
this.assertEquals("0",A);
A=gadgets.i18n.formatNumber("#0.",0);
this.assertEquals("0.",A);
A=gadgets.i18n.formatNumber("#.0",0);
this.assertEquals(".0",A);
A=gadgets.i18n.formatNumber("#",0);
this.assertEquals("0",A);
A=gadgets.i18n.formatNumber("000",0);
this.assertEquals("000",A)
};
NumberFormatTest.prototype.testExponential=function(){var A;
A=gadgets.i18n.formatNumber("0.####E0",0.01234);
this.assertEquals("1.234E-2",A);
A=gadgets.i18n.formatNumber("00.000E00",0.01234);
this.assertEquals("12.340E-03",A);
A=gadgets.i18n.formatNumber("##0.######E000",0.01234);
this.assertEquals("12.34E-003",A);
A=gadgets.i18n.formatNumber("0.###E0;[0.###E0]",0.01234);
this.assertEquals("1.234E-2",A);
A=gadgets.i18n.formatNumber("0.####E0",123456789);
this.assertEquals("1.2346E8",A);
A=gadgets.i18n.formatNumber("00.000E00",123456789);
this.assertEquals("12.346E07",A);
A=gadgets.i18n.formatNumber("##0.######E000",123456789);
this.assertEquals("123.456789E006",A);
A=gadgets.i18n.formatNumber("0.###E0;[0.###E0]",123456789);
this.assertEquals("1.235E8",A);
A=gadgets.i18n.formatNumber("0.####E0",1.23e+300);
this.assertEquals("1.23E300",A);
A=gadgets.i18n.formatNumber("00.000E00",1.23e+300);
this.assertEquals("12.300E299",A);
A=gadgets.i18n.formatNumber("##0.######E000",1.23e+300);
this.assertEquals("1.23E300",A);
A=gadgets.i18n.formatNumber("0.###E0;[0.###E0]",1.23e+300);
this.assertEquals("1.23E300",A);
A=gadgets.i18n.formatNumber("0.####E0",-3.141592653e-271);
this.assertEquals("-3.1416E-271",A);
A=gadgets.i18n.formatNumber("00.000E00",-3.141592653e-271);
this.assertEquals("-31.416E-272",A);
A=gadgets.i18n.formatNumber("##0.######E000",-3.141592653e-271);
this.assertEquals("-314.159265E-273",A);
A=gadgets.i18n.formatNumber("0.###E0;[0.###E0]",-3.141592653e-271);
this.assertEquals("[3.142E-271]",A);
A=gadgets.i18n.formatNumber("0.####E0",0);
this.assertEquals("0E0",A);
A=gadgets.i18n.formatNumber("00.000E00",0);
this.assertEquals("00.000E00",A);
A=gadgets.i18n.formatNumber("##0.######E000",0);
this.assertEquals("0E000",A);
A=gadgets.i18n.formatNumber("0.###E0;[0.###E0]",0);
this.assertEquals("0E0",A);
A=gadgets.i18n.formatNumber("0.####E0",-1);
this.assertEquals("-1E0",A);
A=gadgets.i18n.formatNumber("00.000E00",-1);
this.assertEquals("-10.000E-01",A);
A=gadgets.i18n.formatNumber("##0.######E000",-1);
this.assertEquals("-1E000",A);
A=gadgets.i18n.formatNumber("0.###E0;[0.###E0]",-1);
this.assertEquals("[1E0]",A);
A=gadgets.i18n.formatNumber("0.####E0",1);
this.assertEquals("1E0",A);
A=gadgets.i18n.formatNumber("00.000E00",1);
this.assertEquals("10.000E-01",A);
A=gadgets.i18n.formatNumber("##0.######E000",1);
this.assertEquals("1E000",A);
A=gadgets.i18n.formatNumber("0.###E0;[0.###E0]",1);
this.assertEquals("1E0",A);
A=gadgets.i18n.formatNumber("#E0",12345);
this.assertEquals("1E4",A);
A=gadgets.i18n.formatNumber("0E0",12345);
this.assertEquals("1E4",A);
A=gadgets.i18n.formatNumber("##0.###E0",12345);
this.assertEquals("12.345E3",A);
A=gadgets.i18n.formatNumber("##0.###E0",12345.00001);
this.assertEquals("12.345E3",A);
A=gadgets.i18n.formatNumber("##0.###E0",12345);
this.assertEquals("12.345E3",A);
A=gadgets.i18n.formatNumber("##0.####E0",7.8912345e-7);
this.assertEquals("789.1235E-9",A);
A=gadgets.i18n.formatNumber("##0.####E0",7.8e-7);
this.assertEquals("780E-9",A);
A=gadgets.i18n.formatNumber(".###E0",45678);
this.assertEquals(".457E5",A);
A=gadgets.i18n.formatNumber(".###E0",0);
this.assertEquals(".0E0",A);
A=gadgets.i18n.formatNumber("#E0",45678000);
this.assertEquals("5E7",A);
A=gadgets.i18n.formatNumber("##E0",45678000);
this.assertEquals("46E6",A);
A=gadgets.i18n.formatNumber("####E0",45678000);
this.assertEquals("4568E4",A);
A=gadgets.i18n.formatNumber("0E0",45678000);
this.assertEquals("5E7",A);
A=gadgets.i18n.formatNumber("00E0",45678000);
this.assertEquals("46E6",A);
A=gadgets.i18n.formatNumber("000E0",45678000);
this.assertEquals("457E5",A);
A=gadgets.i18n.formatNumber("###E0",0.0000123);
this.assertEquals("12E-6",A);
A=gadgets.i18n.formatNumber("###E0",0.000123);
this.assertEquals("123E-6",A);
A=gadgets.i18n.formatNumber("###E0",0.00123);
this.assertEquals("1E-3",A);
A=gadgets.i18n.formatNumber("###E0",0.0123);
this.assertEquals("12E-3",A);
A=gadgets.i18n.formatNumber("###E0",0.123);
this.assertEquals("123E-3",A);
A=gadgets.i18n.formatNumber("###E0",1.23);
this.assertEquals("1E0",A);
A=gadgets.i18n.formatNumber("###E0",12.3);
this.assertEquals("12E0",A);
A=gadgets.i18n.formatNumber("###E0",123);
this.assertEquals("123E0",A);
A=gadgets.i18n.formatNumber("###E0",1230);
this.assertEquals("1E3",A)
};
NumberFormatTest.prototype.testGroupingParse2=function(){var A;
A=gadgets.i18n.parseNumber("#,###","1,234,567,890");
this.assertEquals(1234567890,A);
A=gadgets.i18n.parseNumber("#,####","12,3456,7890");
this.assertEquals(1234567890,A);
A=gadgets.i18n.parseNumber("#","1234567890");
this.assertEquals(1234567890,A)
};
NumberFormatTest.prototype.testApis=function(){var A;
A=gadgets.i18n.formatNumber("#,###",1234567890);
this.assertEquals("1,234,567,890",A);
A=gadgets.i18n.formatNumber("\u00a4#,##0.00;-\u00a4#,##0.00",1234.56);
this.assertEquals("$1,234.56",A);
A=gadgets.i18n.formatNumber("\u00a4#,##0.00;(\u00a4#,##0.00)",-1234.56);
this.assertEquals("($1,234.56)",A);
A=gadgets.i18n.formatNumber("\u00a4#,##0.00;-\u00a4#,##0.00",1234.56,"SEK");
this.assertEquals("kr1,234.56",A);
A=gadgets.i18n.formatNumber("\u00a4#,##0.00;(\u00a4#,##0.00)",-1234.56,"SEK");
this.assertEquals("(kr1,234.56)",A)
};