/*
 * Decompiled with CFR 0.152.
 */
package tool.org.exoplatform.cs.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.picocontainer.Startable;
import tool.org.exoplatform.cs.CalendarUpdateStoragePlugin;
import tool.org.exoplatform.cs.CsNodeTypeMapping;
import tool.org.exoplatform.cs.CsObjectParam;
import tool.org.exoplatform.cs.CsPropertyMapping;
import tool.org.exoplatform.cs.MailUpdateStoragePlugin;
import tool.org.exoplatform.cs.MigrationService;
import tool.org.exoplatform.cs.UpdateStorageEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationServiceImpl
implements MigrationService,
Startable {
    public static final String DUMP_DATA = "dump-data";
    public static final String REMOVE_DATA = "remove-data";
    public static final String REMOVE_NT = "remove-nodetypes";
    public static final String REMOVE_NT2 = "remove-nodetypes2";
    public static final String IMPORT_DATA = "import-data";
    public static final String ARRANGE_DATA = "arrange-data";
    public static final String REGISTER_NT = "register-nodetypes";
    public static final String IMPORT_BACKUP = "import-backup";
    private Session _session;
    private RepositoryService _repoService;
    private InitParams _params;
    public CsObjectParam mailCsObj_;
    public CsObjectParam calendarCsObj_;
    public CsObjectParam contactCsObj_;
    public List<UpdateStorageEventListener> listeners_ = new ArrayList<UpdateStorageEventListener>();

    public MigrationServiceImpl(InitParams params, RepositoryService service) {
        this._repoService = service;
        this._params = params;
    }

    @Override
    public synchronized void addListenerPlugin(ComponentPlugin listener) throws Exception {
        if (listener instanceof UpdateStorageEventListener) {
            this.listeners_.add((UpdateStorageEventListener)listener);
        }
    }

    public void initUpdatedData() {
        for (UpdateStorageEventListener updateListener : this.listeners_) {
            if (updateListener instanceof MailUpdateStoragePlugin) {
                MailUpdateStoragePlugin mailPlugin = (MailUpdateStoragePlugin)updateListener;
                this.mailCsObj_ = mailPlugin.getCsObjectParam();
                continue;
            }
            if (!(updateListener instanceof CalendarUpdateStoragePlugin)) continue;
            CalendarUpdateStoragePlugin calendarPlugin = (CalendarUpdateStoragePlugin)updateListener;
            this.calendarCsObj_ = calendarPlugin.getCsObjectParam();
        }
    }

    public List<CsNodeTypeMapping> getMailCsNoteTypeMapping() {
        return this.mailCsObj_.getNodeTypes();
    }

    public List<CsNodeTypeMapping> getCalendarCsNoteTypeMapping() {
        return this.calendarCsObj_.getNodeTypes();
    }

    public List<CsPropertyMapping> getAddedProperty(CsNodeTypeMapping nt) {
        return nt.getAddedProperties();
    }

    public List<CsPropertyMapping> getUpdatedProperty(CsNodeTypeMapping nt) {
        return nt.getUpdatedProperties();
    }

    public List<CsPropertyMapping> getRemovedProperty(CsNodeTypeMapping nt) {
        return nt.getRemovedProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        System.out.println("######### Start MigrationService #########");
        this.initUpdatedData();
        try {
            this.initService();
            if (this._params.containsKey((Object)IMPORT_BACKUP)) {
                this.importData(this._params.getValueParam(IMPORT_BACKUP).getValue().trim());
            }
            if (this._params.containsKey((Object)DUMP_DATA)) {
                this.dumpData(this._params.getValueParam(DUMP_DATA).getValue().trim());
            }
            if (this._params.containsKey((Object)REMOVE_DATA)) {
                this.removeData();
            }
            if (this._params.containsKey((Object)REMOVE_NT)) {
                this.removeNT();
            }
            if (this._params.containsKey((Object)REGISTER_NT)) {
                this.registerNodeTypes(this._params.getValueParam(REGISTER_NT).getValue().trim());
            }
            if (this._params.containsKey((Object)IMPORT_DATA)) {
                this.importData(this._params.getValueParam(IMPORT_DATA).getValue().trim());
            }
            if (this._params.containsKey((Object)ARRANGE_DATA)) {
                this.arrangeData();
            }
            if (this._params.containsKey((Object)REMOVE_NT2)) {
                this.removeNT2();
            }
        }
        catch (Exception e) {
            System.out.println("Migration was interrupted due to this unexpected condition:");
            e.printStackTrace();
        }
        finally {
            if (this._session != null) {
                this._session.logout();
            }
            System.out.println("######### End MigrationService #########");
        }
    }

    private void importData(String exportPath) throws Exception {
        System.out.println("######### Begin import data #########");
        Node rootNode = this._session.getRootNode();
        this.importNode(exportPath, rootNode, "exo:applications");
        this.importNode(exportPath, rootNode, "Users");
        System.out.println("######### End import data #########");
    }

    public void stop() {
        if (this._session.isLive()) {
            this._session.logout();
        }
        System.out.println("JCR session logged out.");
    }

    @Override
    public void initService() throws Exception {
        System.out.println("Initializing service...");
        String workspace = "collaboration";
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this._session = sessionProvider.getSession(workspace, this._repoService.getDefaultRepository());
        System.out.println("JCR session initialized on workspace " + workspace);
    }

    public void dumpData(String exportPath) throws Exception {
        System.out.println("######### Begin dump data #########");
        Node rootNode = this._session.getRootNode();
        if (rootNode.hasNode("exo:applications")) {
            this.exportNode(exportPath, rootNode.getNode("exo:applications"));
        }
        if (rootNode.hasNode("Users")) {
            this.exportNode(exportPath, rootNode.getNode("Users"));
        }
        System.out.println("######### End dump data #########");
    }

    public void removeData() throws Exception {
        System.out.println("######### Begin remove data #########");
        this.removeNode("/exo:applications");
        this.removeNode("/Users");
        System.out.println("######### End remove data #########");
    }

    public void removeNT() throws Exception {
        System.out.println("######### Begin remove nodetypes #########");
        for (CsNodeTypeMapping nt : this.getMailCsNoteTypeMapping()) {
            this.removeNodeType(nt.getNodeTypeName());
        }
        for (CsNodeTypeMapping nt : this.getCalendarCsNoteTypeMapping()) {
            this.removeNodeType(nt.getNodeTypeName());
        }
        System.out.println("######### End remove nodetypes #########");
    }

    public void removeNT2() throws Exception {
        System.out.println("######### Begin remove modified nodetypes #########");
        this.removeNodeType("exo:forumAttachment");
        this.removeNodeType("exo:post");
        this.removeNodeType("exo:topic");
        this.removeNodeType("exo:forum");
        this.removeNodeType("exo:forumCategory");
        this.removeNodeType("exo:userProfile");
        this.removeNodeType("exo:forumStatistic");
        this.removeNodeType("exo:administration");
        this.removeNodeType("exo:forumWatching");
        System.out.println("######### End remove modified nodetypes #########");
    }

    public void arrangeData() throws Exception {
        System.out.println("######### Begin arrange nodes #########");
        for (CsNodeTypeMapping nt : this.getMailCsNoteTypeMapping()) {
            this.fixNodeType(nt);
        }
        for (CsNodeTypeMapping nt : this.getCalendarCsNoteTypeMapping()) {
            this.fixNodeType(nt);
        }
        System.out.println("######### End arrange nodes #########");
    }

    private void fixNodeType(CsNodeTypeMapping nt) throws Exception {
        System.out.println(">>>>>> Start " + nt.getNodeTypeName() + " upgrade");
        this.traverseNodes("select * from " + nt.getNodeTypeName() + " ", new NodeVisitor(){

            public void visitNode(Node node) throws Exception {
                List<CsNodeTypeMapping> modifiedNodeType = MigrationServiceImpl.this.getMailCsNoteTypeMapping();
                modifiedNodeType.addAll(MigrationServiceImpl.this.getCalendarCsNoteTypeMapping());
                for (CsNodeTypeMapping nt : modifiedNodeType) {
                    for (CsPropertyMapping prop : MigrationServiceImpl.this.getAddedProperty(nt)) {
                        try {
                            if (prop.getDefaultValue().trim().equalsIgnoreCase("boolean")) {
                                MigrationServiceImpl.this.setPropertyIfAbsent(node, prop.getPropertyName(), Boolean.valueOf(prop.getDefaultValue()));
                                continue;
                            }
                            if (prop.getDefaultValue().trim().equalsIgnoreCase("string")) {
                                MigrationServiceImpl.this.setPropertyIfAbsent(node, prop.getPropertyName(), prop.getDefaultValue());
                                continue;
                            }
                            if (!prop.getDefaultValue().trim().equalsIgnoreCase("long")) continue;
                            MigrationServiceImpl.this.setPropertyIfAbsent(node, prop.getPropertyName(), Long.valueOf(prop.getDefaultValue()));
                        }
                        catch (Exception e) {
                            System.out.println("Failed to upgrade forum category: " + node.getPath() + ": " + e.getMessage());
                        }
                    }
                    for (CsPropertyMapping prop : MigrationServiceImpl.this.getRemovedProperty(nt)) {
                        try {
                            MigrationServiceImpl.this.deleteProperty(node, prop.getPropertyName());
                        }
                        catch (Exception e) {
                            System.out.println("Failed to upgrade forum category: " + node.getPath() + ": " + e.getMessage());
                        }
                    }
                    for (CsPropertyMapping prop : MigrationServiceImpl.this.getUpdatedProperty(nt)) {
                        try {
                            MigrationServiceImpl.this.copyStringProperty(node, prop.getPropertyName(), prop.getReplaceName());
                        }
                        catch (Exception e) {
                            System.out.println("Failed to upgrade " + nt.getNodeTypeName() + " : " + node.getPath() + ": " + e.getMessage());
                        }
                    }
                }
            }
        });
        System.out.println("<<<<<< End " + nt.getNodeTypeName() + " upgrade");
    }

    private void setPropertyIfAbsent(Node node, String propertyName, long value) throws Exception {
        if (!node.hasProperty(propertyName)) {
            node.setProperty(propertyName, value);
            System.out.println("Set " + propertyName + "=" + value + " on " + node.getPath());
        }
    }

    private void setPropertyIfAbsent(Node node, String propertyName, String value) throws Exception {
        if (!node.hasProperty(propertyName)) {
            node.setProperty(propertyName, value);
            System.out.println("Set " + propertyName + "=" + value + " on " + node.getPath());
        }
    }

    private void setPropertyIfAbsent(Node node, String propertyName, Boolean value) throws Exception {
        if (!node.hasProperty(propertyName)) {
            node.setProperty(propertyName, value.booleanValue());
            System.out.println("Set " + propertyName + "=" + value + " on " + node.getPath());
        }
    }

    private void importNode(String dataFolderPath, Node rootNode, String nodeName) throws Exception {
        if (rootNode.hasNode(nodeName)) {
            System.out.println("Found an existing node " + nodeName + ". Removing before import.");
            rootNode.getNode(nodeName).remove();
            this._session.save();
        }
        String filePath = this.getDumpFilename(dataFolderPath, nodeName);
        File f = new File(filePath);
        System.out.println("Importing " + nodeName + " from " + filePath);
        if (!f.exists()) {
            throw new IllegalStateException("File to import does not exist : " + filePath);
        }
        FileInputStream is = new FileInputStream(f);
        String parentPath = rootNode.getPath();
        this._session.importXML(parentPath, (InputStream)is, 0);
        System.out.println(nodeName + " imported successfully.");
    }

    private void exportNode(String exportPath, Node node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("Could node export a null node");
        }
        String nodeName = node.getName();
        System.out.println("Exporting " + nodeName + "...");
        String exportFile = this.getDumpFilename(exportPath, nodeName);
        File f = new File(exportFile);
        if (!f.createNewFile()) {
            throw new IllegalStateException("File " + exportFile + " already exists.");
        }
        FileOutputStream os = new FileOutputStream(f);
        this._session.exportSystemView(node.getPath(), (OutputStream)os, false, false);
        System.out.println("Exported " + nodeName + " to " + exportFile);
    }

    private String getDumpFilename(String exportPath, String nodeName) {
        String normalized = nodeName;
        if (nodeName.lastIndexOf(":") > 0) {
            normalized = nodeName.substring(nodeName.lastIndexOf(":") + 1);
        }
        return exportPath + "/" + normalized + "-sysview.xml";
    }

    private void removeNode(String absNodePath) throws Exception {
        if (!absNodePath.startsWith("/")) {
            throw new IllegalArgumentException(absNodePath + " is not an absolute path. Add leading '/'");
        }
        String nodeName = absNodePath.substring(1);
        Node rootNode = this._session.getRootNode();
        if (rootNode.hasNode(nodeName)) {
            System.out.println("About to delete" + absNodePath);
            rootNode.getNode(nodeName).remove();
            System.out.println("Node " + absNodePath + " deleted.");
            this._session.save();
        } else {
            System.out.println("Node " + absNodePath + " does not exist in this workspace.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNodeType(String ntName) throws Exception {
        Session sysSession = null;
        try {
            sysSession = SessionProvider.createSystemProvider().getSession("system", this._repoService.getDefaultRepository());
            Node ntNode = sysSession.getRootNode().getNode("jcr:system/jcr:nodetypes");
            Node reminderNT = ntNode.getNode(ntName);
            reminderNT.remove();
            sysSession.save();
            System.out.print(ntName + " nodetype removed");
        }
        finally {
            if (sysSession != null) {
                sysSession.logout();
            }
        }
    }

    private void traverseNodes(String sqlQuery, NodeVisitor visitor) throws Exception {
        QueryManager qman = this._session.getWorkspace().getQueryManager();
        Query q = qman.createQuery(sqlQuery, "sql");
        QueryResult result = q.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            visitor.visitNode(node);
        }
        this._session.save();
    }

    public void renameStringProperty(Node node, String oldName, String newName) throws Exception {
        if (node.hasProperty(oldName)) {
            String value = node.getProperty(oldName).getString();
            node.setProperty(newName, value);
            node.getProperty(oldName).remove();
            System.out.println("Renamed property " + oldName + " to " + newName + " on " + node.getPath() + ".");
        }
    }

    private void copyStringProperty(Node node, String oldName, String newName) throws Exception {
        if (node.hasProperty(oldName)) {
            String value = node.getProperty(oldName).getString();
            node.setProperty(newName, value);
            System.out.println("Copied property " + oldName + " to " + newName + " on " + node.getPath() + ".");
        }
    }

    private void deleteProperty(Node node, String propertyName) throws Exception {
        if (node.hasProperty(propertyName)) {
            node.getProperty(propertyName).remove();
            System.out.println("Deleted " + propertyName + " on " + node.getPath());
        }
    }

    private void registerNodeTypes(String nodeTypeFilesName) throws Exception {
        ExtendedNodeTypeManager ntManager = this._repoService.getDefaultRepository().getNodeTypeManager();
        FileInputStream inXml = new FileInputStream(nodeTypeFilesName);
        System.out.println("Trying register node types from xml-file " + nodeTypeFilesName);
        ntManager.registerNodeTypes((InputStream)inXml, 0);
        System.out.println("Node types were registered from xml-file " + nodeTypeFilesName);
    }

    public static interface NodeVisitor {
        public void visitNode(Node var1) throws Exception;
    }
}

