/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.chat;

import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webservice.cs.bean.UIStateDataBean;

@Path(value="/chat/uistateservice")
public class UIStateService
implements ResourceContainer {
    public static final String JSON_CONTENT_TYPE = "application/json";
    public static final String APPLICATION_NAME = "eXoChat";
    public static final String JCR_STATE_DATA_NODE_PATH = "eXoChat/uistate";
    public static final String JCR_STATE_NOTE_TYPE = "lr:state";
    public static final String JCR_UI_STATE_NOTE_PROPERTY = "lr:ui";
    private NodeHierarchyCreator nodeHierarchyCreator;
    private static final CacheControl cc;

    public UIStateService(NodeHierarchyCreator nodeHierarchyCreator) {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    @POST
    @Path(value="/save/{username}/")
    @Produces(value={"application/json"})
    public Response saveState(@PathParam(value="username") String userName, UIStateDataBean stateData) throws Exception {
        try {
            Node uiStateNode = this.getPrivateNode(userName);
            uiStateNode.setProperty(JCR_UI_STATE_NOTE_PROPERTY, stateData.getData());
            if (!uiStateNode.isNew()) {
                uiStateNode.save();
            } else {
                uiStateNode.getSession().save();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        UIStateDataBean stateDataBean = new UIStateDataBean("null");
        return Response.ok((Object)stateDataBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
    }

    @GET
    @Path(value="/get/{username}/")
    @Produces(value={"application/json"})
    public Response getState(@PathParam(value="username") String username) throws Exception {
        Node uiStateNode = this.getPrivateNode(username);
        if (uiStateNode.hasProperty(JCR_UI_STATE_NOTE_PROPERTY)) {
            UIStateDataBean stateDataBean = new UIStateDataBean(uiStateNode.getProperty(JCR_UI_STATE_NOTE_PROPERTY).getString());
            return Response.ok((Object)stateDataBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
        }
        UIStateDataBean stateDataBean = new UIStateDataBean();
        return Response.ok((Object)stateDataBean, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
    }

    private Node getPrivateNode(String userName) throws Exception {
        Node applicationNode = this.nodeHierarchyCreator.getUserApplicationNode(this.getSessionProvider(), userName);
        if (!applicationNode.hasNode(APPLICATION_NAME)) {
            applicationNode.addNode(APPLICATION_NAME);
        }
        if (!applicationNode.hasNode(JCR_STATE_DATA_NODE_PATH)) {
            applicationNode.addNode(JCR_STATE_DATA_NODE_PATH, JCR_STATE_NOTE_TYPE);
        }
        applicationNode.getSession().save();
        return applicationNode.getNode(JCR_STATE_DATA_NODE_PATH);
    }

    private SessionProvider getSessionProvider() {
        return new SessionProvider(ConversationState.getCurrent());
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

