/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.mail;

import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webservice.cs.bean.ContactData;

@Path(value="/cs/mail")
public class MailWebservice
implements ResourceContainer {
    public static final String TEXT_XML = "text/xml".intern();
    public static final String JSON = "application/json".intern();
    public static final String TEXT = "plain/text".intern();
    public static final int MIN_SLEEP_TIMEOUT = 100;
    public static final int MAX_TIMEOUT = 16;

    @GET
    @Path(value="/checkmail/{username}/{accountId}/{folderId}/")
    public Response checkMail(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId, @PathParam(value="folderId") String folderId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            mailService.checkMail(userName, accountId, folderId);
        } else if (folderId != null && folderId.trim().length() > 0 && !folderId.equalsIgnoreCase("checkall")) {
            checkingInfo.setRequestingForFolder_(folderId);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        buffer.append("    <status>101</status>");
        if (checkingInfo != null) {
            buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
        }
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/synchfolders/{username}/{accountId}/")
    public Response synchFolders(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            mailService.synchImapFolders(userName, accountId);
            checkingInfo = mailService.getCheckingInfo(userName, accountId);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        if (checkingInfo != null) {
            buffer.append("    <status>" + checkingInfo.getSyncFolderStatus() + "</status>");
        }
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        mailService.removeCheckingInfo(userName, accountId);
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/stopcheckmail/{username}/{accountId}/")
    public Response stopCheckMail(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        StringBuffer buffer = new StringBuffer();
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            Response.status((int)500);
            return Response.ok().build();
        }
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        buffer.append("    <status>" + checkingInfo.getStatusCode() + "</status>");
        buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        checkingInfo.setRequestStop(true);
        mailService.removeCheckingInfo(userName, accountId);
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/checkmailjobinfo/{username}/{accountId}/")
    public Response getCheckMailJobInfo(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        StringBuffer buffer = new StringBuffer();
        if (checkingInfo == null) {
            Thread.sleep(100L);
            checkingInfo = mailService.getCheckingInfo(userName, accountId);
            buffer.append("<info>");
            buffer.append("  <checkingmail>");
            buffer.append("    <status>1000</status>");
            buffer.append("  </checkingmail>");
            buffer.append("</info>");
            return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
        }
        if (!checkingInfo.hasChanged()) {
            Thread.sleep(100L);
            for (int i = 1; i < 1600 && !checkingInfo.hasChanged(); ++i) {
                Thread.sleep(100L);
            }
        }
        if (checkingInfo != null) {
            if (checkingInfo.getStatusCode() == 200 || checkingInfo.getStatusCode() == 102 || checkingInfo.getStatusCode() == 103) {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>" + checkingInfo.getStatusCode() + "</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
                return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
            }
            if (checkingInfo.hasChanged()) {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>150</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("    <total>" + checkingInfo.getTotalMsg() + "</total>");
                buffer.append("    <syncFolderStatus>" + checkingInfo.getSyncFolderStatus() + "</syncFolderStatus>");
                buffer.append("    <completed>" + checkingInfo.getFetching() + "</completed>");
                buffer.append("    <fetchingtofolders>" + checkingInfo.getFetchingToFolders() + "</fetchingtofolders>");
                if (checkingInfo.getMsgId() != null && !checkingInfo.getMsgId().equals("")) {
                    buffer.append("    <messageid>" + checkingInfo.getMsgId().replace("<", "&lt;").replace(">", "&gt;") + "</messageid>");
                }
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
                checkingInfo.setHasChanged(false);
            } else {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>201</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
            }
        }
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/searchemail/{keywords}")
    @Produces(value={"application/json"})
    public Response searchemail(@PathParam(value="keywords") String keywords) throws Exception {
        ContactService contactSvr = (ContactService)PortalContainer.getInstance().getComponentInstanceOfType(ContactService.class);
        ContactData fullData = new ContactData();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            if (ConversationState.getCurrent().getIdentity() == null) {
                return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            if (username == null) {
                return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
            }
            ContactFilter filter = new ContactFilter();
            filter.setType(DataStorage.PERSONAL);
            filter.searchByAnd(false);
            filter.setFullName(keywords);
            filter.setNickName(keywords);
            filter.setLimit(10);
            filter.setEmailAddress(keywords);
            Map data = contactSvr.searchEmails(username, filter);
            fullData.setInfo(data.values());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.ok((Object)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(cacheControl).build();
        }
        return Response.ok((Object)fullData, (String)"application/json").cacheControl(cacheControl).build();
    }
}

