/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.calendar;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/cs/calendar")
public class CalendarWebservice
implements ResourceContainer {
    public static final String BASE_URL = "/portal/rest".intern();

    protected void start() {
        PortalContainer manager = PortalContainer.getInstance();
        OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        ((ComponentRequestLifecycle)oService).startRequest((ExoContainer)manager);
    }

    protected void stop() {
        PortalContainer manager = PortalContainer.getInstance();
        OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        ((ComponentRequestLifecycle)oService).endRequest((ExoContainer)manager);
    }

    @GET
    @Path(value="/checkPermission/{username}/{calendarId}/{type}/")
    public Response checkPermission(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        StringBuffer buffer = new StringBuffer();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            Calendar cal = null;
            buffer.append("{canEdit:0}");
            if (0 == Integer.parseInt(type)) {
                buffer = new StringBuffer("{canEdit:1}");
            } else if (2 == Integer.parseInt(type)) {
                this.start();
                OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                cal = calService.getGroupCalendar(calendarId);
                if (Utils.canEdit((OrganizationService)oService, (String[])cal.getEditPermission(), (String)username)) {
                    buffer = new StringBuffer("{canEdit:1}");
                }
                this.stop();
            } else if (1 == Integer.parseInt(type) && calService.getSharedCalendars(username, true) != null && Utils.canEdit(null, (String[])(cal = calService.getSharedCalendars(username, true).getCalendarById(calendarId)).getEditPermission(), (String)username)) {
                buffer = new StringBuffer("{canEdit:1}");
            }
        }
        catch (Exception e) {
            buffer = new StringBuffer("{ERROR:500 " + e + "}");
        }
        return Response.ok((Object)buffer.toString(), (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/rss/{username}/{calendarId}/{type}/")
    public Response rss(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            Calendar cal = null;
            switch (Integer.parseInt(type)) {
                case 0: {
                    cal = calService.getUserCalendar(username, calendarId);
                    break;
                }
                case 2: {
                    cal = calService.getGroupCalendar(calendarId);
                    break;
                }
                case 1: {
                    cal = calService.getSharedCalendars(username, true).getCalendarById(calendarId);
                }
            }
            if (cal == null) {
                return Response.status((int)404).entity((Object)("Calendar " + calendarId + "is removed")).cacheControl(cacheControl).build();
            }
            if (cal.getPublicUrl() == null || cal.getPublicUrl().isEmpty()) {
                return Response.status((int)204).entity((Object)("Calendar " + calendarId + "is not public rss")).cacheControl(cacheControl).build();
            }
            List events = calService.getUserEventByCalendar(username, Arrays.asList(calendarId));
            return Response.ok((Object)this.makeRss(username, cal, events), (String)"application/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    private String makeRss(String auhtor, Calendar cal, List<CalendarEvent> events) throws Exception {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(cal.getName());
        feed.setLink(cal.getPublicUrl());
        if (cal.getDescription() == null) {
            cal.setDescription("This is description");
        }
        feed.setDescription(cal.getDescription());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (CalendarEvent e : events) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(e.getSummary());
            entry.setLink(cal.getPublicUrl().replaceFirst("rss", "subscribe") + Utils.SLASH + e.getId());
            entry.setAuthor(auhtor);
            SyndContentImpl description = new SyndContentImpl();
            description.setType(Utils.MIMETYPE_TEXTPLAIN);
            description.setValue(e.getDescription());
            entry.setDescription((SyndContent)description);
            entries.add(entry);
            entry.getEnclosures();
        }
        feed.setEntries(entries);
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        String feedXML = output.outputString((SyndFeed)feed);
        feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
        return feedXML;
    }

    @GET
    @Path(value="/subscribe/{username}/{calendarId}/{type}")
    public Response publicProcess(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            CalendarImportExport icalEx = calService.getCalendarImportExports(CalendarService.ICALENDAR);
            OutputStream out = icalEx.exportCalendar(username, Arrays.asList(calendarId), type);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toString().getBytes());
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="private/{username}/{calendarId}/{type}")
    public Response privateProcess(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            CalendarImportExport icalEx = calService.getCalendarImportExports(CalendarService.ICALENDAR);
            OutputStream out = icalEx.exportCalendar(username, Arrays.asList(calendarId), type);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toString().getBytes());
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }
}

