/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.mail;

import com.sun.mail.imap.IMAPStore;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.contact.service.ContactFilter;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webservice.cs.bean.ContactData;

@Path(value="/cs/mail")
public class MailWebservice
implements ResourceContainer {
    public static final String TEXT_XML = "text/xml".intern();
    public static final String JSON = "application/json".intern();
    public static final String TEXT = "plain/text".intern();
    public static final int MIN_SLEEP_TIMEOUT = 100;
    public static final int MAX_TIMEOUT = 16;
    private static final Log log = LogFactory.getLog(MailWebservice.class);

    @GET
    @Path(value="/checkmail/{username}/{accountId}/{folderId}/")
    public Response checkMail(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId, @PathParam(value="folderId") String folderId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            mailService.checkMail(userName, accountId, folderId);
        } else if (folderId != null && folderId.trim().length() > 0 && !folderId.equalsIgnoreCase("checkall")) {
            checkingInfo.setRequestingForFolder_(folderId);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        int stt = 101;
        String sttMsg = "";
        if (checkingInfo != null) {
            checkingInfo.getStatusMsg();
        }
        try {
            Account account = mailService.getAccountById(userName, accountId);
            Properties props = System.getProperties();
            props.setProperty("mail.mime.base64.ignoreerrors", "true");
            String socketFactoryClass = "javax.net.SocketFactory";
            if (account.isIncomingSsl()) {
                socketFactoryClass = Utils.SSL_FACTORY;
            }
            props.setProperty("mail.imap.socketFactory.fallback", "false");
            props.setProperty("mail.imap.socketFactory.class", socketFactoryClass);
            Session session = Session.getDefaultInstance((Properties)props, null);
            IMAPStore imapStore = (IMAPStore)session.getStore("imap");
            try {
                imapStore.connect(account.getIncomingHost(), Integer.valueOf(account.getIncomingPort()).intValue(), account.getIncomingUser(), account.getIncomingPassword());
            }
            catch (AuthenticationFailedException e) {
                if (!account.isSavePassword()) {
                    account.setIncomingPassword("");
                }
                sttMsg = "The userName or password may be wrong.";
                stt = 103;
            }
            catch (MessagingException e) {
                sttMsg = "Connecting failed. Please check server configuration.";
                stt = 102;
            }
            catch (IllegalStateException e) {
                log.error((Object)"cannot connect to server", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"cannot connect to server", (Throwable)e);
                sttMsg = "There was an unexpected error. Connecting failed.";
                stt = 102;
            }
        }
        catch (AccessDeniedException e) {
            log.error((Object)"cannot connect to server", (Throwable)e);
        }
        catch (Exception ex) {
            log.error((Object)"cannot connect to server", (Throwable)ex);
        }
        buffer.append("    <status>" + stt + "</status>");
        buffer.append("    <statusmsg>" + sttMsg + "</statusmsg>");
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/synchfolders/{username}/{accountId}/")
    public Response synchFolders(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            mailService.synchImapFolders(userName, accountId);
            checkingInfo = mailService.getCheckingInfo(userName, accountId);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        if (checkingInfo != null) {
            buffer.append("    <status>" + checkingInfo.getSyncFolderStatus() + "</status>");
        }
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        mailService.removeCheckingInfo(userName, accountId);
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/stopcheckmail/{username}/{accountId}/")
    public Response stopCheckMail(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        StringBuffer buffer = new StringBuffer();
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        if (checkingInfo == null) {
            Response.status((int)500);
            return Response.ok().build();
        }
        buffer.append("<info>");
        buffer.append("  <checkingmail>");
        buffer.append("    <status>" + checkingInfo.getStatusCode() + "</status>");
        buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
        buffer.append("  </checkingmail>");
        buffer.append("</info>");
        checkingInfo.setRequestStop(true);
        mailService.stopCheckMail(userName, accountId);
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/checkmailjobinfo/{username}/{accountId}/")
    public Response getCheckMailJobInfo(@PathParam(value="username") String userName, @PathParam(value="accountId") String accountId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        MailService mailService = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        CheckingInfo checkingInfo = mailService.getCheckingInfo(userName, accountId);
        StringBuffer buffer = new StringBuffer();
        if (checkingInfo == null) {
            Thread.sleep(100L);
            checkingInfo = mailService.getCheckingInfo(userName, accountId);
            buffer.append("<info>");
            buffer.append("  <checkingmail>");
            buffer.append("    <status>1000</status>");
            buffer.append("  </checkingmail>");
            buffer.append("</info>");
            return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
        }
        if (checkingInfo != null && !checkingInfo.hasChanged()) {
            Thread.sleep(100L);
            for (int i = 1; i < 1600 && !checkingInfo.hasChanged(); ++i) {
                Thread.sleep(100L);
            }
        }
        if (checkingInfo != null) {
            if (checkingInfo.getStatusCode() == 200 || checkingInfo.getStatusCode() == 102 || checkingInfo.getStatusCode() == 103 || checkingInfo.getStatusCode() == 101) {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>" + checkingInfo.getStatusCode() + "</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
                if (checkingInfo.getStatusCode() == 200) {
                    mailService.removeCheckingInfo(userName, accountId);
                }
                return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
            }
            if (checkingInfo.hasChanged()) {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>150</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("    <total>" + checkingInfo.getTotalMsg() + "</total>");
                buffer.append("    <syncFolderStatus>" + checkingInfo.getSyncFolderStatus() + "</syncFolderStatus>");
                buffer.append("    <completed>" + checkingInfo.getFetching() + "</completed>");
                buffer.append("    <fetchingtofolders>" + checkingInfo.getFetchingToFolders() + "</fetchingtofolders>");
                if (checkingInfo.getMsgId() != null && !checkingInfo.getMsgId().equals("")) {
                    buffer.append("    <messageid>" + checkingInfo.getMsgId().replace("<", "&lt;").replace(">", "&gt;") + "</messageid>");
                }
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
                checkingInfo.setHasChanged(false);
            } else {
                buffer.append("<info>");
                buffer.append("  <checkingmail>");
                buffer.append("    <status>201</status>");
                buffer.append("    <statusmsg>" + checkingInfo.getStatusMsg() + "</statusmsg>");
                buffer.append("  </checkingmail>");
                buffer.append("</info>");
            }
        }
        return Response.ok((Object)buffer.toString(), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/searchemail/{keywords}")
    @Produces(value={"application/json"})
    public Response searchemail(@PathParam(value="keywords") String keywords) throws Exception {
        ContactService contactSvr = (ContactService)PortalContainer.getInstance().getComponentInstanceOfType(ContactService.class);
        ContactData fullData = new ContactData();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            if (ConversationState.getCurrent().getIdentity() == null) {
                return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            if (username == null) {
                return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
            }
            ContactFilter filter = new ContactFilter();
            filter.setType(DataStorage.PERSONAL);
            filter.searchByAnd(false);
            filter.setFullName(keywords);
            filter.setNickName(keywords);
            filter.setLimit(10);
            filter.setEmailAddress(keywords);
            fullData.setInfo(contactSvr.searchEmailsByFilter(username, filter));
        }
        catch (Exception e) {
            log.error((Object)"error search email", (Throwable)e);
            return Response.ok((Object)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(cacheControl).build();
        }
        return Response.ok((Object)fullData, (String)"application/json").cacheControl(cacheControl).build();
    }
}

