/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.bulkactions;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.Session;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.ActionData;
import org.exoplatform.documents.model.ActionStatus;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.documents.storage.jcr.bulkactions.ActionThread;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.picocontainer.Startable;

public class BulkStorageActionService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)BulkStorageActionService.class.getName());
    private ExecutorService bulkActionThreadPool;
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private static final String ZIP_PREFIX = "downloadzip";
    private static final String TEMP_FOLDER_PREFIX = "temp_download";
    private static final List<ActionData> actionList = new ArrayList<ActionData>();

    public void executeBulkAction(Session session, int actionId, DocumentFileStorage documentFileStorage, JCRDeleteFileStorage jcrDeleteFileStorage, ListenerService listenerService, List<AbstractNode> items, String actionType, Map<String, Object> params, Identity identity, long authenticatedUserId) {
        ActionData actionData = new ActionData();
        actionData.setActionId(actionId);
        actionData.setStatus(ActionStatus.STARTED.name());
        actionData.setActionType(actionType);
        actionData.setNumberOfItems(items.size());
        actionData.setIdentity(identity);
        actionList.add(actionData);
        this.bulkActionThreadPool.execute(new ActionThread(documentFileStorage, jcrDeleteFileStorage, this, listenerService, actionData, params, session, items, identity, authenticatedUserId));
    }

    public void start() {
        this.bulkActionThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("documents-bulk-action-%d").build());
    }

    public void stop() {
        if (this.bulkActionThreadPool != null) {
            this.bulkActionThreadPool.shutdownNow();
        }
        File temp = new File(System.getProperty(TEMP_DIRECTORY_PATH));
        this.cleanTempFiles(temp);
    }

    private void cleanTempFiles(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                this.cleanTempFiles(f);
            }
        }
        if (file.getName().startsWith(TEMP_FOLDER_PREFIX) || file.getName().startsWith(ZIP_PREFIX)) {
            file.delete();
        }
    }

    public ActionData getActionDataById(int id) {
        return actionList.stream().filter(resource -> id == resource.getActionId()).findFirst().orElse(null);
    }

    public void removeActionData(ActionData actionData) {
        actionList.remove(actionData);
    }
}

