/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.exoplatform.documents.model.DownloadItem;
import org.exoplatform.documents.service.ExternalDownloadService;
import org.exoplatform.documents.storage.DocumentFileStorage;

public class ExternalDownloadServiceImpl
implements ExternalDownloadService {
    private final DocumentFileStorage documentFileStorage;

    public ExternalDownloadServiceImpl(DocumentFileStorage documentFileStorage) {
        this.documentFileStorage = documentFileStorage;
    }

    public DownloadItem getDocumentDownloadItem(String documentId) {
        if (documentId == null) {
            throw new IllegalArgumentException("document id is mandatory");
        }
        return this.documentFileStorage.getDocumentDownloadItem(documentId);
    }

    public byte[] downloadZippedFolder(String folderId) throws IOException {
        String downloadPath = this.documentFileStorage.downloadFolder(folderId);
        File zipped = new File(downloadPath);
        byte[] filesBytes = FileUtils.readFileToByteArray((File)zipped);
        Files.delete(Path.of(downloadPath, new String[0]));
        return filesBytes;
    }
}

