/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.documents.constant.FileListingType;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.BreadCrumbItem;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.model.DocumentsSize;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FullTreeItem;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.services.security.Identity;

public interface DocumentFileService {
    public List<AbstractNode> getDocumentItems(FileListingType var1, DocumentNodeFilter var2, int var3, int var4, long var5, boolean var7) throws IllegalAccessException, ObjectNotFoundException;

    public List<FileNode> getFilesTimeline(DocumentTimelineFilter var1, int var2, int var3, long var4) throws IllegalAccessException, ObjectNotFoundException;

    public DocumentGroupsSize getGroupDocumentsCount(DocumentTimelineFilter var1, long var2) throws IllegalAccessException, ObjectNotFoundException;

    public List<AbstractNode> getFolderChildNodes(DocumentFolderFilter var1, int var2, int var3, long var4) throws IllegalAccessException, ObjectNotFoundException;

    public List<BreadCrumbItem> getBreadcrumb(long var1, String var3, String var4, long var5) throws IllegalAccessException, ObjectNotFoundException;

    public List<FullTreeItem> getFullTreeData(long var1, String var3, long var4, boolean var6) throws IllegalAccessException, ObjectNotFoundException;

    public AbstractNode duplicateDocument(long var1, String var3, String var4, long var5) throws IllegalAccessException, ObjectNotFoundException;

    public void moveDocument(long var1, String var3, String var4, long var5, String var7) throws IllegalAccessException, ObjectNotFoundException, ObjectAlreadyExistsException;

    public void deleteDocument(String var1, String var2, boolean var3, long var4, long var6) throws IllegalAccessException;

    public void undoDeleteDocument(String var1, long var2);

    public void deleteDocuments(int var1, List<AbstractNode> var2, long var3) throws IllegalAccessException;

    public void downloadDocuments(int var1, List<AbstractNode> var2, long var3) throws IllegalAccessException;

    public void updatePermissions(String var1, NodePermission var2, long var3) throws IllegalAccessException;

    public void shareDocument(String var1, long var2, long var4, boolean var6) throws IllegalAccessException;

    public void notifyMember(String var1, long var2) throws IllegalAccessException;

    public void unShareDocument(String var1, long var2) throws IllegalStateException, RepositoryException;

    public AbstractNode createFolder(long var1, String var3, String var4, String var5, long var6) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException;

    public String getNewName(long var1, String var3, String var4, String var5) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException;

    public void renameDocument(long var1, String var3, String var4, long var5) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException;

    public boolean canAccess(String var1, Identity var2) throws RepositoryException;

    public Identity getAclUserIdentity(String var1) throws IllegalAccessException;

    default public void updateDocumentDescription(long ownerId, String documentID, String description, long aclIdentity) throws IllegalStateException, IllegalAccessException, RepositoryException {
        throw new IllegalStateException("updateDocumentDescription method not implemented in the target class");
    }

    public void createShortcut(String var1, String var2, String var3, String var4) throws IllegalAccessException, ObjectAlreadyExistsException;

    public List<FileVersion> getFileVersions(String var1, String var2);

    public FileVersion updateVersionSummary(String var1, String var2, String var3, String var4);

    public FileVersion restoreVersion(String var1, String var2);

    public boolean canAddDocument(String var1, String var2);

    public byte[] getDownloadZipBytes(int var1, String var2) throws IOException;

    public void cancelBulkAction(String var1, String var2) throws IOException;

    public FileVersion createNewVersion(String var1, String var2, InputStream var3);

    public void moveDocuments(int var1, long var2, List<AbstractNode> var4, String var5, long var6) throws IllegalAccessException;

    public String getDefaultView(Long var1, String var2);

    public boolean canImport(Identity var1);

    public DocumentsSize getDocumentsSizeStat(long var1, long var3) throws IllegalAccessException, ObjectNotFoundException;

    public DocumentsSize addDocumentsSizeStat(long var1, long var3) throws IllegalAccessException, ObjectNotFoundException;

    public void setDefaultView(Long var1, String var2, String var3);

    public boolean hasEditPermissionOnDocument(String var1, long var2) throws IllegalAccessException;

    public void importFiles(String var1, String var2, String var3, String var4, String var5, Identity var6, long var7) throws Exception;
}

