/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.pwa;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;

public class ImportDocumentsPwaPlugin
implements PwaNotificationPlugin {
    public static final String ID = "ImportDocumentsPlugin";
    private ResourceBundleService resourceBundleService;
    private static final String TITLE_LABEL_KEY = "pwa.notification.ImportDocumentsPwaPlugin.title";

    public ImportDocumentsPwaPlugin(ResourceBundleService resourceBundleService) {
        this.resourceBundleService = resourceBundleService;
    }

    public String getId() {
        return ID;
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        String title = this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", notification.getValueOwnerParameter(NotificationConstants.TOTAL_NUMBER.getKey())).replace("{1}", notification.getValueOwnerParameter(NotificationConstants.FOLDER_NAME.getKey()));
        notificationMessage.setTitle(title);
        String url = notification.getValueOwnerParameter(NotificationConstants.FOLDER_URL.getKey());
        url = url.replace(CommonsUtils.getCurrentDomain(), "");
        notificationMessage.setUrl(url);
        return notificationMessage;
    }
}

