/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage;

import io.meeds.portal.thumbnail.model.FileContent;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.BreadCrumbItem;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.model.DownloadItem;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FullTreeItem;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;

public interface DocumentFileStorage {
    public List<FileNode> getFilesTimeline(DocumentTimelineFilter var1, Identity var2, int var3, int var4) throws ObjectNotFoundException;

    public List<FileNode> search(String var1, Identity var2, int var3, int var4);

    public List<AbstractNode> getBiggestDocuments(Long var1, Identity var2, int var3, int var4) throws ObjectNotFoundException;

    public long calculateFilesSize(Long var1, Identity var2) throws ObjectNotFoundException;

    public DocumentGroupsSize getGroupDocumentsCount(DocumentTimelineFilter var1, Identity var2) throws ObjectNotFoundException;

    public List<AbstractNode> getFolderChildNodes(DocumentFolderFilter var1, Identity var2, int var3, int var4) throws IllegalAccessException, ObjectNotFoundException;

    public List<BreadCrumbItem> getBreadcrumb(long var1, String var3, String var4, Identity var5) throws IllegalAccessException, ObjectNotFoundException;

    public List<FullTreeItem> getFullTreeData(long var1, String var3, Identity var4, boolean var5) throws IllegalAccessException, ObjectNotFoundException;

    public void setDocumentVisibility(long var1, String var3, Boolean var4, Identity var5) throws ObjectAlreadyExistsException;

    public AbstractNode duplicateDocument(long var1, String var3, String var4, Identity var5) throws IllegalAccessException, ObjectNotFoundException;

    public void moveDocument(Session var1, long var2, String var4, String var5, Identity var6, String var7) throws Exception;

    public void moveDocument(long var1, String var3, String var4, Identity var5, String var6) throws IllegalAccessException, ObjectNotFoundException, ObjectAlreadyExistsException;

    public AbstractNode createFolder(long var1, String var3, String var4, String var5, Identity var6) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException;

    public String getNewName(long var1, String var3, String var4, String var5) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException;

    public void renameDocument(long var1, String var3, String var4, Identity var5) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException;

    public void updatePermissions(String var1, NodePermission var2, Identity var3);

    public void downloadDocuments(int var1, List<AbstractNode> var2, Identity var3, long var4);

    public void shareDocument(String var1, long var2, Identity var4, boolean var5) throws IllegalAccessException;

    public void unShareDocument(String var1, long var2) throws RepositoryException;

    public void notifyMember(String var1, long var2) throws IllegalAccessException;

    public boolean canAccess(String var1, Identity var2);

    default public void updateDocumentDescription(long ownerId, String documentID, String description, Identity aclIdentity) throws IllegalStateException, RepositoryException {
        throw new IllegalStateException("updateDocumentDescription not implemented in the target classs");
    }

    public void createShortcut(String var1, String var2, String var3, String var4) throws IllegalAccessException, ObjectAlreadyExistsException;

    public List<FileVersion> getFileVersions(String var1, String var2);

    public AbstractNode getDocumentById(String var1, String var2) throws ObjectNotFoundException, IllegalAccessException;

    public AbstractNode getDocumentById(String var1);

    public FileContent getDocumentContent(String var1, String var2) throws ObjectNotFoundException;

    public FileVersion updateVersionSummary(String var1, String var2, String var3, String var4);

    public FileVersion restoreVersion(String var1, String var2);

    public byte[] getDownloadZipBytes(int var1, String var2) throws IOException;

    public void cancelBulkAction(String var1, String var2) throws IOException;

    public FileVersion createNewVersion(String var1, String var2, InputStream var3);

    public void moveDocuments(int var1, long var2, List<AbstractNode> var4, String var5, Identity var6, long var7);

    public boolean hasEditPermissions(String var1, Identity var2);

    public DownloadItem getDocumentDownloadItem(String var1);

    public String downloadFolder(String var1);

    public void importFiles(String var1, Space var2, String var3, String var4, String var5, String var6, Identity var7, String var8, long var9) throws Exception;

    public boolean canImport(Identity var1);
}

