/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.plugins;

import io.meeds.social.category.plugin.CategoryPlugin;
import java.util.List;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.portal.config.UserACL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentCategoryPlugin
implements CategoryPlugin {
    public static final String OBJECT_TYPE = "document";
    @Autowired
    private UserACL userAcl;
    @Autowired
    private DocumentFileService documentFileService;

    public String getType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(String documentId, String username) {
        AbstractNode document = this.documentFileService.getDocumentById(documentId);
        return document != null && (this.userAcl.hasAccessPermission(OBJECT_TYPE, documentId, this.userAcl.getUserIdentity(username)) || this.canEdit(documentId, username));
    }

    public boolean canEdit(String documentId, String username) {
        return this.userAcl.hasEditPermission(OBJECT_TYPE, documentId, this.userAcl.getUserIdentity(username));
    }

    public List<Long> getCategoryIds(long spaceId) {
        return this.documentFileService.getDocumentCategoryIds(spaceId, this.userAcl.getSuperUser());
    }
}

