/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.Tools;

public class WebDavItemProperty {
    protected QName name;
    protected String value;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected List<WebDavItemProperty> children = new ArrayList<WebDavItemProperty>();

    public WebDavItemProperty(QName name) {
        this(name, null);
    }

    public WebDavItemProperty(String name, String value) {
        this.name = WebDavItemProperty.toQname(name);
        this.value = value;
    }

    public static QName toQname(String name) {
        int index = name.lastIndexOf(":");
        if (index > 0) {
            return new QName(name.substring(0, index), name.substring(index + 1));
        }
        return new QName(name);
    }

    public WebDavItemProperty(QName name, String value) {
        this.name = name;
        this.value = value;
    }

    public WebDavItemProperty(QName name, Calendar dateValue, String formatPattern) {
        this(name, null);
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatPattern, Locale.ENGLISH);
        dateFormat.setTimeZone(Tools.getTimeZone((String)"GMT"));
        this.value = dateFormat.format(dateValue.getTime());
    }

    public String getStringName() {
        if (StringUtils.isNotBlank((CharSequence)this.name.getPrefix())) {
            return String.format("%s:%s", this.name.getPrefix(), this.name.getLocalPart());
        }
        return this.name.getLocalPart();
    }

    public WebDavItemProperty addChild(WebDavItemProperty prop) {
        this.children.add(prop);
        return prop;
    }

    public WebDavItemProperty getChild(QName name) {
        for (WebDavItemProperty child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public WebDavItemProperty getChild(int index) {
        return this.children.get(index);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Generated
    public QName getName() {
        return this.name;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<WebDavItemProperty> getChildren() {
        return this.children;
    }

    @Generated
    public void setName(QName name) {
        this.name = name;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setChildren(List<WebDavItemProperty> children) {
        this.children = children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebDavItemProperty)) {
            return false;
        }
        WebDavItemProperty other = (WebDavItemProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QName this$name = this.getName();
        QName other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebDavItemProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QName $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WebDavItemProperty(name=" + String.valueOf(this.getName()) + ", value=" + this.getValue() + ", attributes=" + String.valueOf(this.getAttributes()) + ", children=" + String.valueOf(this.getChildren()) + ")";
    }

    @Generated
    public WebDavItemProperty() {
    }
}

