/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.model;

import java.io.IOException;
import java.io.InputStream;

public class RangedInputStream
extends InputStream {
    private InputStream inputStream;
    private long end;
    private long start = 0L;

    public RangedInputStream(InputStream inputStream, long startRange, long endRange) throws IOException {
        this.inputStream = inputStream;
        this.end = endRange;
        this.start = inputStream.skip(startRange);
    }

    @Override
    public int read() throws IOException {
        if (this.start > this.end) {
            return -1;
        }
        int curReaded = this.inputStream.read();
        if (curReaded >= 0) {
            ++this.start;
        }
        return curReaded;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int size) throws IOException {
        long needsToRead = size;
        if (needsToRead > this.end - this.start + 1L) {
            needsToRead = this.end - this.start + 1L;
        }
        if (needsToRead == 0L) {
            return -1;
        }
        int curReaded = this.inputStream.read(buffer, offset, (int)needsToRead);
        this.start += (long)curReaded;
        return curReaded;
    }

    @Override
    public long skip(long skipVal) throws IOException {
        return this.inputStream.skip(skipVal);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int markVal) {
        this.inputStream.mark(markVal);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

