/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.plugin;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ImportDocumentsPlugin
extends BaseNotificationPlugin {
    public static final String ID = "ImportDocumentsPlugin";
    private final SpaceService spaceService;

    public ImportDocumentsPlugin(InitParams initParams, SpaceService spaceService) {
        super(initParams);
        this.spaceService = spaceService;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext notificationContext) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext notificationContext) {
        LinkedList<String> receivers;
        String fromUser = (String)notificationContext.value(NotificationConstants.FROM_USER);
        String target = (String)notificationContext.value(NotificationConstants.RECEIVERS);
        Space space = this.spaceService.getSpaceByPrettyName(target);
        if (space != null) {
            receivers = new LinkedList<String>(Arrays.asList(space.getMembers()));
            receivers.remove(fromUser);
        } else {
            receivers = new LinkedList<String>(List.of(target));
        }
        String documentUrl = (String)notificationContext.value(NotificationConstants.FOLDER_URL);
        String folderName = (String)notificationContext.value(NotificationConstants.FOLDER_NAME);
        String duration = (String)notificationContext.value(NotificationConstants.DURATION);
        String total = (String)notificationContext.value(NotificationConstants.TOTAL_NUMBER);
        String filesCreated = (String)notificationContext.value(NotificationConstants.FILES_CREATED);
        String filesDuplicated = (String)notificationContext.value(NotificationConstants.FILES_DUPLICATED);
        String filesUpdated = (String)notificationContext.value(NotificationConstants.FILES_UPDATED);
        String filesIgnored = (String)notificationContext.value(NotificationConstants.FILES_IGNORED);
        String filesFailed = (String)notificationContext.value(NotificationConstants.FILES_FAILED);
        return NotificationInfo.instance().setFrom(fromUser).to(receivers).with(NotificationConstants.FROM_USER.getKey(), fromUser).with(NotificationConstants.FOLDER_URL.getKey(), documentUrl).with(NotificationConstants.FOLDER_NAME.getKey(), folderName).with(NotificationConstants.DURATION.getKey(), duration).with(NotificationConstants.TOTAL_NUMBER.getKey(), total).with(NotificationConstants.FILES_CREATED.getKey(), filesCreated).with(NotificationConstants.FILES_DUPLICATED.getKey(), filesDuplicated).with(NotificationConstants.FILES_UPDATED.getKey(), filesUpdated).with(NotificationConstants.FILES_IGNORED.getKey(), filesIgnored).with(NotificationConstants.FILES_FAILED.getKey(), filesFailed).key(this.getKey()).end();
    }
}

