/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.documents.storage.jcr.webdav.model.JcrNamespaceContext;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavReadCommandHandler;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavWriteCommandHandler;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavFileDownload;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.WebDavItemOrder;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.model.WebDavLockResponse;
import org.exoplatform.documents.webdav.service.DocumentWebDavService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.RepositoryServiceImpl;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.webdav.util.NodeTypeUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class JcrWebDavService
implements DocumentWebDavService {
    public static final String REPOSITORY_NAME = "repository";
    public static final String DAS_VALUE = "<DAV:basicsearch><exo:sql xmlns:exo=\"http://exoplatform.com/jcr\"/><exo:xpath xmlns:exo=\"http://exoplatform.com/jcr\"/>";
    protected static final Log LOG = ExoLogger.getLogger(JcrWebDavService.class);
    protected WebdavReadCommandHandler readCommandHandler;
    protected WebdavWriteCommandHandler writeCommandHandler;
    protected RepositoryServiceImpl repositoryService;
    protected UserACL userAcl;
    private NamespaceContext namespaceContext;

    public JcrWebDavService(WebdavReadCommandHandler readCommandHandler, WebdavWriteCommandHandler writeCommandHandler, RepositoryServiceImpl repositoryService, UserACL userAcl) {
        this.readCommandHandler = readCommandHandler;
        this.writeCommandHandler = writeCommandHandler;
        this.repositoryService = repositoryService;
        this.userAcl = userAcl;
    }

    public NamespaceContext getNamespaceContext() {
        if (this.namespaceContext == null) {
            this.namespaceContext = this.buildNameSpaceContext();
        }
        return this.namespaceContext;
    }

    public String getDaslValue() {
        return DAS_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFile(String webDavPath) {
        boolean bl;
        Session session = this.getSession();
        try {
            bl = this.readCommandHandler.isFile(session, webDavPath);
        }
        catch (Throwable throwable) {
            session.logout();
            throw throwable;
        }
        session.logout();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDavFileDownload download(String webDavPath, String version, String baseUri, String username) throws WebDavException {
        WebDavFileDownload webDavFileDownload;
        Session session = this.getSession(username);
        try {
            webDavFileDownload = this.readCommandHandler.download(session, webDavPath, version);
        }
        catch (Throwable throwable) {
            session.logout();
            throw throwable;
        }
        session.logout();
        return webDavFileDownload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModifiedDate(String webDavPath, String version) throws WebDavException {
        Session session = this.getSession();
        try {
            long l = this.readCommandHandler.getLastModifiedDate(session, webDavPath, version);
            return l;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDavItem get(String webDavPath, String propRequestType, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, String baseUri, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            WebDavItem webDavItem = this.readCommandHandler.get(session, webDavPath, requestedPropertyNames, requestPropertyNamesOnly, depth, baseUri, username);
            return webDavItem;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebDavItem> search(String webDavPath, String queryLanguage, String query, String baseUri, String username) {
        Session session = this.getSession(username);
        try {
            List<WebDavItem> list = this.readCommandHandler.search(session, queryLanguage, query, baseUri, username);
            return list;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebDavItem> getVersions(String webDavPath, Set<QName> requestedPropertyNames, String baseUri, String username) {
        Session session = this.getSession(username);
        try {
            List<WebDavItem> list = this.readCommandHandler.getVersions(session, webDavPath, requestedPropertyNames, baseUri);
            return list;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFolder(String webDavPath, String folderType, String contentNodeType, String mixinTypes, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            this.writeCommandHandler.createFolder(session, webDavPath, NodeTypeUtil.getMixinTypes((String)mixinTypes));
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(String webDavPath, String fileType, String contentNodeType, String mediaType, String mixinTypes, InputStream inputStream, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            this.writeCommandHandler.saveFile(session, webDavPath, mediaType, NodeTypeUtil.getMixinTypes((String)mixinTypes), inputStream);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String webDavPath, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            this.writeCommandHandler.delete(session, webDavPath);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(String sourcePath, String targetPath, boolean overwrite, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, sourcePath, lockTokens);
            boolean bl = this.writeCommandHandler.move(session, sourcePath, targetPath, overwrite);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String sourcePath, String targetPath, int depth, boolean overwrite, boolean removeDestination, WebDavItemProperty webDavItemProperty, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, sourcePath, lockTokens);
            this.writeCommandHandler.copy(session, sourcePath, targetPath, overwrite, removeDestination);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Collection<WebDavItemProperty>> saveProperties(String webDavPath, List<WebDavItemProperty> propertiesToSave, List<WebDavItemProperty> propertiesToRemove, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            Map<String, Collection<WebDavItemProperty>> map = this.writeCommandHandler.saveProperties(session, webDavPath, propertiesToSave, propertiesToRemove);
            return map;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableVersioning(String webDavPath, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            this.writeCommandHandler.enableVersioning(session, webDavPath);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkin(String webDavPath, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            this.writeCommandHandler.checkin(session, webDavPath);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(String webDavPath, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            this.writeCommandHandler.checkout(session, webDavPath);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncheckout(String webDavPath, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            this.writeCommandHandler.uncheckout(session, webDavPath);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDavLockResponse lock(String webDavPath, int depth, int lockTimeout, boolean bodyIsEmpty, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            WebDavLockResponse webDavLockResponse = this.writeCommandHandler.lock(session, webDavPath, depth, lockTimeout, bodyIsEmpty, username);
            return webDavLockResponse;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String webDavPath, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            this.writeCommandHandler.unlock(session, webDavPath, lockTokens);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean order(String webDavPath, List<WebDavItemOrder> members, List<String> lockTokens, String username) throws WebDavException {
        Session session = this.getSession(username);
        try {
            this.checkLock(session, webDavPath, lockTokens);
            boolean bl = this.writeCommandHandler.order(session, webDavPath, members);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    public void unlockTimedOutNodes() {
        List<String> nodePaths = this.writeCommandHandler.getOutdatedLockedNodePaths();
        if (CollectionUtils.isNotEmpty(nodePaths)) {
            Session session = this.getSession();
            nodePaths.forEach(jcrPath -> {
                try {
                    this.writeCommandHandler.unlockNode(session, (String)jcrPath);
                    LOG.info("Node with path {} was automatically unlocked after the lock timed out", new Object[]{jcrPath});
                }
                catch (Exception e) {
                    LOG.warn("Error while automatically unlocking node with path {}. Delete it to not attempt unlocking it again", new Object[]{jcrPath, e});
                    this.writeCommandHandler.removeLockTimeout((String)jcrPath);
                }
            });
        }
    }

    private JcrNamespaceContext buildNameSpaceContext() {
        String[] jcrPrefixes;
        HashMap<String, String> prefixes = new HashMap<String, String>();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        prefixes.put("DAV:", "D");
        namespaces.put("D", "DAV:");
        NamespaceRegistry namespaceRegistry = this.repositoryService.getDefaultRepository().getNamespaceRegistry();
        for (String p : jcrPrefixes = namespaceRegistry.getPrefixes()) {
            String u = namespaceRegistry.getURI(p);
            namespaces.put(p, u);
            prefixes.put(u, p);
        }
        return new JcrNamespaceContext(prefixes, namespaces);
    }

    protected Session getSession(String username) {
        ManageableRepository repository = this.repositoryService.getDefaultRepository();
        RepositoryContainer repositoryContainer = this.repositoryService.getRepositoryContainer(REPOSITORY_NAME);
        WorkspaceContainer workspaceContainer = repositoryContainer.getWorkspaceContainer(repository.getConfiguration().getDefaultWorkspaceName());
        return this.newSession(username, repository, workspaceContainer);
    }

    protected Session getSession() {
        ManageableRepository repository = this.repositoryService.getDefaultRepository();
        return repository.getSystemSession(repository.getConfiguration().getDefaultWorkspaceName());
    }

    private void checkLock(Session session, String jcrPath, List<String> tokens) throws WebDavException {
        Node node;
        Item item;
        if (tokens != null && session.itemExists(jcrPath) && (item = session.getItem(jcrPath)) instanceof Node && (node = (Node)item).isLocked()) {
            Lock lock = node.getLock();
            String lockToken = lock.getLockToken();
            if (tokens.stream().noneMatch(l -> StringUtils.equalsIgnoreCase((CharSequence)l, (CharSequence)lockToken))) {
                throw new WebDavException(423, String.format("Resource with path '%s' is already locked by a different owner %s", jcrPath, lock.getLockOwner()));
            }
        }
    }

    public Session newSession(String username, ManageableRepository repository, WorkspaceContainer workspaceContainer) throws RepositoryException {
        return new SessionImpl(repository.getConfiguration().getDefaultWorkspaceName(), new ConversationState(this.userAcl.getUserIdentity(username)), (ExoContainer)workspaceContainer);
    }
}

