/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.cache.listener;

import java.util.Arrays;
import java.util.List;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.documents.storage.jcr.webdav.cache.CachedJcrWebDavService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebDavCacheUpdaterAction
implements EventListener {
    public static final List<String> SUPPORTED_NODE_TYPES = Arrays.asList("nt:resource", "nt:file", "nt:folder", "nt:unstructured");
    public static final List<String> SUPPORTED_PATHS = Arrays.asList("/Users", "/Groups/spaces");
    public static final int SUPPORTED_EVENT_TYPES = Arrays.asList(1, 2, 0x4000000, 0x2000000, 256, 512, 0x400000, 0x800000, 8192, 16384, 4, 16, 8).stream().reduce(0, (a, b) -> a | b);
    private static final Log LOG = ExoLogger.getLogger(WebDavCacheUpdaterAction.class);
    private CachedJcrWebDavService cachedJcrWebDavService;

    public WebDavCacheUpdaterAction(CachedJcrWebDavService cachedJcrWebDavService) {
        this.cachedJcrWebDavService = cachedJcrWebDavService;
    }

    public void onEvent(EventIterator eventIterator) {
        while (eventIterator.hasNext()) {
            Event event = eventIterator.nextEvent();
            int eventType = event.getType();
            String path = event.getPath();
            switch (eventType) {
                case 1: 
                case 2: 
                case 256: 
                case 512: 
                case 8192: 
                case 16384: 
                case 0x400000: 
                case 0x800000: 
                case 0x2000000: 
                case 0x4000000: {
                    path = path.endsWith("jcr:content") ? path.substring(0, path.lastIndexOf("/")) : path;
                    this.clearCache(path, eventType == 1 || eventType == 0x2000000 || eventType == 2 || eventType == 0x4000000);
                    break;
                }
                case 4: 
                case 8: 
                case 16: {
                    this.clearCache(path.substring(0, path.lastIndexOf("/")), false);
                }
            }
        }
    }

    private void clearCache(String path, boolean dropEntry) {
        try {
            this.getCachedJcrWebDavService().clearCache(path, dropEntry);
        }
        catch (Exception e) {
            LOG.warn("Error while clearing cache entry with path '{}' and drop option = '{}'", new Object[]{path, dropEntry, e});
        }
    }

    private CachedJcrWebDavService getCachedJcrWebDavService() {
        if (this.cachedJcrWebDavService == null) {
            this.cachedJcrWebDavService = (CachedJcrWebDavService)ExoContainerContext.getService(CachedJcrWebDavService.class);
        }
        return this.cachedJcrWebDavService;
    }
}

