/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch.entity;

import java.net.URI;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch.entity.WebDavItemPropertyEntity;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="webdav_nodes", createIndex=true)
@Mapping(dateDetection=Mapping.Detection.FALSE, numericDetection=Mapping.Detection.FALSE)
@Setting(replicas=0, shards=1)
public class WebDavItemEntity {
    @Id
    private String webDavPath;
    private String jcrPath;
    @Field(type=FieldType.Keyword)
    private String parentWebDavPath;
    private String identifier;
    private Set<String> usernames;
    private boolean file;
    private boolean deep;
    private boolean modified;
    @Field(type=FieldType.Nested)
    private List<WebDavItemPropertyEntity> properties;

    public WebDavItemEntity(WebDavItem webDavItem) {
        this(webDavItem.getWebDavPath(), webDavItem.getJcrPath(), webDavItem.getIdentifier(), webDavItem.isFile(), webDavItem.getProperties());
    }

    public WebDavItemEntity(String webDavPath, String jcrPath, URI identifier, boolean file, List<WebDavItemProperty> properties) {
        if (webDavPath.endsWith("/")) {
            webDavPath = webDavPath.substring(webDavPath.length() - 1);
        }
        this.webDavPath = webDavPath;
        this.jcrPath = jcrPath;
        this.parentWebDavPath = webDavPath.substring(0, webDavPath.lastIndexOf("/"));
        this.identifier = identifier == null ? null : identifier.toASCIIString();
        this.file = file;
        if (properties != null) {
            this.properties = properties.stream().map(WebDavItemPropertyEntity::new).toList();
        }
    }

    public WebDavItem toWebDavItem() {
        return new WebDavItem(this.webDavPath, this.jcrPath, this.identifier == null ? null : new URI(this.identifier), this.file, this.properties == null ? null : this.properties.stream().map(WebDavItemPropertyEntity::toWebDavItemProperty).toList(), null);
    }

    @Generated
    public String getWebDavPath() {
        return this.webDavPath;
    }

    @Generated
    public String getJcrPath() {
        return this.jcrPath;
    }

    @Generated
    public String getParentWebDavPath() {
        return this.parentWebDavPath;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public Set<String> getUsernames() {
        return this.usernames;
    }

    @Generated
    public boolean isFile() {
        return this.file;
    }

    @Generated
    public boolean isDeep() {
        return this.deep;
    }

    @Generated
    public boolean isModified() {
        return this.modified;
    }

    @Generated
    public List<WebDavItemPropertyEntity> getProperties() {
        return this.properties;
    }

    @Generated
    public void setWebDavPath(String webDavPath) {
        this.webDavPath = webDavPath;
    }

    @Generated
    public void setJcrPath(String jcrPath) {
        this.jcrPath = jcrPath;
    }

    @Generated
    public void setParentWebDavPath(String parentWebDavPath) {
        this.parentWebDavPath = parentWebDavPath;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setUsernames(Set<String> usernames) {
        this.usernames = usernames;
    }

    @Generated
    public void setFile(boolean file) {
        this.file = file;
    }

    @Generated
    public void setDeep(boolean deep) {
        this.deep = deep;
    }

    @Generated
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Generated
    public void setProperties(List<WebDavItemPropertyEntity> properties) {
        this.properties = properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebDavItemEntity)) {
            return false;
        }
        WebDavItemEntity other = (WebDavItemEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFile() != other.isFile()) {
            return false;
        }
        if (this.isDeep() != other.isDeep()) {
            return false;
        }
        if (this.isModified() != other.isModified()) {
            return false;
        }
        String this$webDavPath = this.getWebDavPath();
        String other$webDavPath = other.getWebDavPath();
        if (this$webDavPath == null ? other$webDavPath != null : !this$webDavPath.equals(other$webDavPath)) {
            return false;
        }
        String this$jcrPath = this.getJcrPath();
        String other$jcrPath = other.getJcrPath();
        if (this$jcrPath == null ? other$jcrPath != null : !this$jcrPath.equals(other$jcrPath)) {
            return false;
        }
        String this$parentWebDavPath = this.getParentWebDavPath();
        String other$parentWebDavPath = other.getParentWebDavPath();
        if (this$parentWebDavPath == null ? other$parentWebDavPath != null : !this$parentWebDavPath.equals(other$parentWebDavPath)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Set<String> this$usernames = this.getUsernames();
        Set<String> other$usernames = other.getUsernames();
        return !(this$usernames == null ? other$usernames != null : !((Object)this$usernames).equals(other$usernames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebDavItemEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFile() ? 79 : 97);
        result = result * 59 + (this.isDeep() ? 79 : 97);
        result = result * 59 + (this.isModified() ? 79 : 97);
        String $webDavPath = this.getWebDavPath();
        result = result * 59 + ($webDavPath == null ? 43 : $webDavPath.hashCode());
        String $jcrPath = this.getJcrPath();
        result = result * 59 + ($jcrPath == null ? 43 : $jcrPath.hashCode());
        String $parentWebDavPath = this.getParentWebDavPath();
        result = result * 59 + ($parentWebDavPath == null ? 43 : $parentWebDavPath.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Set<String> $usernames = this.getUsernames();
        result = result * 59 + ($usernames == null ? 43 : ((Object)$usernames).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WebDavItemEntity(webDavPath=" + this.getWebDavPath() + ", jcrPath=" + this.getJcrPath() + ", parentWebDavPath=" + this.getParentWebDavPath() + ", identifier=" + this.getIdentifier() + ", usernames=" + String.valueOf(this.getUsernames()) + ", file=" + this.isFile() + ", deep=" + this.isDeep() + ", modified=" + this.isModified() + ")";
    }

    @Generated
    public WebDavItemEntity() {
    }
}

