/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.util;

import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.webdav.util.PropertyConstants;

public class ACLProperties {
    public static final QName ACL = new QName("DAV:", "acl");
    public static final QName ACE = new QName("DAV:", "ace");
    public static final QName PRINCIPAL = new QName("DAV:", "principal");
    public static final QName ALL = new QName("DAV:", "all");
    public static final QName HREF = new QName("DAV:", "href");
    public static final QName PRIVILEGE = new QName("DAV:", "privilege");
    public static final QName GRANT = new QName("DAV:", "grant");
    public static final QName DENY = new QName("DAV:", "deny");
    public static final QName WRITE = new QName("DAV:", "write");
    public static final QName UNLOCK = new QName("DAV:", "unlock");
    public static final QName READ = new QName("DAV:", "read");

    private ACLProperties() {
    }

    public static WebDavItemProperty getReadOnlyACL() {
        WebDavItemProperty property = new WebDavItemProperty(ACL);
        property.addChild(ACLProperties.computeReadOnlyAceProperty());
        return property;
    }

    public static WebDavItemProperty getACL(NodeImpl node) {
        WebDavItemProperty property = new WebDavItemProperty(ACL);
        property.addChild(ACLProperties.computeAceProperty(node));
        return property;
    }

    public static WebDavItemProperty getOwner(NodeImpl node) throws RepositoryException {
        WebDavItemProperty ownerProperty = new WebDavItemProperty(PropertyConstants.OWNER);
        WebDavItemProperty href = new WebDavItemProperty(new QName("DAV:", "href"));
        href.setValue(node.getACL().getOwner());
        ownerProperty.addChild(href);
        return ownerProperty;
    }

    private static WebDavItemProperty getAllPrincipalProperty() {
        WebDavItemProperty principalProperty = new WebDavItemProperty(PRINCIPAL);
        WebDavItemProperty all = new WebDavItemProperty(ALL);
        principalProperty.addChild(all);
        return principalProperty;
    }

    private static WebDavItemProperty computeReadOnlyAceProperty() {
        WebDavItemProperty aceProperty = new WebDavItemProperty(ACE);
        aceProperty.addChild(ACLProperties.getAllPrincipalProperty());
        WebDavItemProperty grant = aceProperty.addChild(new WebDavItemProperty(GRANT));
        grant.addChild(new WebDavItemProperty(PRIVILEGE)).addChild(new WebDavItemProperty(READ));
        WebDavItemProperty deny = aceProperty.addChild(new WebDavItemProperty(DENY));
        deny.addChild(new WebDavItemProperty(PRIVILEGE)).addChild(new WebDavItemProperty(WRITE));
        return aceProperty;
    }

    private static WebDavItemProperty computeAceProperty(NodeImpl node) {
        WebDavItemProperty privilege;
        WebDavItemProperty aceProperty = new WebDavItemProperty(ACE);
        aceProperty.addChild(ACLProperties.getAllPrincipalProperty());
        WebDavItemProperty grant = new WebDavItemProperty(GRANT);
        aceProperty.addChild(grant);
        if (node.hasPermission("add_node") || node.hasPermission("set_property") || node.hasPermission("remove")) {
            if (node.isLocked()) {
                privilege = new WebDavItemProperty(PRIVILEGE);
                privilege.addChild(new WebDavItemProperty(UNLOCK));
                grant.addChild(privilege);
            }
            privilege = new WebDavItemProperty(PRIVILEGE);
            privilege.addChild(new WebDavItemProperty(WRITE));
            grant.addChild(privilege);
        } else {
            WebDavItemProperty deny = new WebDavItemProperty(DENY);
            WebDavItemProperty privilege2 = new WebDavItemProperty(PRIVILEGE);
            privilege2.addChild(new WebDavItemProperty(WRITE));
            deny.addChild(privilege2);
            aceProperty.addChild(deny);
        }
        if (node.hasPermission("read")) {
            privilege = new WebDavItemProperty(PRIVILEGE);
            privilege.addChild(new WebDavItemProperty(READ));
            grant.addChild(privilege);
        }
        return aceProperty;
    }
}

