/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.constant.FileListingType;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.BreadCrumbItem;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FullTreeItem;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class DocumentFileServiceImpl
implements DocumentFileService {
    private static final Log LOG = ExoLogger.getLogger(DocumentFileServiceImpl.class);
    public static String RENAME_FILE_EVENT = "rename_file_event";
    private DocumentFileStorage documentFileStorage;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private IdentityRegistry identityRegistry;
    private Authenticator authenticator;
    private JCRDeleteFileStorage jcrDeleteFileStorage;
    private ListenerService listenerService;

    public DocumentFileServiceImpl(DocumentFileStorage documentFileStorage, JCRDeleteFileStorage jcrDeleteFileStorage, Authenticator authenticator, SpaceService spaceService, IdentityManager identityManager, IdentityRegistry identityRegistry, ListenerService listenerService) {
        this.documentFileStorage = documentFileStorage;
        this.jcrDeleteFileStorage = jcrDeleteFileStorage;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.identityRegistry = identityRegistry;
        this.authenticator = authenticator;
        this.listenerService = listenerService;
    }

    public List<AbstractNode> getDocumentItems(FileListingType listingType, DocumentNodeFilter filter, int offset, int limit, long userIdentityId, boolean showHiddenFiles) throws IllegalAccessException, ObjectNotFoundException {
        if (filter == null) {
            throw new IllegalArgumentException("File filter is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalAccessException("User Identity is mandatory");
        }
        switch (listingType) {
            case TIMELINE: {
                if (!(filter instanceof DocumentTimelineFilter)) {
                    throw new IllegalArgumentException("filter must be an instance of DocumentTimelineFilter");
                }
                DocumentTimelineFilter timelinefilter = (DocumentTimelineFilter)filter;
                timelinefilter.setIncludeHiddenFiles(showHiddenFiles);
                if (timelinefilter.getOwnerId() == null || timelinefilter.getOwnerId() <= 0L) {
                    throw new IllegalArgumentException("OwnerId is mandatory");
                }
                List<FileNode> files = this.getFilesTimeline(timelinefilter, offset, limit, userIdentityId);
                return new ArrayList<FileNode>(files);
            }
            case FOLDER: {
                if (!(filter instanceof DocumentFolderFilter)) {
                    throw new IllegalArgumentException("filter must be an instance of DocumentFolderFilter");
                }
                DocumentFolderFilter folderFilter = (DocumentFolderFilter)filter;
                folderFilter.setIncludeHiddenFiles(showHiddenFiles);
                if (StringUtils.isBlank((CharSequence)folderFilter.getParentFolderId()) && (folderFilter.getOwnerId() == null || folderFilter.getOwnerId() <= 0L)) {
                    throw new IllegalArgumentException("ParentFolderId or OwnerId is mandatory");
                }
                return this.getFolderChildNodes(folderFilter, offset, limit, userIdentityId);
            }
        }
        return Collections.emptyList();
    }

    public List<FileNode> getFilesTimeline(DocumentTimelineFilter filter, int offset, int limit, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException {
        Identity aclIdentity = this.getAclUserIdentity(userIdentityId);
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        if (ownerIdentity.isSpace()) {
            Space space = this.spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            if (!this.spaceService.hasAccessPermission(space, username)) {
                throw new IllegalAccessException("User " + username + " attempts to access documents of space " + space.getDisplayName() + "while it's not a member");
            }
        } else if (ownerIdentity.isUser() && !StringUtils.equals((CharSequence)ownerIdentity.getRemoteId(), (CharSequence)username)) {
            throw new IllegalAccessException("User " + username + " attempts to access private documents of user " + ownerIdentity.getRemoteId());
        }
        if (filter.getSortField() == null) {
            filter.setSortField(DocumentSortField.MODIFIED_DATE);
        }
        return this.documentFileStorage.getFilesTimeline(filter, aclIdentity, offset, limit);
    }

    public DocumentGroupsSize getGroupDocumentsCount(DocumentTimelineFilter filter, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException {
        Identity aclIdentity = this.getAclUserIdentity(userIdentityId);
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        if (ownerIdentity.isSpace()) {
            Space space = this.spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            if (!this.spaceService.hasAccessPermission(space, username)) {
                throw new IllegalAccessException("User " + username + " attempts to access documents of space " + space.getDisplayName() + "while it's not a member");
            }
        } else if (ownerIdentity.isUser() && !StringUtils.equals((CharSequence)ownerIdentity.getRemoteId(), (CharSequence)username)) {
            throw new IllegalAccessException("User " + username + " attempts to access private documents of user " + ownerIdentity.getRemoteId());
        }
        if (filter.getSortField() == null) {
            filter.setSortField(DocumentSortField.MODIFIED_DATE);
        }
        return this.documentFileStorage.getGroupDocumentsCount(filter, aclIdentity);
    }

    public List<AbstractNode> getFolderChildNodes(DocumentFolderFilter filter, int offset, int limit, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException {
        Identity aclIdentity = this.getAclUserIdentity(userIdentityId);
        if (StringUtils.isBlank((CharSequence)filter.getParentFolderId())) {
            Space space;
            String username = aclIdentity.getUserId();
            Long ownerId = filter.getOwnerId();
            String userId = filter.getUserId();
            org.exoplatform.social.core.identity.model.Identity ownerIdentity = null;
            ownerIdentity = StringUtils.isNotEmpty((CharSequence)userId) ? this.identityManager.getOrCreateUserIdentity(userId) : this.identityManager.getIdentity(String.valueOf(ownerId));
            if (ownerIdentity == null) {
                throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
            }
            if (ownerIdentity.isSpace() && !this.spaceService.hasAccessPermission(space = this.spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId()), username)) {
                throw new IllegalAccessException("User " + username + " attempts to access documents of space " + space.getDisplayName() + "while it's not a member");
            }
        }
        if (filter.getSortField() == null) {
            filter.setSortField(DocumentSortField.NAME);
        }
        return this.documentFileStorage.getFolderChildNodes(filter, aclIdentity, offset, limit);
    }

    public List<BreadCrumbItem> getBreadcrumb(long ownerId, String folderId, String folderPath, long authenticatedUserId) throws IllegalAccessException, ObjectNotFoundException {
        return this.documentFileStorage.getBreadcrumb(ownerId, folderId, folderPath, this.getAclUserIdentity(authenticatedUserId));
    }

    public List<FullTreeItem> getFullTreeData(long ownerId, String folderId, long authenticatedUserId) throws IllegalAccessException, ObjectNotFoundException {
        return this.documentFileStorage.getFullTreeData(ownerId, folderId, this.getAclUserIdentity(authenticatedUserId));
    }

    public AbstractNode duplicateDocument(long ownerId, String fileId, String prefixClone, long authenticatedUserId) throws IllegalAccessException, ObjectNotFoundException {
        return this.documentFileStorage.duplicateDocument(ownerId, fileId, prefixClone, this.getAclUserIdentity(authenticatedUserId));
    }

    public void moveDocument(long ownerId, String fileId, String destPath, long authenticatedUserId, String conflictAction) throws IllegalAccessException, ObjectNotFoundException, ObjectAlreadyExistsException {
        this.documentFileStorage.moveDocument(ownerId, fileId, destPath, this.getAclUserIdentity(authenticatedUserId), conflictAction);
    }

    public AbstractNode createFolder(long ownerId, String folderId, String folderPath, String name, long authenticatedUserId) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        return this.documentFileStorage.createFolder(ownerId, folderId, folderPath, name, this.getAclUserIdentity(authenticatedUserId));
    }

    public String getNewName(long ownerId, String folderId, String folderPath, String name) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        return this.documentFileStorage.getNewName(ownerId, folderId, folderPath, name);
    }

    public void renameDocument(long ownerId, String documentID, String name, long authenticatedUserId) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        this.documentFileStorage.renameDocument(ownerId, documentID, name, this.getAclUserIdentity(authenticatedUserId));
        try {
            this.listenerService.broadcast(RENAME_FILE_EVENT, (Object)this, (Object)documentID);
        }
        catch (Exception e) {
            LOG.error((Object)"cannot broadcast rename_file_event");
        }
    }

    public void deleteDocument(String folderPath, String documentId, boolean favorite, long delay, long authenticatedUserId) throws IllegalAccessException {
        this.jcrDeleteFileStorage.deleteDocument(folderPath, documentId, favorite, true, delay, this.getAclUserIdentity(authenticatedUserId), authenticatedUserId);
    }

    public void undoDeleteDocument(String documentId, long authenticatedUserId) {
        this.jcrDeleteFileStorage.undoDelete(documentId, authenticatedUserId);
    }

    public void updatePermissions(String documentId, NodePermission nodePermissionEntity, long authenticatedUserId) throws IllegalAccessException {
        this.documentFileStorage.updatePermissions(documentId, nodePermissionEntity, this.getAclUserIdentity(authenticatedUserId));
        nodePermissionEntity.getToShare().keySet().forEach(destId -> {
            try {
                this.shareDocument(documentId, (long)destId);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Error updating sharing of document'" + documentId + " to identity " + destId, e);
            }
        });
        if (nodePermissionEntity.getToNotify() != null) {
            nodePermissionEntity.getToNotify().keySet().forEach(destId -> {
                try {
                    this.notifyMember(documentId, (long)destId);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Error updating sharing of document'" + documentId + " to identity " + destId, e);
                }
            });
        }
    }

    public void shareDocument(String documentId, long destId) throws IllegalAccessException {
        this.documentFileStorage.shareDocument(documentId, destId);
    }

    public void notifyMember(String documentId, long destId) throws IllegalAccessException {
        this.documentFileStorage.notifyMember(documentId, destId);
    }

    public boolean canAccess(String documentID, Identity aclIdentity) throws RepositoryException {
        return this.documentFileStorage.canAccess(documentID, aclIdentity);
    }

    private Identity getAclUserIdentity(long userIdentityId) throws IllegalAccessException {
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalAccessException("Can't find user identity with id " + userIdentityId);
        }
        String username = userIdentity.getRemoteId();
        Identity aclIdentity = this.identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            try {
                aclIdentity = this.authenticator.createIdentity(username);
            }
            catch (Exception e) {
                throw new IllegalAccessException("Error retrieving user ACL identity with name : " + username);
            }
        }
        return aclIdentity;
    }

    public Identity getAclUserIdentity(String username) throws IllegalAccessException {
        Identity aclIdentity = this.identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            try {
                aclIdentity = this.authenticator.createIdentity(username);
            }
            catch (Exception e) {
                throw new IllegalAccessException("Error retrieving user ACL identity with name : " + username);
            }
        }
        return aclIdentity;
    }

    public void updateDocumentDescription(long ownerId, String documentID, String description, long aclIdentity) throws IllegalStateException, IllegalAccessException, RepositoryException {
        this.documentFileStorage.updateDocumentDescription(ownerId, documentID, description, this.getAclUserIdentity(aclIdentity));
    }

    public void createShortcut(String documentId, String destPath, String aclIdentity, String conflictAction) throws IllegalAccessException, ObjectAlreadyExistsException {
        this.documentFileStorage.createShortcut(documentId, destPath, aclIdentity, conflictAction);
    }

    public List<FileVersion> getFileVersions(String fileNodeId, String aclIdentity) {
        if (fileNodeId == null) {
            throw new IllegalArgumentException("file node id is mandatory");
        }
        return this.documentFileStorage.getFileVersions(fileNodeId, aclIdentity);
    }

    public FileVersion updateVersionSummary(String originFileId, String versionId, String summary, String aclIdentity) {
        if (versionId == null) {
            throw new IllegalArgumentException("version id is mandatory");
        }
        if (originFileId == null) {
            throw new IllegalArgumentException("original file id is mandatory");
        }
        return this.documentFileStorage.updateVersionSummary(originFileId, versionId, summary, aclIdentity);
    }

    public FileVersion restoreVersion(String versionId, String aclIdentity) {
        if (versionId == null) {
            throw new IllegalArgumentException("version id is mandatory");
        }
        return this.documentFileStorage.restoreVersion(versionId, aclIdentity);
    }

    public boolean canAddDocument(String spaceId, String currentUserName) {
        Space space = this.spaceService.getSpaceById(spaceId);
        boolean canAdd = false;
        if (space != null) {
            canAdd = !this.spaceService.hasRedactor(space) || this.spaceService.hasRedactor(space) && (this.spaceService.isRedactor(space, currentUserName) || this.spaceService.isManager(space, currentUserName));
        }
        return canAdd;
    }
}

