/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.plugin;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AddDocumentCollaboratorPlugin
extends BaseNotificationPlugin {
    public static final String ID = "AddDocumentCollaboratorPlugin";
    private final SpaceService spaceService;

    public AddDocumentCollaboratorPlugin(InitParams initParams, SpaceService spaceService) {
        super(initParams);
        this.spaceService = spaceService;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext notificationContext) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext notificationContext) {
        LinkedList<String> receivers;
        String fromUser = (String)notificationContext.value(NotificationConstants.FROM_USER);
        String target = (String)notificationContext.value(NotificationConstants.RECEIVERS);
        Space space = this.spaceService.getSpaceByPrettyName(target);
        if (space != null) {
            receivers = new LinkedList<String>(Arrays.asList(space.getMembers()));
            receivers.remove(fromUser);
        } else {
            receivers = new LinkedList<String>(List.of(target));
        }
        String documentUrl = (String)notificationContext.value(NotificationConstants.DOCUMENT_URL);
        String documentName = (String)notificationContext.value(NotificationConstants.DOCUMENT_NAME);
        return NotificationInfo.instance().setFrom(fromUser).to(receivers).with(NotificationConstants.FROM_USER.getKey(), fromUser).with(NotificationConstants.DOCUMENT_URL.getKey(), documentUrl).with(NotificationConstants.DOCUMENT_NAME.getKey(), documentName).key(this.getKey()).end();
    }
}

