/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.documents.model.DownloadItem;
import org.exoplatform.documents.model.PublicDocumentAccess;
import org.exoplatform.documents.service.ExternalDownloadService;
import org.exoplatform.documents.service.PublicDocumentAccessService;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.QualifiedName;
import org.json.JSONObject;

public class PublicAccessDownloadDocumentHandler
extends JspBasedWebHandler {
    private ServletContext servletContext;
    private static final QualifiedName NODE_ID = QualifiedName.create((String)"gtn", (String)"nodeId");
    private static final String DOWNLOAD_DOCUMENT_JSP_PATH = "public.download.jsp.path";
    private static final String NAME = "download-document";
    private final PublicDocumentAccessService publicDocumentAccessService;
    private final ExternalDownloadService externalDownloadService;
    private String publicDownloadJspPath;

    public PublicAccessDownloadDocumentHandler(PortalContainer container, PublicDocumentAccessService publicDocumentAccessService, ExternalDownloadService externalDownloadService, LocaleConfigService localeConfigService, BrandingService brandingService, JavascriptConfigService javascriptConfigService, SkinService skinService, InitParams initParams) {
        super(localeConfigService, brandingService, javascriptConfigService, skinService);
        this.publicDocumentAccessService = publicDocumentAccessService;
        this.externalDownloadService = externalDownloadService;
        this.servletContext = container.getPortalContext();
        if (initParams != null && initParams.containsKey((Object)DOWNLOAD_DOCUMENT_JSP_PATH)) {
            this.publicDownloadJspPath = initParams.getValueParam(DOWNLOAD_DOCUMENT_JSP_PATH).getValue();
        }
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpServletRequest request = controllerContext.getRequest();
        HttpServletResponse response = controllerContext.getResponse();
        String nodeId = controllerContext.getParameter(NODE_ID);
        DownloadItem downloadItem = this.externalDownloadService.getDocumentDownloadItem(nodeId);
        PublicDocumentAccess publicDocumentAccess = this.publicDocumentAccessService.getPublicDocumentAccess(nodeId);
        boolean hasPublicLink = publicDocumentAccess != null;
        boolean isAccessLocked = hasPublicLink && publicDocumentAccess.getPasswordHashKey() != null;
        boolean isAccessExpired = this.publicDocumentAccessService.isPublicDocumentAccessExpired(nodeId);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("nodeId", nodeId);
        parameters.put("hasPublicLink", hasPublicLink);
        parameters.put("isAccessLocked", isAccessLocked);
        parameters.put("isAccessExpired", isAccessExpired);
        if (downloadItem != null) {
            parameters.put("documentName", downloadItem.getItemName());
            parameters.put("documentType", downloadItem.getMimeType());
        }
        return this.dispatch(controllerContext, request, response, parameters);
    }

    public String getHandlerName() {
        return NAME;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    protected void extendApplicationParameters(JSONObject applicationParameters, Map<String, Object> additionalParameters) {
        additionalParameters.forEach((arg_0, arg_1) -> ((JSONObject)applicationParameters).put(arg_0, arg_1));
    }

    private boolean dispatch(ControllerContext controllerContext, HttpServletRequest request, HttpServletResponse response, Map<String, Object> parameters) throws Exception {
        super.prepareDispatch(controllerContext, "PORTLET/documents-portlet/DownloadDocumentsPublicAccess", Collections.emptyList(), Collections.singletonList("portal/login"), params -> this.extendApplicationParameters((JSONObject)params, parameters));
        this.servletContext.getRequestDispatcher(this.publicDownloadJspPath).include((ServletRequest)request, (ServletResponse)response);
        return true;
    }
}

