/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.provider;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.documents.notification.utils.NotificationUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="AddDocumentCollaboratorPlugin", template="war:/notification/templates/mail/AddDocumentCollaboratorPlugin.gtmpl"), @TemplateConfig(pluginId="ImportDocumentsPlugin", template="war:/notification/templates/mail/ImportDocumentsPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    private final IdentityManager identityManager;

    public MailTemplateProvider(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"AddDocumentCollaboratorPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"ImportDocumentsPlugin"), new TemplateBuilder());
        this.identityManager = identityManager;
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            String fromUser = notificationInfo.getValueOwnerParameter(NotificationConstants.FROM_USER.getKey());
            String documentUrl = notificationInfo.getValueOwnerParameter(NotificationConstants.DOCUMENT_URL.getKey());
            String documentName = notificationInfo.getValueOwnerParameter(NotificationConstants.DOCUMENT_NAME.getKey());
            String folderUrl = notificationInfo.getValueOwnerParameter(NotificationConstants.FOLDER_URL.getKey());
            String folderName = notificationInfo.getValueOwnerParameter(NotificationConstants.FOLDER_NAME.getKey());
            String totalNumber = notificationInfo.getValueOwnerParameter(NotificationConstants.TOTAL_NUMBER.getKey());
            String duration = notificationInfo.getValueOwnerParameter(NotificationConstants.DURATION.getKey());
            String filesCreated = notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_CREATED.getKey());
            String filesDuplicated = notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_DUPLICATED.getKey());
            String filesUpdated = notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_UPDATED.getKey());
            String filesIgnored = notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_IGNORED.getKey());
            String filesFailed = notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_FAILED.getKey());
            String language = this.getLanguage(notificationInfo);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)MailTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            templateContext.put((Object)"DOCUMENT_URL", (Object)documentUrl);
            templateContext.put((Object)"DOCUMENT_NAME", (Object)documentName);
            templateContext.put((Object)"FOLDER_URL", (Object)folderUrl);
            templateContext.put((Object)"TOTAL_NUMBER", (Object)totalNumber);
            templateContext.put((Object)"FOLDER_NAME", (Object)folderName);
            templateContext.put((Object)"DURATION", (Object)duration);
            templateContext.put((Object)"FILES_CREATED", (Object)filesCreated);
            templateContext.put((Object)"FILES_DUPLICATED", (Object)filesDuplicated);
            templateContext.put((Object)"FILES_UPDATED", (Object)filesUpdated);
            templateContext.put((Object)"FILES_IGNORED", (Object)filesIgnored);
            templateContext.put((Object)"FILES_FAILED", (Object)filesFailed);
            Profile userProfile = NotificationUtils.getUserProfile(MailTemplateProvider.this.identityManager, fromUser);
            templateContext.put((Object)"USER", (Object)encoder.encode(userProfile.getFullName()));
            templateContext.put((Object)"PROFILE_URL", (Object)encoder.encode(userProfile.getUrl()));
            templateContext.put((Object)"AVATAR", (Object)encoder.encode(LinkProviderUtils.getUserAvatarUrl((Profile)userProfile)));
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notificationInfo.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            boolean isRead = Boolean.parseBoolean(notificationInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()));
            templateContext.put((Object)"READ", (Object)(isRead ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notificationInfo.getId());
            Identity receiver = MailTemplateProvider.this.identityManager.getOrCreateIdentity("organization", notificationInfo.getTo());
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }
}

