/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.service;

import io.meeds.analytics.api.service.AnalyticsService;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.model.filter.AnalyticsFilter;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.constant.FileListingType;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.BreadCrumbItem;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.model.DocumentsSize;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FullTreeItem;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.TrashElementNode;
import org.exoplatform.documents.model.TrashElementNodeFilter;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class DocumentFileServiceImpl
implements DocumentFileService {
    private static final Log LOG = ExoLogger.getLogger(DocumentFileServiceImpl.class);
    public static String RENAME_FILE_EVENT = "rename_file_event";
    private DocumentFileStorage documentFileStorage;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private IdentityRegistry identityRegistry;
    private Authenticator authenticator;
    private JCRDeleteFileStorage jcrDeleteFileStorage;
    private ListenerService listenerService;
    private SettingService settingService;
    private AnalyticsService analyticsService;
    private static final Scope DOCUMENTS_USER_SETTING_SCOPE = Scope.APPLICATION.id("Documents");
    private static final String DOCUMENTS_USER_SETTING_KEY = "DocumentsSettings";
    String dateFormat = "MM-dd-yyyy";
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFormat);

    public DocumentFileServiceImpl(DocumentFileStorage documentFileStorage, JCRDeleteFileStorage jcrDeleteFileStorage, Authenticator authenticator, SpaceService spaceService, IdentityManager identityManager, IdentityRegistry identityRegistry, ListenerService listenerService, SettingService settingService, AnalyticsService analyticsService) {
        this.documentFileStorage = documentFileStorage;
        this.jcrDeleteFileStorage = jcrDeleteFileStorage;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.identityRegistry = identityRegistry;
        this.authenticator = authenticator;
        this.listenerService = listenerService;
        this.settingService = settingService;
        this.analyticsService = analyticsService;
    }

    public List<AbstractNode> getDocumentItems(FileListingType listingType, DocumentNodeFilter filter, int offset, int limit, long userIdentityId, boolean showHiddenFiles) throws IllegalAccessException, ObjectNotFoundException {
        if (filter == null) {
            throw new IllegalArgumentException("File filter is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalAccessException("User Identity is mandatory");
        }
        switch (listingType) {
            case TIMELINE: {
                if (!(filter instanceof DocumentTimelineFilter)) {
                    throw new IllegalArgumentException("filter must be an instance of DocumentTimelineFilter");
                }
                DocumentTimelineFilter timelinefilter = (DocumentTimelineFilter)filter;
                timelinefilter.setIncludeHiddenFiles(showHiddenFiles);
                if (timelinefilter.getOwnerId() == null || timelinefilter.getOwnerId() <= 0L) {
                    throw new IllegalArgumentException("OwnerId is mandatory");
                }
                List<FileNode> files = this.getFilesTimeline(timelinefilter, offset, limit, userIdentityId);
                return new ArrayList<FileNode>(files);
            }
            case FOLDER: {
                if (!(filter instanceof DocumentFolderFilter)) {
                    throw new IllegalArgumentException("filter must be an instance of DocumentFolderFilter");
                }
                DocumentFolderFilter folderFilter = (DocumentFolderFilter)filter;
                folderFilter.setIncludeHiddenFiles(showHiddenFiles);
                if (StringUtils.isBlank((CharSequence)folderFilter.getParentFolderId()) && (folderFilter.getOwnerId() == null || folderFilter.getOwnerId() <= 0L)) {
                    throw new IllegalArgumentException("ParentFolderId or OwnerId is mandatory");
                }
                return this.getFolderChildNodes(folderFilter, offset, limit, userIdentityId);
            }
        }
        return Collections.emptyList();
    }

    public List<FileNode> getFilesTimeline(DocumentTimelineFilter filter, int offset, int limit, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException {
        Identity aclIdentity = this.getAclUserIdentity(userIdentityId);
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        if (ownerIdentity.isSpace()) {
            Space space = this.spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            if (!this.spaceService.hasAccessPermission(space, username)) {
                throw new IllegalAccessException("User " + username + " attempts to access documents of space " + space.getDisplayName() + "while it's not a member");
            }
        } else if (ownerIdentity.isUser() && !StringUtils.equals((CharSequence)ownerIdentity.getRemoteId(), (CharSequence)username)) {
            throw new IllegalAccessException("User " + username + " attempts to access private documents of user " + ownerIdentity.getRemoteId());
        }
        if (filter.getSortField() == null) {
            filter.setSortField(DocumentSortField.MODIFIED_DATE);
        }
        return this.documentFileStorage.getFilesTimeline(filter, aclIdentity, offset, limit);
    }

    public List<AbstractNode> getBiggestDocuments(long ownerId, org.exoplatform.social.core.identity.model.Identity userIdentity, int offset, int limit) throws IllegalAccessException, ObjectNotFoundException {
        Identity aclIdentity = this.getAclUserIdentity(userIdentity.getRemoteId());
        return this.documentFileStorage.getBiggestDocuments(Long.valueOf(ownerId), aclIdentity, offset, limit);
    }

    public DocumentGroupsSize getGroupDocumentsCount(DocumentTimelineFilter filter, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException {
        Identity aclIdentity = this.getAclUserIdentity(userIdentityId);
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        if (ownerIdentity.isSpace()) {
            Space space = this.spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            if (!this.spaceService.hasAccessPermission(space, username)) {
                throw new IllegalAccessException("User " + username + " attempts to access documents of space " + space.getDisplayName() + "while it's not a member");
            }
        } else if (ownerIdentity.isUser() && !StringUtils.equals((CharSequence)ownerIdentity.getRemoteId(), (CharSequence)username)) {
            throw new IllegalAccessException("User " + username + " attempts to access private documents of user " + ownerIdentity.getRemoteId());
        }
        if (filter.getSortField() == null) {
            filter.setSortField(DocumentSortField.MODIFIED_DATE);
        }
        return this.documentFileStorage.getGroupDocumentsCount(filter, aclIdentity);
    }

    public List<AbstractNode> getFolderChildNodes(DocumentFolderFilter filter, int offset, int limit, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException {
        Identity aclIdentity = this.getAclUserIdentity(userIdentityId);
        if (StringUtils.isBlank((CharSequence)filter.getParentFolderId())) {
            Space space;
            String username = aclIdentity.getUserId();
            Long ownerId = filter.getOwnerId();
            String userId = filter.getUserId();
            org.exoplatform.social.core.identity.model.Identity ownerIdentity = null;
            ownerIdentity = StringUtils.isNotEmpty((CharSequence)userId) ? this.identityManager.getOrCreateUserIdentity(userId) : this.identityManager.getIdentity(String.valueOf(ownerId));
            if (ownerIdentity == null) {
                throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
            }
            if (ownerIdentity.isSpace() && !this.spaceService.hasAccessPermission(space = this.spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId()), username)) {
                throw new IllegalAccessException("User " + username + " attempts to access documents of space " + space.getDisplayName() + "while it's not a member");
            }
        }
        if (filter.getSortField() == null) {
            filter.setSortField(DocumentSortField.NAME);
        }
        return this.documentFileStorage.getFolderChildNodes(filter, aclIdentity, offset, limit);
    }

    public List<BreadCrumbItem> getBreadcrumb(long ownerId, String folderId, String folderPath, long authenticatedUserId) throws IllegalAccessException, ObjectNotFoundException {
        return this.documentFileStorage.getBreadcrumb(ownerId, folderId, folderPath, this.getAclUserIdentity(authenticatedUserId));
    }

    public List<FullTreeItem> getFullTreeData(long ownerId, String folderId, long authenticatedUserId, boolean withChildren) throws IllegalAccessException, ObjectNotFoundException {
        return this.documentFileStorage.getFullTreeData(ownerId, folderId, this.getAclUserIdentity(authenticatedUserId), withChildren);
    }

    public AbstractNode duplicateDocument(long ownerId, String fileId, String prefixClone, long authenticatedUserId) throws IllegalAccessException, ObjectNotFoundException {
        return this.documentFileStorage.duplicateDocument(ownerId, fileId, prefixClone, this.getAclUserIdentity(authenticatedUserId));
    }

    public void moveDocument(long ownerId, String fileId, String destPath, long authenticatedUserId, String conflictAction) throws IllegalAccessException, ObjectNotFoundException, ObjectAlreadyExistsException {
        this.documentFileStorage.moveDocument(ownerId, fileId, destPath, this.getAclUserIdentity(authenticatedUserId), conflictAction);
    }

    public AbstractNode createFolder(long ownerId, String folderId, String folderPath, String name, long authenticatedUserId) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        return this.documentFileStorage.createFolder(ownerId, folderId, folderPath, name, this.getAclUserIdentity(authenticatedUserId));
    }

    public String getNewName(long ownerId, String folderId, String folderPath, String name) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        return this.documentFileStorage.getNewName(ownerId, folderId, folderPath, name);
    }

    public void renameDocument(long ownerId, String documentID, String name, long authenticatedUserId) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        this.documentFileStorage.renameDocument(ownerId, documentID, name, this.getAclUserIdentity(authenticatedUserId));
        try {
            this.listenerService.broadcast(RENAME_FILE_EVENT, (Object)this, (Object)documentID);
        }
        catch (Exception e) {
            LOG.error((Object)"cannot broadcast rename_file_event");
        }
    }

    public void deleteDocument(String folderPath, String documentId, boolean favorite, long delay, long authenticatedUserId) throws IllegalAccessException {
        this.jcrDeleteFileStorage.deleteDocument(folderPath, documentId, favorite, true, delay, this.getAclUserIdentity(authenticatedUserId), authenticatedUserId);
    }

    public void undoDeleteDocument(String documentId, long authenticatedUserId) {
        this.jcrDeleteFileStorage.undoDelete(documentId, authenticatedUserId);
    }

    public void deleteDocuments(int actionId, List<AbstractNode> documents, long authenticatedUserId) throws IllegalAccessException {
        this.jcrDeleteFileStorage.deleteDocuments(actionId, documents, this.getAclUserIdentity(authenticatedUserId), authenticatedUserId);
    }

    public void downloadDocuments(int actionId, List<AbstractNode> documents, long authenticatedUserId) throws IllegalAccessException {
        this.documentFileStorage.downloadDocuments(actionId, documents, this.getAclUserIdentity(authenticatedUserId), authenticatedUserId);
    }

    public void updatePermissions(String documentId, NodePermission nodePermissionEntity, long authenticatedUserId) throws IllegalAccessException {
        this.documentFileStorage.updatePermissions(documentId, nodePermissionEntity, this.getAclUserIdentity(authenticatedUserId));
        nodePermissionEntity.getToShare().keySet().forEach(destId -> {
            try {
                boolean notifyMember = nodePermissionEntity.getToNotify() != null && nodePermissionEntity.getToNotify().containsKey(destId);
                this.shareDocument(documentId, (long)destId, authenticatedUserId, notifyMember);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Error updating sharing of document'" + documentId + " to identity " + destId, e);
            }
        });
        if (nodePermissionEntity.getToUnShare() != null) {
            nodePermissionEntity.getToUnShare().keySet().forEach(destId -> {
                try {
                    this.unShareDocument(documentId, (long)destId);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error when unsharing the document " + documentId + "with identity " + destId, e);
                }
            });
        }
    }

    public void shareDocument(String documentId, long destId, long authenticatedUserId, boolean notifyMember) throws IllegalAccessException {
        this.documentFileStorage.shareDocument(documentId, destId, this.getAclUserIdentity(authenticatedUserId), notifyMember);
    }

    public void unShareDocument(String documentId, long destId) throws RepositoryException {
        this.documentFileStorage.unShareDocument(documentId, destId);
    }

    public void notifyMember(String documentId, long destId) throws IllegalAccessException {
        this.documentFileStorage.notifyMember(documentId, destId);
    }

    public boolean canAccess(String documentID, Identity aclIdentity) throws RepositoryException {
        return this.documentFileStorage.canAccess(documentID, aclIdentity);
    }

    private Identity getAclUserIdentity(long userIdentityId) throws IllegalAccessException {
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalAccessException("Can't find user identity with id " + userIdentityId);
        }
        String username = userIdentity.getRemoteId();
        Identity aclIdentity = this.identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            try {
                aclIdentity = this.authenticator.createIdentity(username);
            }
            catch (Exception e) {
                throw new IllegalAccessException("Error retrieving user ACL identity with name : " + username);
            }
        }
        return aclIdentity;
    }

    public Identity getAclUserIdentity(String username) throws IllegalAccessException {
        Identity aclIdentity = this.identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            try {
                aclIdentity = this.authenticator.createIdentity(username);
            }
            catch (Exception e) {
                throw new IllegalAccessException("Error retrieving user ACL identity with name : " + username);
            }
        }
        return aclIdentity;
    }

    public void updateDocumentDescription(long ownerId, String documentID, String description, long aclIdentity) throws IllegalStateException, IllegalAccessException, RepositoryException {
        this.documentFileStorage.updateDocumentDescription(ownerId, documentID, description, this.getAclUserIdentity(aclIdentity));
    }

    public void createShortcut(String documentId, String destPath, String aclIdentity, String conflictAction) throws IllegalAccessException, ObjectAlreadyExistsException {
        this.documentFileStorage.createShortcut(documentId, destPath, aclIdentity, conflictAction);
    }

    public List<FileVersion> getFileVersions(String fileNodeId, String aclIdentity) {
        if (fileNodeId == null) {
            throw new IllegalArgumentException("file node id is mandatory");
        }
        return this.documentFileStorage.getFileVersions(fileNodeId, aclIdentity);
    }

    public FileVersion updateVersionSummary(String originFileId, String versionId, String summary, String aclIdentity) {
        if (versionId == null) {
            throw new IllegalArgumentException("version id is mandatory");
        }
        if (originFileId == null) {
            throw new IllegalArgumentException("original file id is mandatory");
        }
        return this.documentFileStorage.updateVersionSummary(originFileId, versionId, summary, aclIdentity);
    }

    public FileVersion restoreVersion(String versionId, String aclIdentity) {
        if (versionId == null) {
            throw new IllegalArgumentException("version id is mandatory");
        }
        return this.documentFileStorage.restoreVersion(versionId, aclIdentity);
    }

    public boolean canAddDocument(String spaceId, String currentUserName) {
        Space space = this.spaceService.getSpaceById(spaceId);
        boolean canAdd = false;
        if (space != null) {
            canAdd = !this.spaceService.hasRedactor(space) || this.spaceService.hasRedactor(space) && (this.spaceService.isRedactor(space, currentUserName) || this.spaceService.isManager(space, currentUserName));
        }
        return canAdd;
    }

    public byte[] getDownloadZipBytes(int actionId, String userName) throws IOException {
        return this.documentFileStorage.getDownloadZipBytes(actionId, userName);
    }

    public void cancelBulkAction(String actionId, String userName) throws IOException {
        this.documentFileStorage.cancelBulkAction(actionId, userName);
    }

    public FileVersion createNewVersion(String nodeId, String aclIdentity, InputStream newContent) {
        if (nodeId == null) {
            throw new IllegalArgumentException("node id is mandatory");
        }
        if (aclIdentity == null) {
            throw new IllegalArgumentException("User identity id is mandatory");
        }
        return this.documentFileStorage.createNewVersion(nodeId, aclIdentity, newContent);
    }

    public void moveDocuments(int actionId, long ownerId, List<AbstractNode> documents, String destPath, long userIdentityId) throws IllegalAccessException {
        this.documentFileStorage.moveDocuments(actionId, ownerId, documents, destPath, this.getAclUserIdentity(userIdentityId), userIdentityId);
    }

    public String getDefaultView(Long ownerId, String userIdentityId) {
        SettingValue settingValue = this.settingService.get(Context.USER.id(userIdentityId), DOCUMENTS_USER_SETTING_SCOPE, "DocumentsSettings_" + ownerId);
        if (settingValue == null || settingValue.getValue() == null || StringUtils.isBlank((CharSequence)settingValue.getValue().toString())) {
            return null;
        }
        return settingValue.getValue().toString();
    }

    public boolean canImport(Identity identity) {
        return this.documentFileStorage.canImport(identity);
    }

    public DocumentsSize getDocumentsSizeStat(long ownerId, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException {
        Space space;
        org.exoplatform.social.core.identity.model.Identity currentUserIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        if (ownerIdentity.isUser() && ownerId != userIdentityId) {
            throw new IllegalAccessException("Current user with identity id : " + userIdentityId + " attempts to get the size of private documents of user  with identity id  " + ownerId);
        }
        if (ownerIdentity.isSpace() && !this.spaceService.hasAccessPermission(space = this.spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId()), currentUserIdentity.getRemoteId())) {
            throw new IllegalAccessException("Current user with identity id : " + userIdentityId + " attempts to get size of documents of space with identity id " + ownerId + " while it's not a member");
        }
        DocumentsSize documentsSize = new DocumentsSize();
        LocalDate toLocalDate = LocalDate.now();
        LocalDate fromLocalDate = toLocalDate.minusDays(30L);
        LocalDateTime from = fromLocalDate.atTime(LocalTime.MIN);
        LocalDateTime to = toLocalDate.atTime(LocalTime.MAX);
        AnalyticsFilter filter = new AnalyticsFilter();
        filter.addEqualFilter("ownerId", String.valueOf(ownerId));
        filter.addEqualFilter("operation", "documentsSize");
        ZonedDateTime zdtStart = ZonedDateTime.of(from, ZoneId.systemDefault());
        ZonedDateTime zdtEnd = ZonedDateTime.of(to, ZoneId.systemDefault());
        filter.addRangeFilter("timestamp", String.valueOf(zdtStart.toInstant().toEpochMilli()), String.valueOf(zdtEnd.toInstant().toEpochMilli()));
        List stats = this.analyticsService.retrieveData(filter);
        if (!stats.isEmpty()) {
            StatisticData toStat = (StatisticData)stats.get(0);
            stats.stream().sorted(Comparator.comparing(StatisticData::getTimestamp)).toList();
            documentsSize.setOwnerId(ownerId);
            documentsSize.setToSize(Long.parseLong((String)toStat.getParameters().get("size")));
            documentsSize.setToSizeDate(toStat.getTimestamp());
            documentsSize.setTodaySize(this.simpleDateFormat.format(new Date()).equals(this.simpleDateFormat.format(new Date(toStat.getTimestamp()))));
            if (stats.size() > 1) {
                StatisticData fromStat = (StatisticData)stats.get(stats.size() - 1);
                documentsSize.setFromSize(Long.parseLong((String)fromStat.getParameters().get("size")));
                documentsSize.setFromSizeDate(fromStat.getTimestamp());
                LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(fromStat.getTimestamp()), ZoneId.systemDefault());
                long diff = ChronoUnit.DAYS.between(date, to);
                documentsSize.setDiffDays(diff);
            }
        }
        return documentsSize;
    }

    public DocumentsSize addDocumentsSizeStat(long ownerId, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException {
        org.exoplatform.social.core.identity.model.Identity currentUserIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        StatisticData statisticData = new StatisticData();
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        if (ownerIdentity.isUser()) {
            if (ownerId != userIdentityId) {
                throw new IllegalAccessException("Current user with identity id : " + userIdentityId + " attempts to calculate the size of private documents of user  with identity id  " + ownerId);
            }
            statisticData.setUserId(userIdentityId);
        }
        if (ownerIdentity.isSpace()) {
            Space space = this.spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            statisticData.addParameter("spaceId", (Object)space.getId());
            if (!this.spaceService.hasAccessPermission(space, currentUserIdentity.getRemoteId())) {
                throw new IllegalAccessException("Current user with identity id : " + userIdentityId + " attempts to calculate size of documents of space with identity id " + ownerId + " while it's not a member");
            }
        }
        Identity aclIdentity = this.getAclUserIdentity(userIdentityId);
        long size = this.documentFileStorage.calculateFilesSize(Long.valueOf(ownerId), aclIdentity);
        statisticData.setModule("Drive");
        statisticData.setSubModule("Documents");
        statisticData.setOperation("documentsSize");
        statisticData.setTimestamp(new Date().getTime());
        statisticData.addParameter("ownerId", (Object)ownerId);
        statisticData.addParameter("size", (Object)size);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        DocumentsSize documentsSize = this.getDocumentsSizeStat(ownerId, userIdentityId);
        documentsSize.setTodaySize(true);
        documentsSize.setToSize(size);
        return documentsSize;
    }

    public void setDefaultView(Long ownerId, String userIdentityId, String view) {
        if (Long.parseLong(userIdentityId) <= 0L) {
            throw new IllegalArgumentException("User identity id is mandatory");
        }
        if (ownerId <= 0L) {
            throw new IllegalArgumentException("Owner id is mandatory");
        }
        this.settingService.set(Context.USER.id(userIdentityId), DOCUMENTS_USER_SETTING_SCOPE, "DocumentsSettings_" + ownerId, SettingValue.create((String)view));
    }

    public boolean hasEditPermissionOnDocument(String nodeId, long userIdentityId) throws IllegalAccessException {
        return this.documentFileStorage.hasEditPermissions(nodeId, this.getAclUserIdentity(userIdentityId));
    }

    public void importFiles(String ownerId, String folderId, String folderPath, String uploadId, String conflict, Identity identity, long authenticatedUserId) throws Exception {
        String userName = "";
        Space space = null;
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        if (ownerIdentity.isSpace()) {
            space = this.spaceService.getSpaceByPrettyName(ownerIdentity.getRemoteId());
            if (!this.spaceService.hasAccessPermission(space, identity.getUserId())) {
                throw new IllegalAccessException("User " + identity.getUserId() + " attempts to access documents of space " + space.getDisplayName() + " while it's not a member");
            }
        } else if (ownerIdentity.isUser()) {
            if (!StringUtils.equals((CharSequence)ownerIdentity.getRemoteId(), (CharSequence)identity.getUserId())) {
                throw new IllegalAccessException("User " + identity.getUserId() + " attempts to access private documents of user " + ownerIdentity.getRemoteId());
            }
            userName = ownerIdentity.getRemoteId();
        }
        this.documentFileStorage.importFiles(uploadId, space, userName, folderId, folderPath, conflict, identity, ownerId, authenticatedUserId);
    }

    public List<TrashElementNode> getDeletedDocuments(TrashElementNodeFilter filter) throws RepositoryException {
        return this.jcrDeleteFileStorage.getDeletedDocuments(filter);
    }

    public int countDeletedDocuments() {
        return this.jcrDeleteFileStorage.countDeletedDocuments();
    }

    public void restoreDocumentFromTrash(String trashNodePath) throws RepositoryException {
        this.jcrDeleteFileStorage.restoreFromTrash(trashNodePath);
    }

    public void deleteDocumentPermanently(String documentPath) throws ObjectNotFoundException, RepositoryException {
        this.jcrDeleteFileStorage.deleteDocumentPermanently(documentPath);
    }

    public void deleteDocumentsPermanently(int actionId, List<AbstractNode> trashElementNodes, long userIdentityId) throws IllegalAccessException {
        this.jcrDeleteFileStorage.deleteDocumentsPermanently(actionId, trashElementNodes, this.getAclUserIdentity(userIdentityId));
    }

    public void restoreDocuments(int actionId, List<AbstractNode> trashElementNodes, long userIdentityId) throws IllegalAccessException {
        this.jcrDeleteFileStorage.restoreDocuments(actionId, trashElementNodes, this.getAclUserIdentity(userIdentityId));
    }
}

